/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.coderbot.iris.vendored.joml.Matrix3x2f;

public class Matrix3x2fStack
extends Matrix3x2f {
    private static final long serialVersionUID = 1L;
    private Matrix3x2f[] mats;
    private int curr;

    public Matrix3x2fStack(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("stackSize must be >= 1");
        }
        this.mats = new Matrix3x2f[n - 1];
        for (int i = 0; i < this.mats.length; ++i) {
            this.mats[i] = new Matrix3x2f();
        }
    }

    public Matrix3x2fStack() {
    }

    public Matrix3x2fStack clear() {
        this.curr = 0;
        this.identity();
        return this;
    }

    public Matrix3x2fStack pushMatrix() {
        if (this.curr == this.mats.length) {
            throw new IllegalStateException("max stack size of " + (this.curr + 1) + " reached");
        }
        this.mats[this.curr++].set(this);
        return this;
    }

    public Matrix3x2fStack popMatrix() {
        if (this.curr == 0) {
            throw new IllegalStateException("already at the buttom of the stack");
        }
        this.set(this.mats[--this.curr]);
        return this;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.curr;
        for (int i = 0; i < this.curr; ++i) {
            n = 31 * n + this.mats[i].hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof Matrix3x2fStack) {
            Matrix3x2fStack matrix3x2fStack = (Matrix3x2fStack)object;
            if (this.curr != matrix3x2fStack.curr) {
                return false;
            }
            for (int i = 0; i < this.curr; ++i) {
                if (this.mats[i].equals(matrix3x2fStack.mats[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.curr);
        for (int i = 0; i < this.curr; ++i) {
            objectOutput.writeObject(this.mats[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        super.readExternal(objectInput);
        this.curr = objectInput.readInt();
        this.mats = new Matrix3x2fStack[this.curr];
        for (int i = 0; i < this.curr; ++i) {
            Matrix3x2f matrix3x2f = new Matrix3x2f();
            matrix3x2f.readExternal(objectInput);
            this.mats[i] = matrix3x2f;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Matrix3x2fStack matrix3x2fStack = (Matrix3x2fStack)super.clone();
        Matrix3x2f[] matrix3x2fArray = new Matrix3x2f[this.mats.length];
        for (int i = 0; i < this.mats.length; ++i) {
            matrix3x2fArray[i] = (Matrix3x2f)this.mats[i].clone();
        }
        matrix3x2fStack.mats = matrix3x2fArray;
        return matrix3x2fStack;
    }
}

