/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform.transformer;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.abstract_node.ASTNode;
import io.github.douira.glsl_transformer.ast.node.declaration.DeclarationMember;
import io.github.douira.glsl_transformer.ast.node.declaration.FunctionParameter;
import io.github.douira.glsl_transformer.ast.node.declaration.TypeAndInitDeclaration;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.expression.LiteralExpression;
import io.github.douira.glsl_transformer.ast.node.expression.ReferenceExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.FunctionCallExpression;
import io.github.douira.glsl_transformer.ast.node.external_declaration.DeclarationExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.EmptyDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.FunctionDefinition;
import io.github.douira.glsl_transformer.ast.node.statement.Statement;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.StorageQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.TypeQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.TypeQualifierPart;
import io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinNumericTypeSpecifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.FunctionPrototype;
import io.github.douira.glsl_transformer.ast.node.type.specifier.TypeSpecifier;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.index.PrefixIdentifierIndex;
import io.github.douira.glsl_transformer.ast.query.match.AutoHintedMatcher;
import io.github.douira.glsl_transformer.ast.query.match.Matcher;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import io.github.douira.glsl_transformer.ast.transform.Template;
import io.github.douira.glsl_transformer.util.Type;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.parameter.Parameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompatibilityTransformer {
    static Logger LOGGER = LogManager.getLogger(CompatibilityTransformer.class);
    private static final AutoHintedMatcher<Expression> sildursWaterFract = new AutoHintedMatcher("fract(worldpos.y + 0.001)", Matcher.expressionPattern);
    private static List<String> reservedWords = List.of("texture");
    private static final ShaderType[] pipeline = new ShaderType[]{ShaderType.VERTEX, ShaderType.GEOMETRY, ShaderType.FRAGMENT};
    private static final Matcher<ExternalDeclaration> outDeclarationMatcher = new DeclarationMatcher(StorageQualifier.StorageType.OUT);
    private static final Matcher<ExternalDeclaration> inDeclarationMatcher = new DeclarationMatcher(StorageQualifier.StorageType.IN);
    private static final String tagPrefix = "iris_template_";
    private static final Template<ExternalDeclaration> declarationTemplate = Template.withExternalDeclaration((String)"out __type __name;");
    private static final Template<Statement> initTemplate = Template.withStatement((String)"__decl = __value;");
    private static final Template<ExternalDeclaration> variableTemplate = Template.withExternalDeclaration((String)"__type __internalDecl;");
    private static final Template<Statement> statementTemplate = Template.withStatement((String)"__oldDecl = vec3(__internalDecl);");
    private static final Template<Statement> statementTemplateVector = Template.withStatement((String)"__oldDecl = vec3(__internalDecl, vec4(0));");

    private static StorageQualifier getConstQualifier(TypeQualifier typeQualifier) {
        if (typeQualifier == null) {
            return null;
        }
        for (TypeQualifierPart typeQualifierPart : typeQualifier.getChildren()) {
            if (!(typeQualifierPart instanceof StorageQualifier)) continue;
            StorageQualifier storageQualifier = (StorageQualifier)typeQualifierPart;
            if (storageQualifier.storageType != StorageQualifier.StorageType.CONST) continue;
            return storageQualifier;
        }
        return null;
    }

    public static void transformEach(ASTParser aSTParser, TranslationUnit translationUnit, Root root, Parameters parameters) {
        boolean bl;
        Object object;
        String string;
        Object object2;
        Object object322;
        if (parameters.type == PatchShaderType.VERTEX && root.replaceExpressionMatches(aSTParser, sildursWaterFract, "fract(worldpos.y + 0.01)")) {
            Iris.logger.warn("Patched fract(worldpos.y + 0.001) to fract(worldpos.y + 0.01) to fix waving water disconnecting from other water blocks; See https://github.com/IrisShaders/Iris/issues/509");
        }
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object322 : root.nodeIndex.get(FunctionDefinition.class)) {
            object2 = object322.getFunctionPrototype();
            String string2 = object2.getName().getName();
            if (!string2.equals("main") && root.identifierIndex.getStream(string2).count() <= 1L) {
                linkedList.add(object322);
                if (!PatchedShaderPrinter.prettyPrintShaders) continue;
                LOGGER.warn("Removing unused function " + string2);
                continue;
            }
            if (object2.getChildren().isEmpty()) continue;
            HashSet<String> object4 = new HashSet<String>(object2.getChildren().size());
            for (FunctionParameter functionParameter : object2.getChildren()) {
                if (CompatibilityTransformer.getConstQualifier(functionParameter.getType().getTypeQualifier()) == null) continue;
                string = functionParameter.getName().getName();
                object4.add(string);
                hashSet.add(string);
            }
            if (object4.isEmpty()) continue;
            hashMap.put(object322, object4);
        }
        for (Object object322 : linkedList) {
            object322.detachAndDelete();
        }
        boolean bl2 = false;
        object322 = new ArrayDeque(hashSet);
        while (!object322.isEmpty()) {
            object2 = (String)object322.poll();
            hashSet.remove(object2);
            for (Identifier identifier2 : root.identifierIndex.get((String)object2)) {
                TypeQualifier typeQualifier;
                StorageQualifier storageQualifier;
                Set set;
                FunctionParameter functionParameter;
                object = (ReferenceExpression)identifier2.getAncestor(ReferenceExpression.class);
                if (object == null || (functionParameter = (TypeAndInitDeclaration)object.getAncestor(TypeAndInitDeclaration.class)) == null || (string = (FunctionDefinition)functionParameter.getAncestor(FunctionDefinition.class)) == null || (set = (Set)hashMap.get(string)) == null || !set.contains(object2) || (storageQualifier = CompatibilityTransformer.getConstQualifier(typeQualifier = functionParameter.getType().getTypeQualifier())) == null) continue;
                storageQualifier.detachAndDelete();
                if (typeQualifier.getChildren().isEmpty()) {
                    typeQualifier.detachAndDelete();
                }
                bl2 = true;
                for (DeclarationMember declarationMember : functionParameter.getMembers()) {
                    String string2 = declarationMember.getName().getName();
                    if (set.contains(string2)) {
                        throw new IllegalStateException("Illegal redefinition of const parameter " + (String)object2);
                    }
                    set.add(string2);
                    if (hashSet.contains(string2)) continue;
                    object322.add(string2);
                    hashSet.add(string2);
                }
            }
        }
        if (bl2) {
            LOGGER.warn("Removed the const keyword from declarations that use const parameters. See debugging.md for more information.");
        }
        if (bl = root.process(root.nodeIndex.getStream(EmptyDeclaration.class), ASTNode::detachAndDelete)) {
            LOGGER.warn("Removed empty external declarations (\";\").");
        }
        for (String string3 : reservedWords) {
            object = "iris_renamed_" + string3;
            if (!root.process(root.identifierIndex.getStream(string3).filter(identifier -> !(identifier.getParent() instanceof FunctionCallExpression) && !(identifier.getParent() instanceof FunctionPrototype)), arg_0 -> CompatibilityTransformer.lambda$transformEach$1((String)object, arg_0))) continue;
            LOGGER.warn("Renamed reserved word \"" + string3 + "\" to \"" + (String)object + "\".");
        }
    }

    private static Statement getInitializer(Root root, String string, Type type) {
        return (Statement)initTemplate.getInstanceFor(root, new ASTNode[]{new Identifier(string), type.isScalar() ? LiteralExpression.getDefaultValue((Type)type) : Root.indexNodes((Root)root, () -> new FunctionCallExpression(new Identifier(type.getMostCompactName()), Stream.of(LiteralExpression.getDefaultValue((Type)type))))});
    }

    private static TypeQualifier makeQualifierOut(TypeQualifier typeQualifier) {
        for (TypeQualifierPart typeQualifierPart : typeQualifier.getParts()) {
            if (!(typeQualifierPart instanceof StorageQualifier)) continue;
            StorageQualifier storageQualifier = (StorageQualifier)typeQualifierPart;
            if (((StorageQualifier)typeQualifierPart).storageType != StorageQualifier.StorageType.IN) continue;
            storageQualifier.storageType = StorageQualifier.StorageType.OUT;
        }
        return typeQualifier;
    }

    public static void transformGrouped(ASTParser aSTParser, Map<PatchShaderType, TranslationUnit> map, Parameters parameters) {
        ShaderType shaderType = null;
        for (int i = 0; i < pipeline.length; ++i) {
            Object object;
            TranslationUnit translationUnit;
            Object object22;
            ShaderType shaderType2 = pipeline[i];
            PatchShaderType[] patchShaderTypeArray = PatchShaderType.fromGlShaderType(shaderType2);
            boolean bl = false;
            for (Object object22 : patchShaderTypeArray) {
                if (map.get(object22) == null) continue;
                bl = true;
            }
            if (!bl) continue;
            if (shaderType == null) {
                shaderType = shaderType2;
                continue;
            }
            PatchShaderType patchShaderType = PatchShaderType.fromGlShaderType(shaderType)[0];
            TranslationUnit translationUnit2 = map.get((Object)patchShaderType);
            Root root = translationUnit2.getRoot();
            if (((PrefixIdentifierIndex)root.identifierIndex).prefixQueryFlat(tagPrefix).findAny().isPresent()) {
                LOGGER.warn("The prefix tag iris_template_ is used in the shader, bailing compatibility transformation.");
                return;
            }
            object22 = new HashMap();
            for (DeclarationExternalDeclaration declarationExternalDeclaration : root.nodeIndex.get(DeclarationExternalDeclaration.class)) {
                if (!outDeclarationMatcher.matchesExtract((ASTNode)declarationExternalDeclaration)) continue;
                BuiltinNumericTypeSpecifier builtinNumericTypeSpecifier = (BuiltinNumericTypeSpecifier)outDeclarationMatcher.getNodeMatch("type", BuiltinNumericTypeSpecifier.class);
                Object object3 = ((TypeAndInitDeclaration)((DeclarationMember)outDeclarationMatcher.getNodeMatch("name*", DeclarationMember.class)).getAncestor(TypeAndInitDeclaration.class)).getMembers().iterator();
                while (object3.hasNext()) {
                    translationUnit = (DeclarationMember)object3.next();
                    object = translationUnit.getName().getName();
                    if (((String)object).startsWith("gl_")) continue;
                    object22.put(object, builtinNumericTypeSpecifier);
                }
            }
            for (Object object3 : patchShaderTypeArray) {
                translationUnit = map.get(object3);
                if (translationUnit == null) continue;
                object = translationUnit.getRoot();
                for (ExternalDeclaration externalDeclaration : ((Root)object).nodeIndex.get(DeclarationExternalDeclaration.class)) {
                    if (!inDeclarationMatcher.matchesExtract((ASTNode)externalDeclaration)) continue;
                    BuiltinNumericTypeSpecifier builtinNumericTypeSpecifier = (BuiltinNumericTypeSpecifier)inDeclarationMatcher.getNodeMatch("type", BuiltinNumericTypeSpecifier.class);
                    for (DeclarationMember declarationMember : ((TypeAndInitDeclaration)((DeclarationMember)inDeclarationMatcher.getNodeMatch("name*", DeclarationMember.class)).getAncestor(TypeAndInitDeclaration.class)).getMembers()) {
                        Type type;
                        BuiltinNumericTypeSpecifier builtinNumericTypeSpecifier2;
                        String string = declarationMember.getName().getName();
                        if (string.startsWith("gl_")) continue;
                        if (!object22.containsKey(string)) {
                            if (!((Root)object).identifierIndex.getAncestors(string, ReferenceExpression.class).findAny().isPresent()) continue;
                            if (builtinNumericTypeSpecifier == null) {
                                LOGGER.warn("The in declaration '" + string + "' in the " + object3.glShaderType.name() + " shader that has a missing corresponding out declaration in the previous stage " + shaderType.name() + " has a non-numeric type and could not be compatibility-patched. See debugging.md for more information.");
                                continue;
                            }
                            builtinNumericTypeSpecifier2 = builtinNumericTypeSpecifier.type;
                            type = (TypeQualifier)inDeclarationMatcher.getNodeMatch("qualifier").cloneInto(root);
                            CompatibilityTransformer.makeQualifierOut((TypeQualifier)type);
                            translationUnit2.injectNode(ASTInjectionPoint.BEFORE_DECLARATIONS, (ExternalDeclaration)declarationTemplate.getInstanceFor(root, new ASTNode[]{type, builtinNumericTypeSpecifier.cloneInto(root), new Identifier(string)}));
                            translationUnit2.prependMainFunctionBody(CompatibilityTransformer.getInitializer(root, string, (Type)builtinNumericTypeSpecifier2));
                            object22.put(string, null);
                            LOGGER.warn("The in declaration '" + string + "' in the " + object3.glShaderType.name() + " shader is missing a corresponding out declaration in the previous stage " + shaderType.name() + " and has been compatibility-patched. See debugging.md for more information.");
                            continue;
                        }
                        builtinNumericTypeSpecifier2 = (BuiltinNumericTypeSpecifier)object22.get(string);
                        if (builtinNumericTypeSpecifier2 == null) continue;
                        type = builtinNumericTypeSpecifier.type;
                        Type type2 = builtinNumericTypeSpecifier2.type;
                        if (type == type2) {
                            if (root.identifierIndex.get(string).size() > 1) continue;
                            translationUnit2.prependMainFunctionBody(CompatibilityTransformer.getInitializer(root, string, type));
                            object22.put(string, null);
                            continue;
                        }
                        if (type2.getDimension() != type.getDimension()) {
                            LOGGER.warn("The in declaration '" + string + "' in the " + object3.glShaderType.name() + " shader has a mismatching dimensionality (scalar/vector/matrix) with the out declaration in the previous stage " + shaderType.name() + " and could not be compatibility-patched. See debugging.md for more information.");
                            continue;
                        }
                        boolean bl2 = type2.isVector();
                        String string2 = tagPrefix + string;
                        root.identifierIndex.rename(string, string2);
                        TypeAndInitDeclaration typeAndInitDeclaration = (TypeAndInitDeclaration)builtinNumericTypeSpecifier2.getAncestor(TypeAndInitDeclaration.class);
                        if (typeAndInitDeclaration == null) continue;
                        List list = typeAndInitDeclaration.getMembers();
                        DeclarationMember declarationMember2 = null;
                        for (DeclarationMember declarationMember3 : list) {
                            if (!declarationMember3.getName().getName().equals(string2)) continue;
                            declarationMember2 = declarationMember3;
                        }
                        if (declarationMember2 == null) {
                            throw new IllegalStateException("The targeted out declaration member is missing!");
                        }
                        declarationMember2.getName().replaceByAndDelete((ASTNode)new Identifier(string));
                        if (list.size() > 1) {
                            declarationMember2.detach();
                            builtinNumericTypeSpecifier2 = builtinNumericTypeSpecifier2.cloneInto(root);
                            DeclarationExternalDeclaration declarationExternalDeclaration = (DeclarationExternalDeclaration)declarationTemplate.getInstanceFor(root, new ASTNode[]{CompatibilityTransformer.makeQualifierOut(typeAndInitDeclaration.getType().getTypeQualifier().cloneInto(root)), builtinNumericTypeSpecifier2, new Identifier(string)});
                            ((TypeAndInitDeclaration)declarationExternalDeclaration.getDeclaration()).getMembers().set(0, declarationMember2);
                            translationUnit2.injectNode(ASTInjectionPoint.BEFORE_DECLARATIONS, (ExternalDeclaration)declarationExternalDeclaration);
                        }
                        translationUnit2.injectNode(ASTInjectionPoint.BEFORE_DECLARATIONS, (ExternalDeclaration)variableTemplate.getInstanceFor(root, new ASTNode[]{builtinNumericTypeSpecifier2.cloneInto(root), new Identifier(string2)}));
                        translationUnit2.appendMainFunctionBody((Statement)(bl2 && type2.getDimensions()[0] < type.getDimensions()[0] ? statementTemplateVector : statementTemplate).getInstanceFor(root, new ASTNode[]{new Identifier(string), new Identifier(string2), builtinNumericTypeSpecifier.cloneInto(root)}));
                        builtinNumericTypeSpecifier2.replaceByAndDelete((ASTNode)builtinNumericTypeSpecifier.cloneInto(root));
                        object22.put(string, null);
                        LOGGER.warn("The out declaration '" + string + "' in the " + shaderType.name() + " shader has a different type " + type2.getMostCompactName() + " than the corresponding in declaration of type " + type.getMostCompactName() + " in the following stage " + object3.glShaderType.name() + " and has been compatibility-patched. See debugging.md for more information.");
                    }
                }
            }
            shaderType = shaderType2;
        }
    }

    private static /* synthetic */ void lambda$transformEach$1(String string, Identifier identifier) {
        identifier.setName(string);
    }

    static {
        declarationTemplate.markLocalReplacement(CompatibilityTransformer.declarationTemplate.getSourceRoot().nodeIndex.getUnique(TypeQualifier.class));
        declarationTemplate.markLocalReplacement("__type", TypeSpecifier.class);
        declarationTemplate.markIdentifierReplacement("__name");
        initTemplate.markIdentifierReplacement("__decl");
        initTemplate.markLocalReplacement("__value", ReferenceExpression.class);
        variableTemplate.markLocalReplacement("__type", TypeSpecifier.class);
        variableTemplate.markIdentifierReplacement("__internalDecl");
        statementTemplate.markIdentifierReplacement("__oldDecl");
        statementTemplate.markIdentifierReplacement("__internalDecl");
        statementTemplate.markLocalReplacement((ASTNode)CompatibilityTransformer.statementTemplate.getSourceRoot().nodeIndex.getStream(BuiltinNumericTypeSpecifier.class).filter(builtinNumericTypeSpecifier -> builtinNumericTypeSpecifier.type == Type.F32VEC3).findAny().get());
        statementTemplateVector.markIdentifierReplacement("__oldDecl");
        statementTemplateVector.markIdentifierReplacement("__internalDecl");
        statementTemplateVector.markLocalReplacement((ASTNode)CompatibilityTransformer.statementTemplateVector.getSourceRoot().nodeIndex.getStream(BuiltinNumericTypeSpecifier.class).filter(builtinNumericTypeSpecifier -> builtinNumericTypeSpecifier.type == Type.F32VEC3).findAny().get());
    }

    private static class DeclarationMatcher
    extends Matcher<ExternalDeclaration> {
        private final StorageQualifier.StorageType storageType;

        public DeclarationMatcher(StorageQualifier.StorageType storageType) {
            super("out float name;", Matcher.externalDeclarationPattern);
            this.markClassWildcard("qualifier", ((ExternalDeclaration)this.pattern).getRoot().nodeIndex.getUnique(TypeQualifier.class));
            this.markClassWildcard("type", ((ExternalDeclaration)this.pattern).getRoot().nodeIndex.getUnique(BuiltinNumericTypeSpecifier.class));
            this.markClassWildcard("name*", ((ExternalDeclaration)this.pattern).getRoot().identifierIndex.getUnique("name").getAncestor(DeclarationMember.class));
            this.storageType = storageType;
        }

        public boolean matchesExtract(ExternalDeclaration externalDeclaration) {
            boolean bl = super.matchesExtract((ASTNode)externalDeclaration);
            if (!bl) {
                return false;
            }
            TypeQualifier typeQualifier = (TypeQualifier)this.getNodeMatch("qualifier", TypeQualifier.class);
            for (TypeQualifierPart typeQualifierPart : typeQualifier.getParts()) {
                if (!(typeQualifierPart instanceof StorageQualifier)) continue;
                StorageQualifier storageQualifier = (StorageQualifier)typeQualifierPart;
                if (storageQualifier.storageType != this.storageType) continue;
                return true;
            }
            return false;
        }
    }
}

