/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.program;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import net.coderbot.iris.gl.uniform.DynamicLocationalUniformHolder;
import net.coderbot.iris.gl.uniform.Uniform;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformType;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.minecraft.class_310;
import org.lwjgl.BufferUtils;

public class ProgramUniforms {
    private static ProgramUniforms active;
    private final ImmutableList<Uniform> perTick;
    private final ImmutableList<Uniform> perFrame;
    private final ImmutableList<Uniform> dynamic;
    private final ImmutableList<ValueUpdateNotifier> notifiersToReset;
    private ImmutableList<Uniform> once;
    long lastTick = -1L;
    int lastFrame = -1;

    public ProgramUniforms(ImmutableList<Uniform> immutableList, ImmutableList<Uniform> immutableList2, ImmutableList<Uniform> immutableList3, ImmutableList<Uniform> immutableList4, ImmutableList<ValueUpdateNotifier> immutableList5) {
        this.once = immutableList;
        this.perTick = immutableList2;
        this.perFrame = immutableList3;
        this.dynamic = immutableList4;
        this.notifiersToReset = immutableList5;
    }

    private void updateStage(ImmutableList<Uniform> immutableList) {
        for (Uniform uniform : immutableList) {
            uniform.update();
        }
    }

    private static long getCurrentTick() {
        return Objects.requireNonNull(class_310.method_1551().field_1687).method_8510();
    }

    public void update() {
        int n;
        if (active != null) {
            active.removeListeners();
        }
        active = this;
        this.updateStage(this.dynamic);
        if (this.once != null) {
            this.updateStage(this.once);
            this.updateStage(this.perTick);
            this.updateStage(this.perFrame);
            this.lastTick = ProgramUniforms.getCurrentTick();
            this.once = null;
            return;
        }
        long l = ProgramUniforms.getCurrentTick();
        if (this.lastTick != l) {
            this.lastTick = l;
            this.updateStage(this.perTick);
        }
        if (this.lastFrame != (n = SystemTimeUniforms.COUNTER.getAsInt())) {
            this.lastFrame = n;
            this.updateStage(this.perFrame);
        }
    }

    public void removeListeners() {
        active = null;
        for (ValueUpdateNotifier valueUpdateNotifier : this.notifiersToReset) {
            valueUpdateNotifier.setListener(null);
        }
    }

    public static void clearActiveUniforms() {
        if (active != null) {
            active.removeListeners();
        }
    }

    public static Builder builder(String string, int n) {
        return new Builder(string, n);
    }

    private static String getTypeName(int n) {
        Object object = n == 5126 ? "float" : (n == 5124 ? "int" : (n == 35676 ? "mat4" : (n == 35666 ? "vec4" : (n == 35675 ? "mat3" : (n == 35665 ? "vec3" : (n == 35674 ? "mat2" : (n == 35664 ? "vec2" : (n == 35667 ? "ivec2" : (n == 35669 ? "ivec4" : (n == 35679 ? "sampler3D" : (n == 35678 ? "sampler2D" : (n == 36306 ? "usampler2D" : (n == 36307 ? "usampler3D" : (n == 35677 ? "sampler1D" : (n == 35682 ? "sampler2DShadow" : (n == 35681 ? "sampler1DShadow" : (n == 36941 ? "image2D" : (n == 36942 ? "image3D" : "(unknown:" + n + ")"))))))))))))))))));
        return object;
    }

    private static UniformType getExpectedType(int n) {
        if (n == 5126) {
            return UniformType.FLOAT;
        }
        if (n == 5124) {
            return UniformType.INT;
        }
        if (n == 35670) {
            return UniformType.INT;
        }
        if (n == 35676) {
            return UniformType.MAT4;
        }
        if (n == 35666) {
            return UniformType.VEC4;
        }
        if (n == 35669) {
            return UniformType.VEC4I;
        }
        if (n == 35675) {
            return UniformType.MAT3;
        }
        if (n == 35665) {
            return UniformType.VEC3;
        }
        if (n == 35668) {
            return null;
        }
        if (n == 35674) {
            return null;
        }
        if (n == 35664) {
            return UniformType.VEC2;
        }
        if (n == 35667) {
            return UniformType.VEC2I;
        }
        if (n == 35679) {
            return UniformType.INT;
        }
        if (n == 35678) {
            return UniformType.INT;
        }
        if (n == 36306) {
            return UniformType.INT;
        }
        if (n == 36307) {
            return UniformType.INT;
        }
        if (n == 35677) {
            return UniformType.INT;
        }
        if (n == 35682) {
            return UniformType.INT;
        }
        if (n == 35681) {
            return UniformType.INT;
        }
        return null;
    }

    private static boolean isSampler(int n) {
        return n == 35677 || n == 35678 || n == 36306 || n == 36307 || n == 35679 || n == 35681 || n == 35682;
    }

    private static boolean isImage(int n) {
        return n == 36940 || n == 36941 || n == 36963 || n == 36942 || n == 36946 || n == 36947;
    }

    public static class Builder
    implements DynamicLocationalUniformHolder {
        private final String name;
        private final int program;
        private final Map<Integer, String> locations;
        private final Map<String, Uniform> once;
        private final Map<String, Uniform> perTick;
        private final Map<String, Uniform> perFrame;
        private final Map<String, Uniform> dynamic;
        private final Map<String, UniformType> uniformNames;
        private final Map<String, UniformType> externalUniformNames;
        private final List<ValueUpdateNotifier> notifiersToReset;

        protected Builder(String string, int n) {
            this.name = string;
            this.program = n;
            this.locations = new HashMap<Integer, String>();
            this.once = new HashMap<String, Uniform>();
            this.perTick = new HashMap<String, Uniform>();
            this.perFrame = new HashMap<String, Uniform>();
            this.dynamic = new HashMap<String, Uniform>();
            this.uniformNames = new HashMap<String, UniformType>();
            this.externalUniformNames = new HashMap<String, UniformType>();
            this.notifiersToReset = new ArrayList<ValueUpdateNotifier>();
        }

        @Override
        public Builder addUniform(UniformUpdateFrequency uniformUpdateFrequency, Uniform uniform) {
            Objects.requireNonNull(uniform);
            switch (uniformUpdateFrequency) {
                case ONCE: {
                    this.once.put(this.locations.get(uniform.getLocation()), uniform);
                    break;
                }
                case PER_TICK: {
                    this.perTick.put(this.locations.get(uniform.getLocation()), uniform);
                    break;
                }
                case PER_FRAME: {
                    this.perFrame.put(this.locations.get(uniform.getLocation()), uniform);
                }
            }
            return this;
        }

        @Override
        public OptionalInt location(String string, UniformType uniformType) {
            int n = GlStateManager._glGetUniformLocation((int)this.program, (CharSequence)string);
            if (n == -1) {
                return OptionalInt.empty();
            }
            if ((this.locations.containsKey(n) || this.uniformNames.containsKey(string)) && !string.equals("framemod8")) {
                Iris.logger.warn("[" + this.name + "] Duplicate uniform: " + uniformType.toString().toLowerCase() + " " + string);
                return OptionalInt.empty();
            }
            this.locations.put(n, string);
            this.uniformNames.put(string, uniformType);
            return OptionalInt.of(n);
        }

        public ProgramUniforms buildUniforms() {
            int n = GlStateManager.glGetProgrami((int)this.program, (int)35718);
            IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
            IntBuffer intBuffer2 = BufferUtils.createIntBuffer((int)1);
            for (int i = 0; i < n; ++i) {
                Object object;
                String string = IrisRenderSystem.getActiveUniform(this.program, i, 128, intBuffer, intBuffer2);
                if (string.isEmpty()) continue;
                int n2 = intBuffer.get(0);
                int n3 = intBuffer2.get(0);
                UniformType uniformType = this.uniformNames.get(string);
                UniformType uniformType2 = ProgramUniforms.getExpectedType(n3);
                if (uniformType == null && !string.startsWith("gl_")) {
                    object = ProgramUniforms.getTypeName(n3);
                    if (ProgramUniforms.isSampler(n3) || ProgramUniforms.isImage(n3)) continue;
                    UniformType uniformType3 = this.externalUniformNames.get(string);
                    if (uniformType3 != null) {
                        if (uniformType3 == uniformType2) continue;
                        Object object2 = uniformType2 != null ? uniformType2.toString() : "(unsupported type: " + ProgramUniforms.getTypeName(n3) + ")";
                        Iris.logger.error("[" + this.name + "] Wrong uniform type for externally-managed uniform " + string + ": " + uniformType3 + " is provided but the program expects " + (String)object2 + ".");
                        continue;
                    }
                    if (string.startsWith("Chunks[")) continue;
                    if (n2 == 1) {
                        Iris.logger.warn("[" + this.name + "] Unsupported uniform: " + (String)object + " " + string);
                        continue;
                    }
                    Iris.logger.warn("[" + this.name + "] Unsupported uniform: " + string + " of size " + n2 + " and type " + (String)object);
                    continue;
                }
                if ("framemod8".equals(string) && uniformType2 == UniformType.FLOAT && uniformType == UniformType.INT) {
                    SystemTimeUniforms.addFloatFrameMod8Uniform(this);
                    uniformType = UniformType.FLOAT;
                }
                if (uniformType == null || uniformType == uniformType2) continue;
                object = uniformType2 != null ? uniformType2.toString() : "(unsupported type: " + ProgramUniforms.getTypeName(n3) + ")";
                Iris.logger.error("[" + this.name + "] Wrong uniform type for " + string + ": Iris is providing " + uniformType + " but the program expects " + (String)object + ". Disabling that uniform.");
                this.once.remove(string);
                this.perTick.remove(string);
                this.perFrame.remove(string);
                this.dynamic.remove(string);
            }
            return new ProgramUniforms((ImmutableList<Uniform>)ImmutableList.copyOf(this.once.values()), (ImmutableList<Uniform>)ImmutableList.copyOf(this.perTick.values()), (ImmutableList<Uniform>)ImmutableList.copyOf(this.perFrame.values()), (ImmutableList<Uniform>)ImmutableList.copyOf(this.dynamic.values()), (ImmutableList<ValueUpdateNotifier>)ImmutableList.copyOf(this.notifiersToReset));
        }

        @Override
        public Builder addDynamicUniform(Uniform uniform, ValueUpdateNotifier valueUpdateNotifier) {
            Objects.requireNonNull(uniform);
            Objects.requireNonNull(valueUpdateNotifier);
            this.dynamic.put(this.locations.get(uniform.getLocation()), uniform);
            this.notifiersToReset.add(valueUpdateNotifier);
            return this;
        }

        @Override
        public UniformHolder externallyManagedUniform(String string, UniformType uniformType) {
            this.externalUniformNames.put(string, uniformType);
            return this;
        }
    }
}

