/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin;

import java.util.List;
import java.util.Set;
import net.coderbot.iris.compat.sodium.SodiumVersionCheck;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class IrisSodiumCompatMixinPlugin
implements IMixinConfigPlugin {
    private boolean validSodiumVersion = false;

    public void onLoad(String string) {
        this.validSodiumVersion = FabricLoader.getInstance().getModContainer("sodium").map(modContainer -> {
            String string = modContainer.getMetadata().getVersion().getFriendlyString();
            return SodiumVersionCheck.isAllowedVersion(string);
        }).orElse(false);
        if (!this.validSodiumVersion) {
            System.err.println("[Iris] Invalid/missing version of Sodium detected, disabling compatibility mixins!");
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String string, String string2) {
        return this.validSodiumVersion;
    }

    public void acceptTargets(Set<String> set, Set<String> set2) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String string, ClassNode classNode, String string2, IMixinInfo iMixinInfo) {
    }

    public void postApply(String string, ClassNode classNode, String string2, IMixinInfo iMixinInfo) {
    }
}

