/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.helper;

import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1160;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public abstract class GeometryHelper {
    public static final int CUBIC_FLAG = 1;
    public static final int AXIS_ALIGNED_FLAG = 2;
    public static final int LIGHT_FACE_FLAG = 4;
    public static final int FLAG_BIT_COUNT = 3;
    private static final float EPS_MIN = 1.0E-4f;
    private static final float EPS_MAX = 0.9999f;

    private GeometryHelper() {
    }

    public static int computeShapeFlags(QuadView quad) {
        class_2350 lightFace = quad.lightFace();
        int bits = 0;
        if (GeometryHelper.isQuadParallelToFace(lightFace, quad)) {
            bits |= 2;
            if (GeometryHelper.isParallelQuadOnFace(lightFace, quad)) {
                bits |= 4;
            }
        }
        if (GeometryHelper.isQuadCubic(lightFace, quad)) {
            bits |= 1;
        }
        return bits;
    }

    public static boolean isQuadParallelToFace(class_2350 face, QuadView quad) {
        if (face == null) {
            return false;
        }
        int i = face.method_10166().ordinal();
        float val = quad.posByIndex(0, i);
        return class_3532.method_15347((float)val, (float)quad.posByIndex(1, i)) && class_3532.method_15347((float)val, (float)quad.posByIndex(2, i)) && class_3532.method_15347((float)val, (float)quad.posByIndex(3, i));
    }

    public static boolean isParallelQuadOnFace(class_2350 lightFace, QuadView quad) {
        if (lightFace == null) {
            return false;
        }
        float x = quad.posByIndex(0, lightFace.method_10166().ordinal());
        return lightFace.method_10171() == class_2350.class_2352.field_11056 ? x >= 0.9999f : x <= 1.0E-4f;
    }

    public static boolean isQuadCubic(@NotNull class_2350 lightFace, QuadView quad) {
        int b;
        int a;
        if (lightFace == null) {
            return false;
        }
        switch (lightFace) {
            case field_11034: 
            case field_11039: {
                a = 1;
                b = 2;
                break;
            }
            case field_11036: 
            case field_11033: {
                a = 0;
                b = 2;
                break;
            }
            case field_11035: 
            case field_11043: {
                a = 1;
                b = 0;
                break;
            }
            default: {
                return false;
            }
        }
        return GeometryHelper.confirmSquareCorners(a, b, quad);
    }

    private static boolean confirmSquareCorners(int aCoordinate, int bCoordinate, QuadView quad) {
        int flags = 0;
        for (int i = 0; i < 4; ++i) {
            float a = quad.posByIndex(i, aCoordinate);
            float b = quad.posByIndex(i, bCoordinate);
            if (a <= 1.0E-4f) {
                if (b <= 1.0E-4f) {
                    flags |= 1;
                    continue;
                }
                if (b >= 0.9999f) {
                    flags |= 2;
                    continue;
                }
                return false;
            }
            if (a >= 0.9999f) {
                if (b <= 1.0E-4f) {
                    flags |= 4;
                    continue;
                }
                if (b >= 0.9999f) {
                    flags |= 8;
                    continue;
                }
                return false;
            }
            return false;
        }
        return flags == 15;
    }

    public static class_2350 lightFace(QuadView quad) {
        class_1160 normal = quad.faceNormal();
        switch (GeometryHelper.longestAxis(normal)) {
            case field_11048: {
                return normal.method_4943() > 0.0f ? class_2350.field_11034 : class_2350.field_11039;
            }
            case field_11052: {
                return normal.method_4945() > 0.0f ? class_2350.field_11036 : class_2350.field_11033;
            }
            case field_11051: {
                return normal.method_4947() > 0.0f ? class_2350.field_11035 : class_2350.field_11043;
            }
        }
        return class_2350.field_11036;
    }

    public static float min(float a, float b, float c, float d) {
        float x = a < b ? a : b;
        float y = c < d ? c : d;
        return x < y ? x : y;
    }

    public static float max(float a, float b, float c, float d) {
        float x = a > b ? a : b;
        float y = c > d ? c : d;
        return x > y ? x : y;
    }

    public static class_2350.class_2351 longestAxis(class_1160 vec) {
        return GeometryHelper.longestAxis(vec.method_4943(), vec.method_4945(), vec.method_4947());
    }

    public static class_2350.class_2351 longestAxis(float normalX, float normalY, float normalZ) {
        class_2350.class_2351 result = class_2350.class_2351.field_11052;
        float longest = Math.abs(normalY);
        float a = Math.abs(normalX);
        if (a > longest) {
            result = class_2350.class_2351.field_11048;
            longest = a;
        }
        return Math.abs(normalZ) > longest ? class_2350.class_2351.field_11051 : result;
    }
}

