/*
 * Decompiled with CFR 0.152.
 */
package opekope2.optigui.util;

import java.time.LocalDateTime;
import java.time.Month;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import opekope2.optigui.interfaces.Setter;
import opekope2.optigui.interfaces.TextureRemapper;
import opekope2.optigui.util.BuiltinTexturePath;
import opekope2.optigui.util.ID;
import opekope2.optigui.util.OptiFineParser;

public final class Util {
    public static final Map<String, class_2960> TEXTURE_AUTO_MAPPING = new HashMap<String, class_2960>();
    public static final Map<String, TextureRemapper> TEXTURE_REMAPPERS = new HashMap<String, TextureRemapper>();
    public static final Map<String, Set<class_2960>> ID_AUTO_MAPPING = new HashMap<String, Set<class_2960>>();
    public static final Map<String, String> CARPET_TO_COLOR_MAPPING = new HashMap<String, String>();
    public static final Map<String, class_2960> COLOR_TO_SHULKER_MAPPING = new HashMap<String, class_2960>();

    public static Boolean getBoolean(String s) {
        if (s == null) {
            return null;
        }
        return switch (s.toLowerCase()) {
            case "true" -> true;
            case "false" -> false;
            default -> null;
        };
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... args) {
        HashSet<T> result = new HashSet<T>();
        for (T arg : args) {
            result.add(arg);
        }
        return result;
    }

    public static <T> boolean setAndCheckIfUpdated(Setter<T> setter, T oldValue, T newValue) {
        boolean updated;
        boolean bl = oldValue == null ? newValue != null : (updated = !oldValue.equals(newValue));
        if (updated) {
            setter.set(newValue);
        }
        return updated;
    }

    public static boolean isChristmas() {
        LocalDateTime date = LocalDateTime.now();
        int day = date.getDayOfMonth();
        return date.getMonth() == Month.DECEMBER && (day >= 24 || day <= 26);
    }

    public static class_2960 getBiomeId(class_310 mc, class_2338 pos) {
        return mc.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)((class_1959)mc.field_1687.method_23753(pos).comp_349()));
    }

    private static Set<class_2960> remapFurnaceTexture(Properties properties) {
        String variants = properties.getProperty("variants", null);
        if (variants == null) {
            return Util.setOf(BuiltinTexturePath.FURNACE);
        }
        HashSet<class_2960> ids = new HashSet<class_2960>();
        Iterator<String> iterator = OptiFineParser.parseList(variants).iterator();
        while (iterator.hasNext()) {
            String variant;
            switch (variant = iterator.next()) {
                case "": 
                case "_furnace": {
                    ids.add(BuiltinTexturePath.FURNACE);
                    break;
                }
                case "_blast": 
                case "_blast_furnace": {
                    ids.add(BuiltinTexturePath.BLAST_FURNACE);
                    break;
                }
                case "_smoker": {
                    ids.add(BuiltinTexturePath.SMOKER);
                }
            }
        }
        return ids;
    }

    private Util() {
    }

    static {
        TEXTURE_AUTO_MAPPING.put("anvil", BuiltinTexturePath.ANVIL);
        TEXTURE_AUTO_MAPPING.put("beacon", BuiltinTexturePath.BEACON);
        TEXTURE_AUTO_MAPPING.put("brewing_stand", BuiltinTexturePath.BREWING_STAND);
        TEXTURE_AUTO_MAPPING.put("_cartography_table", BuiltinTexturePath.CARTOGRAPHY_TABLE);
        TEXTURE_AUTO_MAPPING.put("chest", BuiltinTexturePath.CHEST);
        TEXTURE_AUTO_MAPPING.put("crafting", BuiltinTexturePath.CRAFTING_TABLE);
        TEXTURE_AUTO_MAPPING.put("dispenser", BuiltinTexturePath.DISPENSER);
        TEXTURE_AUTO_MAPPING.put("enchantment", BuiltinTexturePath.ENCHANTING_TABLE);
        TEXTURE_AUTO_MAPPING.put("_grindstone", BuiltinTexturePath.GRINDSTONE);
        TEXTURE_AUTO_MAPPING.put("hopper", BuiltinTexturePath.HOPPER);
        TEXTURE_AUTO_MAPPING.put("_loom", BuiltinTexturePath.LOOM);
        TEXTURE_AUTO_MAPPING.put("shulker_box", BuiltinTexturePath.SHULKER_BOX);
        TEXTURE_AUTO_MAPPING.put("_smithing_table", BuiltinTexturePath.SMITHING_TABLE);
        TEXTURE_AUTO_MAPPING.put("_stonecutter", BuiltinTexturePath.STONECUTTER);
        TEXTURE_AUTO_MAPPING.put("horse", BuiltinTexturePath.HORSE);
        TEXTURE_AUTO_MAPPING.put("villager", BuiltinTexturePath.VILLAGER);
        TEXTURE_REMAPPERS.put("furnace", Util::remapFurnaceTexture);
        ID_AUTO_MAPPING.put("anvil", Util.setOf(ID.ANVIL, ID.CHIPPED_ANVIL, ID.DAMAGED_ANVIL));
        ID_AUTO_MAPPING.put("beacon", Util.setOf(ID.BEACON));
        ID_AUTO_MAPPING.put("brewing_stand", Util.setOf(ID.BREWING_STAND));
        ID_AUTO_MAPPING.put("crafting", Util.setOf(ID.CRAFTING_TABLE));
        ID_AUTO_MAPPING.put("enchantment", Util.setOf(ID.ENCHANTING_TABLE));
        ID_AUTO_MAPPING.put("hopper", Util.setOf(ID.HOPPER));
        CARPET_TO_COLOR_MAPPING.put("minecraft:white_carpet", "white");
        CARPET_TO_COLOR_MAPPING.put("minecraft:orange_carpet", "orange");
        CARPET_TO_COLOR_MAPPING.put("minecraft:magenta_carpet", "magenta");
        CARPET_TO_COLOR_MAPPING.put("minecraft:light_blue_carpet", "light_blue");
        CARPET_TO_COLOR_MAPPING.put("minecraft:yellow_carpet", "yellow");
        CARPET_TO_COLOR_MAPPING.put("minecraft:lime_carpet", "lime");
        CARPET_TO_COLOR_MAPPING.put("minecraft:pink_carpet", "pink");
        CARPET_TO_COLOR_MAPPING.put("minecraft:gray_carpet", "gray");
        CARPET_TO_COLOR_MAPPING.put("minecraft:light_gray_carpet", "light_gray");
        CARPET_TO_COLOR_MAPPING.put("minecraft:cyan_carpet", "cyan");
        CARPET_TO_COLOR_MAPPING.put("minecraft:purple_carpet", "purple");
        CARPET_TO_COLOR_MAPPING.put("minecraft:blue_carpet", "blue");
        CARPET_TO_COLOR_MAPPING.put("minecraft:brown_carpet", "brown");
        CARPET_TO_COLOR_MAPPING.put("minecraft:green_carpet", "green");
        CARPET_TO_COLOR_MAPPING.put("minecraft:red_carpet", "red");
        CARPET_TO_COLOR_MAPPING.put("minecraft:black_carpet", "black");
        COLOR_TO_SHULKER_MAPPING.put("white", ID.WHITE_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("orange", ID.ORANGE_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("magenta", ID.MAGENTA_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("light_blue", ID.LIGHT_BLUE_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("yellow", ID.YELLOW_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("lime", ID.LIME_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("pink", ID.PINK_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("gray", ID.GRAY_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("light_gray", ID.LIGHT_GRAY_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("cyan", ID.CYAN_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("purple", ID.PURPLE_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("blue", ID.BLUE_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("brown", ID.BROWN_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("green", ID.GREEN_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("red", ID.RED_SHULKER_BOX);
        COLOR_TO_SHULKER_MAPPING.put("black", ID.BLACK_SHULKER_BOX);
    }
}

