/*
 * Decompiled with CFR 0.152.
 */
package opekope2.optigui.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import opekope2.optigui.interfaces.RegexMatcher;
import opekope2.optigui.util.VillagerMatcher;
import org.apache.commons.text.StringEscapeUtils;

public final class OptiFineParser {
    private static final Map<String, RegexParser> regexParsers = new HashMap<String, RegexParser>();

    public static class_2096.class_2100 parseRange(String input) {
        try {
            StringReader reader = new StringReader(input);
            return class_2096.class_2100.method_9060((StringReader)reader);
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    public static Collection<String> parseList(String input) {
        return OptiFineParser.parseList(input, s -> s, " \t", false);
    }

    private static <T> List<T> parseList(String input, Converter<String, T> converter, String separators, Boolean removeNulls) {
        StringTokenizer tokenizer = new StringTokenizer(input, separators);
        ArrayList<T> result = new ArrayList<T>();
        while (tokenizer.hasMoreTokens()) {
            T converted = converter.convert(tokenizer.nextToken());
            if (removeNulls.booleanValue() && converted == null) continue;
            result.add(converted);
        }
        return result;
    }

    public static Collection<class_2960> parseIdentifierList(String input) {
        return OptiFineParser.parseList(input, s -> new class_2960(s), " \t", false);
    }

    public static Collection<class_2096.class_2100> parseRangeList(String input) {
        return OptiFineParser.parseList(input, OptiFineParser::parseRange, " \t", true);
    }

    private static VillagerMatcher parseProfession(String input) {
        Collection<Object> levels;
        String profession;
        List<String> tokens = OptiFineParser.parseList(input, s -> s, ":", false);
        String namespace = "minecraft";
        switch (tokens.size()) {
            case 1: {
                profession = tokens.get(0);
                levels = new ArrayList<class_2096.class_2100>();
                levels.add(class_2096.class_2100.field_9708);
                break;
            }
            case 2: {
                char c = tokens.get(1).charAt(0);
                if (c >= '0' && c <= '9') {
                    profession = tokens.get(0);
                    levels = OptiFineParser.parseRangeList(tokens.get(1));
                    break;
                }
                namespace = tokens.get(0);
                profession = tokens.get(1);
                levels = new ArrayList();
                levels.add(class_2096.class_2100.field_9708);
                break;
            }
            case 3: {
                namespace = tokens.get(0);
                profession = tokens.get(1);
                levels = OptiFineParser.parseRangeList(tokens.get(2));
                break;
            }
            default: {
                return null;
            }
        }
        return new VillagerMatcher(new class_2960(namespace, profession), levels);
    }

    public static Collection<VillagerMatcher> parseProfessionList(String input) {
        return OptiFineParser.parseList(input, OptiFineParser::parseProfession, " \t", true);
    }

    private static String wildcardToRegex(String widlcard) {
        StringBuilder result = new StringBuilder("^");
        int l = widlcard.length();
        for (int i = 0; i < l; ++i) {
            char c = widlcard.charAt(i);
            result.append(switch (c) {
                case '*' -> ".*";
                case '?' -> Character.valueOf('.');
                case '.' -> "\\.";
                case '\\' -> "\\\\";
                case '+' -> "\\+";
                case '^' -> "\\^";
                case '$' -> "\\$";
                case '[' -> "\\[";
                case ']' -> "\\]";
                case '{' -> "\\{";
                case '}' -> "\\}";
                case '(' -> "\\(";
                case ')' -> "\\)";
                case '|' -> "\\|";
                case '/' -> "\\/";
                default -> Character.valueOf(c);
            });
        }
        result.append('$');
        return result.toString();
    }

    public static RegexMatcher parseRegex(String input) {
        String tmp;
        if (input == null) {
            return null;
        }
        for (Map.Entry<String, RegexParser> parser : regexParsers.entrySet()) {
            String key = parser.getKey();
            RegexParser value = parser.getValue();
            if (!input.startsWith(key)) continue;
            if ((input = StringEscapeUtils.unescapeJava((String)input.substring(key.length()))).startsWith("!")) {
                Pattern regex = value.parse(input.substring(1));
                return text -> !regex.matcher(text).matches();
            }
            Pattern regex = value.parse(input);
            return text -> regex.matcher(text).matches();
        }
        if ((input = StringEscapeUtils.unescapeJava((String)input)).startsWith("!")) {
            tmp = input.substring(1);
            return text -> !tmp.equals(text);
        }
        tmp = input;
        return text -> tmp.equals(text);
    }

    private OptiFineParser() {
    }

    static {
        regexParsers.put("pattern:", s -> Pattern.compile(OptiFineParser.wildcardToRegex(s)));
        regexParsers.put("ipattern:", s -> Pattern.compile(OptiFineParser.wildcardToRegex(s), 2));
        regexParsers.put("regex:", s -> Pattern.compile(s));
        regexParsers.put("iregex:", s -> Pattern.compile(s, 2));
    }

    private static interface Converter<T, TResult> {
        public TResult convert(T var1);
    }

    private static interface RegexParser {
        public Pattern parse(String var1);
    }
}

