/*
 * Decompiled with CFR 0.152.
 */
package opekope2.optigui.optifinecompat;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1501;
import net.minecraft.class_1646;
import net.minecraft.class_1767;
import net.minecraft.class_2096;
import net.minecraft.class_2586;
import net.minecraft.class_2745;
import net.minecraft.class_2754;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3989;
import opekope2.optigui.OptiGUIClient;
import opekope2.optigui.interfaces.RegexMatcher;
import opekope2.optigui.interfaces.TextureRemapper;
import opekope2.optigui.optifinecompat.OptiFineResourceLoader;
import opekope2.optigui.util.ID;
import opekope2.optigui.util.InteractionInfo;
import opekope2.optigui.util.OptiFineParser;
import opekope2.optigui.util.PathResolver;
import opekope2.optigui.util.Util;
import opekope2.optigui.util.VillagerMatcher;
import org.apache.commons.io.FilenameUtils;

public final class OptiFineProperties {
    private static final class_2754<class_2745> CHEST_TYPE_ENUM = class_2754.method_11850((String)"type", class_2745.class);
    private final Map<String, ContainerRemapper> remappers = new HashMap<String, ContainerRemapper>();
    private final Map<class_2960, InteractionMatcher> blockMatchers = new HashMap<class_2960, InteractionMatcher>();
    private final Map<class_2960, InteractionMatcher> entityMatchers = new HashMap<class_2960, InteractionMatcher>();
    private static final String texturePathPrefix = "texture.";
    private Map<class_2960, class_2960> textureRemaps;
    private boolean isEntity;
    private Boolean large;
    private Boolean trapped;
    private Boolean christmas;
    private Boolean ender;
    private Boolean _barrel;
    private RegexMatcher nameMatcher;
    private Set<class_2960> biomes;
    private Iterable<class_2096.class_2100> heights;
    private Iterable<class_2096.class_2100> levels;
    private Iterable<VillagerMatcher> professions;
    private Set<String> colors;
    private Set<class_2960> ids;

    private OptiFineProperties(OptiFineResourceLoader.ResourceLoadContext context) {
        ContainerRemapper remapper;
        this.remappers.put("chest", this::remapChest);
        this.remappers.put("dispenser", this::remapDispenser);
        this.remappers.put("furnace", this::remapFurnace);
        this.remappers.put("shulker_box", this::remapShulkerBox);
        this.remappers.put("horse", this::remapHorse);
        this.remappers.put("villager", this::remapVillager);
        this.blockMatchers.put(ID.BARREL, this::matchesChest);
        this.blockMatchers.put(ID.BEACON, this::matchesBeacon);
        this.blockMatchers.put(ID.BLAST_FURNACE, this::matchesFurnace);
        this.blockMatchers.put(ID.CHEST, this::matchesChest);
        this.blockMatchers.put(ID.ENDER_CHEST, this::matchesChest);
        this.blockMatchers.put(ID.FURNACE, this::matchesFurnace);
        this.blockMatchers.put(ID.SMOKER, this::matchesFurnace);
        this.blockMatchers.put(ID.TRAPPED_CHEST, this::matchesChest);
        this.entityMatchers.put(ID.LLAMA, this::matchesLlama);
        this.entityMatchers.put(ID.TRADER_LLAMA, this::matchesLlama);
        this.entityMatchers.put(ID.VILLAGER, this::matchesVillager);
        this.entityMatchers.put(ID.WANDERING_TRADER, this::matchesVillager);
        this.textureRemaps = new HashMap<class_2960, class_2960>();
        this.isEntity = false;
        this.large = null;
        this.trapped = null;
        this.christmas = null;
        this.ender = null;
        this._barrel = null;
        this.nameMatcher = null;
        this.biomes = null;
        this.heights = null;
        this.levels = null;
        this.professions = null;
        this.colors = null;
        this.ids = null;
        String container = context.getProperties().getProperty("container", null);
        if (container == null) {
            return;
        }
        Set ids = Util.ID_AUTO_MAPPING.getOrDefault(container, null);
        if (ids != null) {
            this.ids = ids;
        }
        if ((remapper = (ContainerRemapper)this.remappers.getOrDefault(container, null)) != null) {
            remapper.remapContainer(context.getProperties());
        }
        this.loadProperties(context.getProperties());
        this.loadTextureRemaps(context);
    }

    private void loadProperties(Properties props) {
        String colors;
        String professions;
        String levels;
        String heights;
        String biomes;
        String name = props.getProperty("name", null);
        if (name != null) {
            this.nameMatcher = OptiFineParser.parseRegex(name);
        }
        if ((biomes = props.getProperty("biomes", null)) != null) {
            this.biomes = new HashSet<class_2960>(OptiFineParser.parseIdentifierList(biomes));
        }
        if ((heights = props.getProperty("heights", null)) != null) {
            this.heights = OptiFineParser.parseRangeList(heights);
        }
        if ((levels = props.getProperty("levels", null)) != null) {
            this.levels = OptiFineParser.parseRangeList(levels);
        }
        if ((professions = props.getProperty("professions", null)) != null) {
            this.professions = OptiFineParser.parseProfessionList(professions);
        }
        if ((colors = props.getProperty("colors", null)) != null) {
            this.colors = new HashSet<String>(OptiFineParser.parseList(colors));
        }
    }

    private void loadTextureRemaps(OptiFineResourceLoader.ResourceLoadContext ctx) {
        String texture = ctx.getProperties().getProperty("texture", null);
        String resFolder = new File(ctx.getResourceId().method_12832()).getParent().replace('\\', '/');
        if (texture != null) {
            class_2960 id = PathResolver.resolve(resFolder, texture);
            class_2960 foundId = ctx.findResource(id);
            if (foundId == null) {
                OptiGUIClient.logger.warn("Texture '{}' is missing!\nIn resource pack '{}', resource '{}'.", new Object[]{id.toString(), ctx.getResourcePackName(), ctx.getResourceId()});
            } else {
                for (class_2960 textureToRemap : this.getTextureToRemap(ctx.getProperties())) {
                    this.textureRemaps.put(textureToRemap, foundId);
                }
            }
        }
        for (Map.Entry<Object, Object> property : ctx.getProperties().entrySet()) {
            String key = (String)property.getKey();
            if (!key.startsWith(texturePathPrefix)) continue;
            String value = (String)property.getValue();
            class_2960 id = PathResolver.resolve(resFolder, value);
            class_2960 foundId = ctx.findResource(id);
            if (foundId == null) {
                OptiGUIClient.logger.warn("Resource '{}' is missing!\nIn resource pack '{}', resource '{}'.", new Object[]{id.toString(), ctx.getResourcePackName(), ctx.getResourceId()});
                continue;
            }
            String texturePath = key.substring(texturePathPrefix.length());
            this.textureRemaps.put(PathResolver.resolve("textures/gui", texturePath), foundId);
        }
    }

    private Set<class_2960> getTextureToRemap(Properties properties) {
        String container = properties.getProperty("container", null);
        class_2960 containerTexture = Util.TEXTURE_AUTO_MAPPING.get(container);
        if (containerTexture != null) {
            return Util.setOf(containerTexture);
        }
        TextureRemapper remapper = Util.TEXTURE_REMAPPERS.get(container);
        return remapper != null ? remapper.remap(properties) : Util.setOf(new class_2960[0]);
    }

    public boolean matchesBlock(InteractionInfo interaction) {
        if (this.isEntity) {
            return false;
        }
        if (this.biomes != null && !this.biomes.contains(interaction.getBiome())) {
            return false;
        }
        if (this.heights != null) {
            boolean matchesHeight = false;
            int y = interaction.getBlockPos().method_10264();
            for (class_2096.class_2100 height : this.heights) {
                if (!height.method_9054(y)) continue;
                matchesHeight = true;
                break;
            }
            if (!matchesHeight) {
                return false;
            }
        }
        if (this.nameMatcher != null && !this.nameMatcher.matches(interaction.hasCustomName() ? interaction.getCustomName() : "")) {
            return false;
        }
        if (!this.ids.contains(interaction.getId())) {
            return false;
        }
        InteractionMatcher matcher = this.blockMatchers.getOrDefault(interaction.getId(), null);
        return matcher == null || matcher.matchesInteraction(interaction);
    }

    public boolean matchesEntity(InteractionInfo interaction) {
        if (!this.isEntity) {
            return false;
        }
        if (this.biomes != null && !this.biomes.contains(interaction.getBiome())) {
            return false;
        }
        if (this.heights != null) {
            boolean matchesHeight = false;
            int y = interaction.getBlockPos().method_10264();
            for (class_2096.class_2100 height : this.heights) {
                if (!height.method_9054(y)) continue;
                matchesHeight = true;
                break;
            }
            if (!matchesHeight) {
                return false;
            }
        }
        if (this.nameMatcher != null && !this.nameMatcher.matches(interaction.hasCustomName() ? interaction.getCustomName() : "")) {
            return false;
        }
        if (!this.ids.contains(interaction.getId())) {
            return false;
        }
        InteractionMatcher matcher = this.entityMatchers.getOrDefault(interaction.getId(), null);
        return matcher == null || matcher.matchesInteraction(interaction);
    }

    public boolean matchesAnythingElse(InteractionInfo interaction) {
        if (this.ids != null) {
            return false;
        }
        if (this.biomes != null && !this.biomes.contains(interaction.getBiome())) {
            return false;
        }
        if (this.heights != null) {
            boolean matchesHeight = true;
            int y = interaction.getBlockPos().method_10264();
            for (class_2096.class_2100 height : this.heights) {
                if (!height.method_9054(y)) continue;
                matchesHeight = true;
                break;
            }
            if (!matchesHeight) {
                return false;
            }
        }
        return true;
    }

    public boolean canReplaceTexture(class_2960 original) {
        if (this.textureRemaps.containsKey(original)) {
            return true;
        }
        String namespace = original.method_12836();
        String path = original.method_12832();
        path = FilenameUtils.removeExtension((String)path);
        return this.textureRemaps.containsKey(new class_2960(namespace, path));
    }

    public class_2960 replaceTexture(class_2960 original) {
        if (this.textureRemaps.containsKey(original)) {
            return this.textureRemaps.getOrDefault(original, original);
        }
        String namespace = original.method_12836();
        String path = original.method_12832();
        path = FilenameUtils.removeExtension((String)path);
        return this.textureRemaps.getOrDefault(new class_2960(namespace, path), original);
    }

    private void remapChest(Properties packProps) {
        this.large = Util.getBoolean(packProps.getProperty("large", null));
        this.trapped = Util.getBoolean(packProps.getProperty("trapped", null));
        this.christmas = Util.getBoolean(packProps.getProperty("christmas", null));
        this.ender = Util.getBoolean(packProps.getProperty("ender", null));
        this._barrel = Util.getBoolean(packProps.getProperty("_barrel", null));
        HashSet<class_2960> variants = new HashSet<class_2960>();
        variants.add(ID.CHEST);
        if (this.ender != null && this.ender.booleanValue()) {
            variants.add(ID.ENDER_CHEST);
        }
        if (this.trapped != null && this.trapped.booleanValue()) {
            variants.add(ID.TRAPPED_CHEST);
        }
        if (this._barrel != null && this._barrel.booleanValue()) {
            variants.add(ID.BARREL);
        }
        this.ids = variants;
    }

    private void remapDispenser(Properties properties) {
        String variants = properties.getProperty("variants", null);
        if (variants == null) {
            this.ids = Util.setOf(ID.DISPENSER, ID.DROPPER);
            return;
        }
        HashSet<class_2960> ids = new HashSet<class_2960>();
        Iterator<String> iterator = OptiFineParser.parseList(variants).iterator();
        while (iterator.hasNext()) {
            String variant;
            switch (variant = iterator.next()) {
                case "": 
                case "dispenser": {
                    ids.add(ID.DISPENSER);
                    break;
                }
                case "dropper": {
                    ids.add(ID.DROPPER);
                }
            }
        }
        this.ids = ids;
    }

    private void remapFurnace(Properties properties) {
        String variants = properties.getProperty("variants", null);
        if (variants == null) {
            this.ids = Util.setOf(ID.FURNACE, ID.BLAST_FURNACE, ID.SMOKER);
            return;
        }
        HashSet<class_2960> ids = new HashSet<class_2960>();
        Iterator<String> iterator = OptiFineParser.parseList(variants).iterator();
        while (iterator.hasNext()) {
            String variant;
            switch (variant = iterator.next()) {
                case "": 
                case "_furnace": {
                    ids.add(ID.FURNACE);
                    break;
                }
                case "_blast": 
                case "_blast_furnace": {
                    ids.add(ID.BLAST_FURNACE);
                    break;
                }
                case "_smoker": {
                    ids.add(ID.SMOKER);
                }
            }
        }
        this.ids = ids;
    }

    private void remapShulkerBox(Properties properties) {
        String colors = properties.getProperty("colors", null);
        HashSet<class_2960> ids = new HashSet<class_2960>();
        if (colors == null) {
            for (class_2960 shulker : Util.COLOR_TO_SHULKER_MAPPING.values()) {
                ids.add(shulker);
            }
        } else {
            Collection<String> colorList = OptiFineParser.parseList(colors);
            for (String color : colorList) {
                class_2960 shulker = Util.COLOR_TO_SHULKER_MAPPING.getOrDefault(color, null);
                if (shulker == null) continue;
                ids.add(shulker);
            }
        }
        this.ids = ids;
    }

    private void remapHorse(Properties properties) {
        this.isEntity = true;
        String variants = properties.getProperty("variants", null);
        if (variants == null) {
            this.ids = Util.setOf(ID.HORSE, ID.DONKEY, ID.MULE, ID.LLAMA, ID.TRADER_LLAMA);
            return;
        }
        this.ids = switch (variants) {
            case "horse" -> Util.setOf(ID.HORSE);
            case "donkey" -> Util.setOf(ID.DONKEY);
            case "mule" -> Util.setOf(ID.MULE);
            case "llama" -> Util.setOf(ID.LLAMA, ID.TRADER_LLAMA);
            default -> this.ids;
        };
    }

    private void remapVillager(Properties properties) {
        this.isEntity = true;
        this.ids = Util.setOf(ID.VILLAGER, ID.WANDERING_TRADER);
    }

    private boolean matchesChest(InteractionInfo interaction) {
        boolean matchesChristmas;
        boolean matchesLarge;
        class_2960 id = interaction.getId();
        Comparable type = (Comparable)interaction.getBlockState().method_11656().get(CHEST_TYPE_ENUM);
        boolean bl = matchesLarge = this.large == null || type == null || this.large.booleanValue() != type.equals(class_2745.field_12569);
        boolean bl2 = this.christmas == null ? true : (matchesChristmas = this.christmas == Util.isChristmas());
        if (ID.CHEST.equals((Object)id)) {
            return matchesLarge && matchesChristmas && !Boolean.TRUE.equals(this.trapped) && !Boolean.TRUE.equals(this.ender) && !Boolean.TRUE.equals(this._barrel);
        }
        if (ID.TRAPPED_CHEST.equals((Object)id)) {
            return matchesLarge && matchesChristmas && !Boolean.FALSE.equals(this.trapped) && !Boolean.TRUE.equals(this.ender) && !Boolean.TRUE.equals(this._barrel);
        }
        if (ID.ENDER_CHEST.equals((Object)id)) {
            return matchesLarge && matchesChristmas && !Boolean.TRUE.equals(this.trapped) && !Boolean.FALSE.equals(this.ender) && !Boolean.TRUE.equals(this._barrel);
        }
        if (ID.BARREL.equals((Object)id)) {
            return matchesLarge && matchesChristmas && !Boolean.TRUE.equals(this.trapped) && !Boolean.TRUE.equals(this.ender) && !Boolean.FALSE.equals(this._barrel);
        }
        return false;
    }

    private boolean matchesBeacon(InteractionInfo interaction) {
        if (this.levels == null) {
            return true;
        }
        class_2586 entity = interaction.getBlockEntity();
        int beaconLevel = entity.method_38244().method_10550("Levels");
        for (class_2096.class_2100 level : this.levels) {
            if (!level.method_9054(beaconLevel)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesFurnace(InteractionInfo interaction) {
        class_2960 id = interaction.getId();
        return ID.BLAST_FURNACE.equals((Object)id) || ID.FURNACE.equals((Object)id) || ID.SMOKER.equals((Object)id);
    }

    private boolean matchesLlama(InteractionInfo interaction) {
        class_1501 llama = (class_1501)interaction.getEntity();
        class_1767 color = llama.method_6800();
        if (color == null) {
            return this.colors == null;
        }
        return this.colors != null ? this.colors.contains(color.method_7792()) : true;
    }

    private boolean matchesVillager(InteractionInfo interaction) {
        block4: {
            class_1297 entity;
            block3: {
                if (this.professions == null) {
                    return true;
                }
                entity = interaction.getEntity();
                if (!(entity instanceof class_1646)) break block3;
                class_1646 villager = (class_1646)entity;
                for (VillagerMatcher matcher : this.professions) {
                    if (!matcher.matchesVillager(villager)) continue;
                    return true;
                }
                break block4;
            }
            if (!(entity instanceof class_3989)) break block4;
            class_3989 trader = (class_3989)entity;
            for (VillagerMatcher matcher : this.professions) {
                if (!matcher.matchesWanderingTrader(trader)) continue;
                return true;
            }
        }
        return false;
    }

    public static OptiFineProperties parse(OptiFineResourceLoader.ResourceLoadContext context) throws IOException {
        Properties properties = new Properties();
        Optional<class_3298> resource = context.getResource();
        if (resource.isPresent()) {
            properties.load(resource.get().method_14482());
        }
        context.setProperties(properties);
        return new OptiFineProperties(context);
    }

    private static interface ContainerRemapper {
        public void remapContainer(Properties var1);
    }

    private static interface InteractionMatcher {
        public boolean matchesInteraction(InteractionInfo var1);
    }
}

