/*
 * Decompiled with CFR 0.152.
 */
package opekope2.optigui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import opekope2.optigui.optifinecompat.OptiFineProperties;
import opekope2.optigui.util.InteractionCache;
import opekope2.optigui.util.InteractionInfo;

public final class TextureReplacer {
    public static final TextureReplacer instance = new TextureReplacer();
    private List<OptiFineProperties> properties = new ArrayList<OptiFineProperties>();
    private InteractionCache lastInteraction = new InteractionCache();
    private Set<class_2960> noReplacements = new HashSet<class_2960>();

    public void add(OptiFineProperties props) {
        this.properties.add(props);
    }

    public void clear() {
        this.properties.clear();
        this.clearCaches();
    }

    public void clearCaches() {
        this.lastInteraction.clear();
        this.noReplacements.clear();
    }

    public void useBlock(class_2338 block) {
        this.lastInteraction.cacheBlock(block);
    }

    public void useEntity(class_1297 entity) {
        this.lastInteraction.cacheEntity(entity);
    }

    public void refreshInteraction() {
        this.lastInteraction.refreshInteraction();
    }

    public class_2960 getReplacement(class_2960 id) {
        if (this.noReplacements.contains(id)) {
            return id;
        }
        if (this.lastInteraction.hasCachedReplacement(id)) {
            return this.lastInteraction.getCachedReplacement();
        }
        InteractionInfo interaction = this.lastInteraction.getInteraction();
        if (!interaction.isValid()) {
            return id;
        }
        boolean hasReplacement = false;
        for (OptiFineProperties props : this.properties) {
            if (!props.canReplaceTexture(id)) continue;
            hasReplacement = true;
            if (interaction.isBlock() && props.matchesBlock(interaction)) {
                class_2960 replacement = props.replaceTexture(id);
                this.lastInteraction.cacheReplacement(id, replacement);
                return replacement;
            }
            if (interaction.isEntity() && props.matchesEntity(interaction)) {
                class_2960 replacement = props.replaceTexture(id);
                this.lastInteraction.cacheReplacement(id, replacement);
                return replacement;
            }
            if (!props.matchesAnythingElse(interaction)) continue;
            return props.replaceTexture(id);
        }
        if (hasReplacement) {
            this.lastInteraction.cacheReplacement(id, id);
        } else {
            this.noReplacements.add(id);
        }
        return id;
    }

    private TextureReplacer() {
    }
}

