/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.utils;

import dev.isxander.debugify.Debugify;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.BugFixData;
import dev.isxander.debugify.fixes.FixCategory;
import dev.isxander.debugify.fixes.OS;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class MixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        Debugify.onPreInitialize();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        Optional<BugFixData> bugFixOptional = this.getBugFixForMixin(mixinClassName);
        if (bugFixOptional.isEmpty()) {
            return true;
        }
        BugFixData bugFix = bugFixOptional.get();
        boolean multipleMixins = Debugify.CONFIG.getBugFixes().containsKey(bugFix);
        Debugify.CONFIG.registerBugFix(bugFix);
        List<String> conflicts = bugFix.getActiveConflicts();
        if (!conflicts.isEmpty()) {
            if (Debugify.CONFIG.isBugFixEnabled(bugFix) && !multipleMixins) {
                Debugify.LOGGER.warn("Force disabled {} because it's conflicting with: {}", (Object)bugFix.bugId(), (Object)String.join((CharSequence)", ", conflicts));
            }
            return false;
        }
        if (!bugFix.satisfiesOSRequirement()) {
            if (Debugify.CONFIG.isBugFixEnabled(bugFix) && !multipleMixins) {
                Debugify.LOGGER.warn("Force disabled {} because it only applies to OS: {}", (Object)bugFix.bugId(), (Object)bugFix.requiredOs().name());
            }
            return false;
        }
        return Debugify.CONFIG.isBugFixEnabled(bugFix);
    }

    private Optional<BugFixData> getBugFixForMixin(String mixinClassName) {
        AnnotationNode annotationNode;
        try {
            ClassNode classNode = MixinService.getService().getBytecodeProvider().getClassNode(mixinClassName);
            annotationNode = Annotations.getVisible((ClassNode)classNode, BugFix.class);
        }
        catch (IOException | ClassNotFoundException e) {
            annotationNode = null;
        }
        if (annotationNode == null) {
            return Optional.empty();
        }
        String id = (String)Annotations.getValue((AnnotationNode)annotationNode, (String)"id");
        FixCategory category = MixinPlugin.getAnnotationEnumValue(annotationNode, "category", FixCategory.class);
        BugFix.Env env = MixinPlugin.getAnnotationEnumValue(annotationNode, "env", BugFix.Env.class);
        boolean enabledByDefault = (Boolean)Annotations.getValue((AnnotationNode)annotationNode, (String)"enabled", (Object)true);
        List conflicts = Annotations.getValue((AnnotationNode)annotationNode, (String)"modConflicts", (boolean)true);
        OS requiredOS = (OS)Annotations.getValue((AnnotationNode)annotationNode, (String)"os", OS.class, (Enum)OS.UNKNOWN);
        return Optional.of(new BugFixData(id, category, env, enabledByDefault, conflicts, requiredOS));
    }

    private static <T extends Enum<T>> T getAnnotationEnumValue(AnnotationNode annotation, String key, Class<T> enumClass) {
        String[] value = (String[])Annotations.getValue((AnnotationNode)annotation, (String)key);
        return Enum.valueOf(enumClass, value[1]);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

