/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.fixes;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import dev.isxander.debugify.fixes.OS;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

public record BugFixData(String bugId, FixCategory category, BugFix.Env env, boolean enabledByDefault, List<String> conflicts, OS requiredOs) implements Comparable<BugFixData>
{
    public List<String> getActiveConflicts() {
        return this.conflicts().stream().filter(id -> FabricLoader.getInstance().isModLoaded(id)).toList();
    }

    public boolean satisfiesOSRequirement() {
        return this.requiredOs() == OS.UNKNOWN || this.requiredOs() == OS.getOperatingSystem();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BugFixData) {
            BugFixData bugFixData = (BugFixData)obj;
            return bugFixData.bugId.equals(this.bugId);
        }
        return false;
    }

    @Override
    public int compareTo(@NotNull BugFixData o) {
        if (o.bugId.length() == this.bugId.length()) {
            return this.bugId.compareTo(o.bugId);
        }
        return Integer.compare(this.bugId.length(), o.bugId.length());
    }
}

