/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.debugify.Debugify;
import dev.isxander.debugify.fixes.BugFixData;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;

public class DebugifyConfig {
    private final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("debugify.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<String, Boolean> jsonBugFixes = new HashMap<String, Boolean>();
    private final Map<BugFixData, Boolean> bugFixes = new TreeMap<BugFixData, Boolean>();
    public boolean defaultDisabled = false;
    public boolean optOutUpdater = false;
    public boolean gameplayFixesInMultiplayer = false;
    private boolean preloaded = false;

    public void registerBugFix(BugFixData bugFix) {
        if (this.bugFixes.containsKey(bugFix)) {
            return;
        }
        boolean enabled = this.jsonBugFixes.getOrDefault(bugFix.bugId(), bugFix.enabledByDefault() && !this.defaultDisabled);
        this.bugFixes.put(bugFix, enabled);
    }

    public void preload() {
        if (this.preloaded) {
            return;
        }
        this.preloaded = true;
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            if (FabricLoader.getInstance().isModLoaded("yosbr") && Files.exists(this.configPath.getParent().resolve("yosbr/" + this.configPath.getFileName().toString()), new LinkOption[0])) {
                throw new YosbrError();
            }
            return;
        }
        Debugify.LOGGER.info("Preloading Debugify");
        try {
            String jsonString = Files.readString(this.configPath);
            JsonObject json = (JsonObject)this.gson.fromJson(jsonString, JsonObject.class);
            if (json.has("opt_out_updater")) {
                this.optOutUpdater = json.get("opt_out_updater").getAsBoolean();
            }
            if (json.has("default_disabled")) {
                this.defaultDisabled = json.get("default_disabled").getAsBoolean();
            }
            if (json.has("gameplay_fixes_in_multiplayer")) {
                this.gameplayFixesInMultiplayer = json.get("gameplay_fixes_in_multiplayer").getAsBoolean();
            }
            Map<String, Boolean> bugFixes = json.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("MC-") && ((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()).map(entry -> new AbstractMap.SimpleEntry<String, Boolean>((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.jsonBugFixes.clear();
            this.jsonBugFixes.putAll(bugFixes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        Debugify.LOGGER.info("Saving Debugify");
        try {
            Files.deleteIfExists(this.configPath);
            JsonObject json = new JsonObject();
            this.bugFixes.forEach((fix, enabled) -> {
                if (!this.defaultDisabled || enabled.booleanValue()) {
                    json.addProperty(fix.bugId(), enabled);
                }
            });
            json.addProperty("opt_out_updater", Boolean.valueOf(this.optOutUpdater));
            json.addProperty("gameplay_fixes_in_multiplayer", Boolean.valueOf(this.gameplayFixesInMultiplayer));
            json.addProperty("default_disabled", Boolean.valueOf(this.defaultDisabled));
            Files.createFile(this.configPath, new FileAttribute[0]);
            Files.writeString(this.configPath, (CharSequence)this.gson.toJson((JsonElement)json), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isBugFixEnabled(BugFixData bug) {
        return this.bugFixes.getOrDefault(bug, false);
    }

    public Map<BugFixData, Boolean> getBugFixes() {
        return this.bugFixes;
    }

    public boolean doesJsonHaveIdenticalKeys() {
        return this.jsonBugFixes.keySet().containsAll(this.bugFixes.keySet().stream().map(BugFixData::bugId).collect(Collectors.toSet())) && this.jsonBugFixes.size() == this.bugFixes.size();
    }

    private static class YosbrError
    extends Error {
        public YosbrError() {
            super("Debugify config loaded using YOSBR mod! This doesn't work! Please move 'debugify.json' out of the 'yosbr' folder!");
        }
    }
}

