/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.fabricskyboxes_interop.mixin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.amerebagatelle.fabricskyboxes.SkyboxManager;
import io.github.amerebagatelle.fabricskyboxes.resource.SkyboxResourceListener;
import io.github.amerebagatelle.fabricskyboxes.util.object.MinMaxEntry;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.flashyreese.mods.fabricskyboxes_interop.client.config.FSBInteropConfig;
import me.flashyreese.mods.fabricskyboxes_interop.mixin.SkyboxManagerAccessor;
import me.flashyreese.mods.fabricskyboxes_interop.utils.ResourceManagerHelper;
import me.flashyreese.mods.fabricskyboxes_interop.utils.Utils;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SkyboxResourceListener.class})
public class MixinSkyboxResourceListener {
    private final Logger logger = LoggerFactory.getLogger((String)"FSB-Interop");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String OPTIFINE_SKY_PARENT = "optifine/sky";
    private static final Pattern OPTIFINE_SKY_PATTERN = Pattern.compile("optifine/sky/(?<world>\\w+)/(?<name>\\w+).properties$");
    private static final String MCPATCHER_SKY_PARENT = "mcpatcher/sky";
    private static final Pattern MCPATCHER_SKY_PATTERN = Pattern.compile("mcpatcher/sky/(?<world>\\w+)/(?<name>\\w+).properties$");

    @Inject(method={"reload"}, at={@At(value="TAIL")})
    public void reload(class_3300 manager, CallbackInfo ci) {
        if (FSBInteropConfig.INSTANCE.interoperability) {
            if (FSBInteropConfig.INSTANCE.preferFSBNative && !((SkyboxManagerAccessor)SkyboxManager.getInstance()).getSkyboxes().isEmpty()) {
                this.logger.info("FSB Native is preferred and existing skyboxes already detected! No longer converting MCP/OptiFine formats!");
                return;
            }
            this.logger.warn("Removing existing FSB skies...");
            this.logger.warn("FSB-Interop is preventing native FabricSkyBoxes resource packs from loading!");
            this.logger.warn("FSB-Interop is converting MCPatcher/OptiFine custom skies resource packs! Any visual bugs are likely caused by FSB-Interop. Please do not report these issues to FabricSkyBoxes nor Resource Pack creators!");
            SkyboxManager.getInstance().clearSkyboxes();
            this.logger.info("Looking for OptiFine/MCPatcher Skies...");
            this.convert(new ResourceManagerHelper(manager));
        }
    }

    public void convert(ResourceManagerHelper managerAccessor) {
        if (FSBInteropConfig.INSTANCE.processOptiFine) {
            this.convertNamespace(managerAccessor, OPTIFINE_SKY_PARENT, OPTIFINE_SKY_PATTERN);
        }
        if (FSBInteropConfig.INSTANCE.processMCPatcher) {
            this.convertNamespace(managerAccessor, MCPATCHER_SKY_PARENT, MCPATCHER_SKY_PATTERN);
        }
    }

    private void convertNamespace(ResourceManagerHelper resourceManagerHelper, String skyParent, Pattern pattern) {
        resourceManagerHelper.searchIn(skyParent).filter(id -> id.method_12832().endsWith(".properties")).sorted(Comparator.comparing(class_2960::method_12832, (id1, id2) -> {
            Matcher matcherId1 = pattern.matcher((CharSequence)id1);
            Matcher matcherId2 = pattern.matcher((CharSequence)id2);
            if (matcherId1.find() && matcherId2.find()) {
                int id1No = Utils.parseInt(matcherId1.group("name").replace("sky", ""), -1);
                int id2No = Utils.parseInt(matcherId2.group("name").replace("sky", ""), -1);
                if (id1No >= 0 && id2No >= 0) {
                    return id1No - id2No;
                }
            }
            return 0;
        })).forEach(id -> {
            Matcher matcher = pattern.matcher(id.method_12832());
            if (matcher.find()) {
                InputStream textureInputStream;
                class_2960 textureId;
                String world = matcher.group("world");
                String name = matcher.group("name");
                if (world == null || name == null) {
                    return;
                }
                if (name.equals("moon_phases") || name.equals("sun")) {
                    this.logger.info("Skipping {}, moon_phases/sun aren't supported!", id);
                    return;
                }
                this.logger.info("Converting {} to FSB Format...", id);
                InputStream inputStream = resourceManagerHelper.getInputStream((class_2960)id);
                if (inputStream == null) {
                    if (FSBInteropConfig.INSTANCE.debugMode) {
                        this.logger.error("Error trying to read namespaced identifier: {}", id);
                    }
                    return;
                }
                Properties properties = new Properties();
                try {
                    properties.load(inputStream);
                }
                catch (IOException e) {
                    if (FSBInteropConfig.INSTANCE.debugMode) {
                        this.logger.error("Error trying to read namespaced identifier: {}", id);
                        e.printStackTrace();
                    }
                    return;
                }
                finally {
                    block27: {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            if (!FSBInteropConfig.INSTANCE.debugMode) break block27;
                            this.logger.error("Error trying to close input stream at namespaced identifier: {}", id);
                            e.printStackTrace();
                        }
                    }
                }
                if (properties.containsKey("source")) {
                    String source = properties.getProperty("source");
                    try {
                        if (source.startsWith("./")) {
                            textureId = new class_2960(id.method_12836(), skyParent + String.format("/%s/%s", world, source.substring(2)));
                        }
                        if (source.startsWith("assets/")) {
                            int firstIndex = source.indexOf("/") + 1;
                            int secondIndex = source.indexOf("/", firstIndex);
                            String sourceNamespace = source.substring(firstIndex, secondIndex);
                            textureId = new class_2960(sourceNamespace, source.substring(secondIndex + 1));
                        }
                        int firstIndex = source.indexOf("/") + 1;
                        String sourceNamespace = source.substring(0, firstIndex - 1);
                        textureId = new class_2960(sourceNamespace, source.substring(firstIndex));
                    }
                    catch (class_151 e) {
                        if (FSBInteropConfig.INSTANCE.debugMode) {
                            this.logger.error("Illegal character in namespaced identifier: {}", (Object)source);
                        }
                        return;
                    }
                } else {
                    textureId = new class_2960(id.method_12836(), skyParent + String.format("/%s/%s.png", world, name));
                }
                if ((textureInputStream = resourceManagerHelper.getInputStream(textureId)) == null) {
                    if (FSBInteropConfig.INSTANCE.debugMode) {
                        this.logger.error("Unable to find/read namespaced identifier: {}", (Object)textureId);
                    }
                    return;
                }
                this.convert(name, (class_2960)id, textureId, properties, world);
            }
        });
    }

    private void convert(String skyName, class_2960 propertiesId, class_2960 textureId, Properties properties, String world) {
        JsonObject json = new JsonObject();
        json.addProperty("schemaVersion", (Number)2);
        json.addProperty("type", "single-sprite-square-textured");
        JsonObject blend = new JsonObject();
        if (properties.containsKey("blend")) {
            blend.addProperty("type", properties.getProperty("blend"));
        } else {
            blend.addProperty("type", "add");
        }
        json.add("blend", (JsonElement)blend);
        json.addProperty("texture", textureId.toString());
        JsonObject propertiesObject = new JsonObject();
        this.processProperties(propertiesObject, properties, skyName);
        json.add("properties", (JsonElement)propertiesObject);
        JsonObject conditionsObject = new JsonObject();
        this.processConditions(conditionsObject, properties, world);
        json.add("conditions", (JsonElement)conditionsObject);
        JsonObject decorationsObject = new JsonObject();
        decorationsObject.addProperty("showStars", Boolean.valueOf(false));
        json.add("decorations", (JsonElement)decorationsObject);
        if (FSBInteropConfig.INSTANCE.debugMode) {
            this.logger.info("Output for {} conversion:\n{}", (Object)propertiesId, (Object)GSON.toJson((JsonElement)json));
        }
        SkyboxManager.getInstance().addSkybox(propertiesId, json);
        this.logger.info("Converted & Added Skybox from {}!", (Object)propertiesId);
    }

    private void processProperties(JsonObject json, Properties properties, String skyName) {
        int skyNumber;
        String skyNumberString = skyName.replace("sky", "");
        if (skyNumberString.equals(String.valueOf(skyNumber = Utils.parseInt(skyNumberString, 0)))) {
            json.addProperty("priority", (Number)skyNumber);
        }
        JsonObject fade = new JsonObject();
        if (properties.containsKey("startFadeIn") && properties.containsKey("endFadeIn") && properties.containsKey("endFadeOut")) {
            int startFadeOut;
            int startFadeIn = Objects.requireNonNull(Utils.toTickTime(properties.getProperty("startFadeIn"))).intValue();
            int endFadeIn = Objects.requireNonNull(Utils.toTickTime(properties.getProperty("endFadeIn"))).intValue();
            int endFadeOut = Objects.requireNonNull(Utils.toTickTime(properties.getProperty("endFadeOut"))).intValue();
            if (properties.containsKey("startFadeOut")) {
                startFadeOut = Objects.requireNonNull(Utils.toTickTime(properties.getProperty("startFadeOut"))).intValue();
            } else {
                startFadeOut = endFadeOut - (endFadeIn - startFadeIn);
                if (startFadeIn <= startFadeOut && endFadeIn >= startFadeOut) {
                    startFadeOut = endFadeOut;
                }
            }
            fade.addProperty("startFadeIn", (Number)Utils.normalizeTickTime(startFadeIn));
            fade.addProperty("endFadeIn", (Number)Utils.normalizeTickTime(endFadeIn));
            fade.addProperty("startFadeOut", (Number)Utils.normalizeTickTime(startFadeOut));
            fade.addProperty("endFadeOut", (Number)Utils.normalizeTickTime(endFadeOut));
        } else {
            fade.addProperty("startFadeIn", (Number)0);
            fade.addProperty("endFadeIn", (Number)0);
            fade.addProperty("startFadeOut", (Number)0);
            fade.addProperty("endFadeOut", (Number)0);
            fade.addProperty("alwaysOn", Boolean.valueOf(true));
        }
        json.add("fade", (JsonElement)fade);
        if (properties.containsKey("rotate")) {
            json.addProperty("shouldRotate", Boolean.valueOf(Boolean.parseBoolean(properties.getProperty("rotate"))));
        }
        JsonObject rotation = new JsonObject();
        JsonArray jsonAxis = new JsonArray();
        if (properties.containsKey("axis")) {
            String[] axis = properties.getProperty("axis").split(" ");
            List<String> rev = Arrays.asList(axis);
            Collections.reverse(rev);
            for (String a : axis = rev.toArray(axis)) {
                jsonAxis.add((Number)Float.valueOf(Float.parseFloat(a) * 90.0f));
            }
        } else {
            jsonAxis.add((Number)Float.valueOf(0.0f));
            jsonAxis.add((Number)Float.valueOf(0.0f));
            jsonAxis.add((Number)Float.valueOf(180.0f));
        }
        rotation.add("axis", (JsonElement)jsonAxis);
        json.add("rotation", (JsonElement)rotation);
        if (properties.containsKey("speed")) {
            json.addProperty("rotationSpeed", (Number)Float.valueOf(Float.parseFloat(properties.getProperty("speed"))));
        }
    }

    private void processConditions(JsonObject json, Properties properties, String world) {
        List<MinMaxEntry> minMaxEntries;
        String[] biomes;
        String[] weathers;
        if (properties.containsKey("weather") && (weathers = properties.getProperty("weather").split(" ")).length > 0) {
            JsonArray jsonWeather = new JsonArray();
            for (String weather : weathers) {
                jsonWeather.add(weather);
            }
            json.add("weather", (JsonElement)jsonWeather);
        }
        if (properties.containsKey("biomes") && (biomes = properties.getProperty("biomes").split(" ")).length > 0) {
            JsonArray jsonBiomes = new JsonArray();
            for (String biome : biomes) {
                jsonBiomes.add(biome);
            }
            json.add("biomes", (JsonElement)jsonBiomes);
        }
        JsonArray worlds = new JsonArray();
        worlds.add(world.equals("world0") ? "minecraft:overworld" : (world.equals("world1") ? "minecraft:the_end" : world));
        json.add("worlds", (JsonElement)worlds);
        if (properties.containsKey("heights") && !(minMaxEntries = Utils.parseMinMaxEntriesNegative(properties.getProperty("heights"))).isEmpty()) {
            JsonArray jsonYRanges = new JsonArray();
            minMaxEntries.forEach(minMaxEntry -> {
                JsonObject minMax = new JsonObject();
                minMax.addProperty("min", (Number)Float.valueOf(minMaxEntry.getMin()));
                minMax.addProperty("max", (Number)Float.valueOf(minMaxEntry.getMax()));
                jsonYRanges.add((JsonElement)minMax);
            });
            json.add("yRanges", (JsonElement)jsonYRanges);
        }
        if (properties.containsKey("days") && (minMaxEntries = Utils.parseMinMaxEntries(properties.getProperty("days"))).size() > 0) {
            JsonObject loopObject = new JsonObject();
            JsonArray loopRange = new JsonArray();
            minMaxEntries.forEach(minMaxEntry -> {
                JsonObject minMax = new JsonObject();
                minMax.addProperty("min", (Number)Float.valueOf(minMaxEntry.getMin()));
                minMax.addProperty("max", (Number)Float.valueOf(minMaxEntry.getMax()));
                loopRange.add((JsonElement)minMax);
            });
            int value = 8;
            if (properties.containsKey("daysLoop")) {
                value = Utils.parseInt(properties.getProperty("daysLoop"), 8);
            }
            loopObject.addProperty("days", (Number)value);
            loopObject.add("ranges", (JsonElement)loopRange);
            json.add("loop", (JsonElement)loopObject);
        }
    }
}

