/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.itemmodelfix.model;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import me.pepperbell.itemmodelfix.model.PixelDirection;
import me.pepperbell.itemmodelfix.util.MathUtil;
import net.minecraft.class_1058;
import net.minecraft.class_1160;
import net.minecraft.class_2350;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_787;

public class ItemModelUtil {
    public static void unlerpElements(List<class_785> elements, float delta) {
        for (class_785 element : elements) {
            for (class_783 face : element.field_4230.values()) {
                MathUtil.unlerpUVs(face.field_4227.field_4235, delta);
            }
        }
    }

    public static List<class_785> createOutlineLayerElements(int layer, String key, class_1058 sprite) {
        ArrayList<class_785> elements = new ArrayList<class_785>();
        int width = sprite.method_4578();
        int height = sprite.method_4595();
        float xFactor = (float)width / 16.0f;
        float yFactor = (float)height / 16.0f;
        float animationFrameDelta = sprite.method_23842();
        int[] frames = sprite.method_33442().toArray();
        EnumMap<class_2350, class_783> map = new EnumMap<class_2350, class_783>(class_2350.class);
        map.put(class_2350.field_11035, new class_783(null, layer, key, ItemModelUtil.createUnlerpedTexture(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0, animationFrameDelta)));
        map.put(class_2350.field_11043, new class_783(null, layer, key, ItemModelUtil.createUnlerpedTexture(new float[]{16.0f, 0.0f, 0.0f, 16.0f}, 0, animationFrameDelta)));
        elements.add(new class_785(new class_1160(0.0f, 0.0f, 7.5f), new class_1160(16.0f, 16.0f, 8.5f), map, null, true));
        int first1 = -1;
        int first2 = -1;
        int last1 = -1;
        int last2 = -1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (!ItemModelUtil.isPixelAlwaysTransparent(sprite, frames, x, y)) {
                    if (ItemModelUtil.doesPixelHaveEdge(sprite, frames, x, y, PixelDirection.DOWN)) {
                        if (first1 == -1) {
                            first1 = x;
                        }
                        last1 = x;
                    }
                    if (!ItemModelUtil.doesPixelHaveEdge(sprite, frames, x, y, PixelDirection.UP)) continue;
                    if (first2 == -1) {
                        first2 = x;
                    }
                    last2 = x;
                    continue;
                }
                if (first1 != -1) {
                    elements.add(ItemModelUtil.createHorizontalOutlineElement(class_2350.field_11033, layer, key, first1, last1, y, height, animationFrameDelta, xFactor, yFactor));
                    first1 = -1;
                }
                if (first2 == -1) continue;
                elements.add(ItemModelUtil.createHorizontalOutlineElement(class_2350.field_11036, layer, key, first2, last2, y, height, animationFrameDelta, xFactor, yFactor));
                first2 = -1;
            }
            if (first1 != -1) {
                elements.add(ItemModelUtil.createHorizontalOutlineElement(class_2350.field_11033, layer, key, first1, last1, y, height, animationFrameDelta, xFactor, yFactor));
                first1 = -1;
            }
            if (first2 == -1) continue;
            elements.add(ItemModelUtil.createHorizontalOutlineElement(class_2350.field_11036, layer, key, first2, last2, y, height, animationFrameDelta, xFactor, yFactor));
            first2 = -1;
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (!ItemModelUtil.isPixelAlwaysTransparent(sprite, frames, x, y)) {
                    if (ItemModelUtil.doesPixelHaveEdge(sprite, frames, x, y, PixelDirection.RIGHT)) {
                        if (first1 == -1) {
                            first1 = y;
                        }
                        last1 = y;
                    }
                    if (!ItemModelUtil.doesPixelHaveEdge(sprite, frames, x, y, PixelDirection.LEFT)) continue;
                    if (first2 == -1) {
                        first2 = y;
                    }
                    last2 = y;
                    continue;
                }
                if (first1 != -1) {
                    elements.add(ItemModelUtil.createVerticalOutlineElement(class_2350.field_11034, layer, key, first1, last1, x, height, animationFrameDelta, xFactor, yFactor));
                    first1 = -1;
                }
                if (first2 == -1) continue;
                elements.add(ItemModelUtil.createVerticalOutlineElement(class_2350.field_11039, layer, key, first2, last2, x, height, animationFrameDelta, xFactor, yFactor));
                first2 = -1;
            }
            if (first1 != -1) {
                elements.add(ItemModelUtil.createVerticalOutlineElement(class_2350.field_11034, layer, key, first1, last1, x, height, animationFrameDelta, xFactor, yFactor));
                first1 = -1;
            }
            if (first2 == -1) continue;
            elements.add(ItemModelUtil.createVerticalOutlineElement(class_2350.field_11039, layer, key, first2, last2, x, height, animationFrameDelta, xFactor, yFactor));
            first2 = -1;
        }
        return elements;
    }

    public static class_785 createHorizontalOutlineElement(class_2350 direction, int layer, String key, int start, int end, int y, int height, float animationFrameDelta, float xFactor, float yFactor) {
        EnumMap<class_2350, class_783> faces = new EnumMap<class_2350, class_783>(class_2350.class);
        faces.put(direction, new class_783(null, layer, key, ItemModelUtil.createUnlerpedTexture(new float[]{(float)start / xFactor, (float)y / yFactor, (float)(end + 1) / xFactor, (float)(y + 1) / yFactor}, 0, animationFrameDelta)));
        return new class_785(new class_1160((float)start / xFactor, (float)(height - (y + 1)) / yFactor, 7.5f), new class_1160((float)(end + 1) / xFactor, (float)(height - y) / yFactor, 8.5f), faces, null, true);
    }

    public static class_785 createVerticalOutlineElement(class_2350 direction, int layer, String key, int start, int end, int x, int height, float animationFrameDelta, float xFactor, float yFactor) {
        EnumMap<class_2350, class_783> faces = new EnumMap<class_2350, class_783>(class_2350.class);
        faces.put(direction, new class_783(null, layer, key, ItemModelUtil.createUnlerpedTexture(new float[]{(float)(x + 1) / xFactor, (float)start / yFactor, (float)x / xFactor, (float)(end + 1) / yFactor}, 0, animationFrameDelta)));
        return new class_785(new class_1160((float)x / xFactor, (float)(height - (end + 1)) / yFactor, 7.5f), new class_1160((float)(x + 1) / xFactor, (float)(height - start) / yFactor, 8.5f), faces, null, true);
    }

    public static class_787 createUnlerpedTexture(float[] uvs, int rotation, float delta) {
        return new class_787(MathUtil.unlerpUVs(uvs, delta), rotation);
    }

    public static List<class_785> createPixelLayerElements(int layer, String key, class_1058 sprite) {
        ArrayList<class_785> elements = new ArrayList<class_785>();
        int width = sprite.method_4578();
        int height = sprite.method_4595();
        float xFactor = (float)width / 16.0f;
        float yFactor = (float)height / 16.0f;
        int[] frames = sprite.method_33442().toArray();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (ItemModelUtil.isPixelAlwaysTransparent(sprite, frames, x, y)) continue;
                EnumMap<class_2350, class_783> faces = new EnumMap<class_2350, class_783>(class_2350.class);
                class_783 face = new class_783(null, layer, key, new class_787(new float[]{(float)x / xFactor, (float)y / yFactor, (float)(x + 1) / xFactor, (float)(y + 1) / yFactor}, 0));
                class_783 flippedFace = new class_783(null, layer, key, new class_787(new float[]{(float)(x + 1) / xFactor, (float)y / yFactor, (float)x / xFactor, (float)(y + 1) / yFactor}, 0));
                faces.put(class_2350.field_11035, face);
                faces.put(class_2350.field_11043, flippedFace);
                for (PixelDirection pixelDirection : PixelDirection.VALUES) {
                    if (!ItemModelUtil.doesPixelHaveEdge(sprite, frames, x, y, pixelDirection)) continue;
                    faces.put(pixelDirection.getDirection(), pixelDirection.isVertical() ? face : flippedFace);
                }
                elements.add(new class_785(new class_1160((float)x / xFactor, (float)(height - (y + 1)) / yFactor, 7.5f), new class_1160((float)(x + 1) / xFactor, (float)(height - y) / yFactor, 8.5f), faces, null, true));
            }
        }
        return elements;
    }

    public static boolean isPixelOutsideSprite(class_1058 sprite, int x, int y) {
        return x < 0 || y < 0 || x >= sprite.method_4578() || y >= sprite.method_4595();
    }

    public static boolean isPixelTransparent(class_1058 sprite, int frame, int x, int y) {
        return ItemModelUtil.isPixelOutsideSprite(sprite, x, y) ? true : sprite.method_4583(frame, x, y);
    }

    public static boolean isPixelAlwaysTransparent(class_1058 sprite, int[] frames, int x, int y) {
        for (int frame : frames) {
            if (ItemModelUtil.isPixelTransparent(sprite, frame, x, y)) continue;
            return false;
        }
        return true;
    }

    public static boolean doesPixelHaveEdge(class_1058 sprite, int[] frames, int x, int y, PixelDirection direction) {
        int y1;
        int x1 = x + direction.getOffsetX();
        if (ItemModelUtil.isPixelOutsideSprite(sprite, x1, y1 = y + direction.getOffsetY())) {
            return true;
        }
        for (int frame : frames) {
            if (ItemModelUtil.isPixelTransparent(sprite, frame, x, y) || !ItemModelUtil.isPixelTransparent(sprite, frame, x1, y1)) continue;
            return true;
        }
        return false;
    }
}

