/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.mixins;

import com.google.gson.internal.LinkedTreeMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.dorianpb.cem.internal.config.CemConfigFairy;
import net.dorianpb.cem.internal.file.JemFile;
import net.dorianpb.cem.internal.util.CemFairy;
import net.dorianpb.cem.internal.util.CemRegistryManager;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5599;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_5599.class})
public abstract class EntityModelLoaderMixin {
    @Inject(method={"reload"}, at={@At(value="HEAD")})
    private void cem$injectReload(class_3300 manager, CallbackInfo ci) {
        CemRegistryManager.clearRegistries();
        manager.method_14488("cem", path -> path.method_12832().endsWith(".jem")).forEach((id, resource) -> this.loadResourceFromId(manager, (class_2960)id, "dorianpb"));
        if (CemConfigFairy.getConfig().useOptifineFolder()) {
            manager.method_14488("optifine/cem", path -> path.method_12832().endsWith(".jem")).forEach((id, resource) -> this.loadResourceFromId(manager, (class_2960)id, "minecraft"));
        }
    }

    private void loadResourceFromId(class_3300 manager, class_2960 id, String namespace) {
        block17: {
            if (!id.method_12836().equals(namespace)) {
                return;
            }
            CemFairy.getLogger().info(id.toString());
            try (InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();){
                LinkedTreeMap json = (LinkedTreeMap)CemFairy.getGson().fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), LinkedTreeMap.class);
                if (json == null) {
                    throw new Exception("Invalid File");
                }
                JemFile file = new JemFile((LinkedTreeMap<String, Object>)json, id, manager);
                String entityName = CemFairy.getEntityNameFromId(id);
                Optional entityTypeOptional = class_1299.method_5898((String)entityName);
                Optional blockEntityTypeOptional = class_2378.field_11137.method_17966(class_2960.method_12829((String)entityName));
                if (entityTypeOptional.isPresent()) {
                    class_1299 entityType = (class_1299)entityTypeOptional.get();
                    if (CemFairy.isUnsupported((class_1299<? extends class_1297>)entityType)) {
                        throw new Exception("Entity \"" + class_1299.method_5890((class_1299)entityType) + "\" is unsupported!");
                    }
                    CemRegistryManager.addRegistry((class_1299<? extends class_1297>)entityType, file);
                } else if (blockEntityTypeOptional.isPresent()) {
                    class_2591 entityType = (class_2591)blockEntityTypeOptional.get();
                    if (CemFairy.isUnsupported((class_2591<? extends class_2586>)entityType)) {
                        throw new Exception("Block Entity \"" + class_2591.method_11033((class_2591)entityType) + "\" is unsupported!");
                    }
                    CemRegistryManager.addRegistry((class_2591<? extends class_2586>)entityType, file);
                } else {
                    if (CemFairy.isUnsupported(entityName)) {
                        throw new Exception("Unknown object \"" + entityName + "\"!");
                    }
                    CemRegistryManager.addRegistry(entityName, file);
                }
            }
            catch (Exception exception) {
                CemFairy.getLogger().error("Error parsing " + id + ":");
                String message = exception.getMessage();
                CemFairy.getLogger().error((Object)exception);
                if (message != null && !message.trim().equals("")) break block17;
                CemFairy.getLogger().error((Object)exception.getStackTrace()[0]);
                CemFairy.getLogger().error((Object)exception.getStackTrace()[1]);
                CemFairy.getLogger().error((Object)exception.getStackTrace()[2]);
            }
        }
    }
}

