/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.util;

import java.lang.invoke.WrongMethodTypeException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import net.dorianpb.cem.internal.models.CemModelEntry;
import net.dorianpb.cem.internal.models.CemModelRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;

public class CemStringParser {
    public static ParsedExpression parse(String expr, CemModelRegistry registry, CemModelEntry parent) {
        Token token = CemStringParser.initParseLoop(expr);
        ParsedFunction matched = CemStringParser.matchToken(token, registry, parent);
        if (matched.getType() == ParsedFunction.ParsedFunctionType.FLOAT) {
            return new ParsedExpressionFloat(token, registry, parent);
        }
        return new ParsedExpressionBool(token, registry, parent);
    }

    static ParsedFunction matchToken(Token token, CemModelRegistry registry, CemModelEntry parent) {
        if (token.getName().equals("NUM")) {
            try {
                return new ParsedNumber((NumToken)token);
            }
            catch (Exception ignored) {
                throw new IllegalArgumentException("Why is there a token named \"NUM\" that is not a NumToken?");
            }
        }
        if (token.getName().contains(".")) {
            return new ParsedVar(token, registry, parent);
        }
        if (token.getName().equalsIgnoreCase("if")) {
            return new ParsedIf(token, registry, parent);
        }
        try {
            return FLOAT_PARAMETER.valueOf(token.getName().toUpperCase());
        }
        catch (Exception exception) {
            try {
                return FLOAT_FUNCTION.valueOf(token.getName().toUpperCase());
            }
            catch (Exception exception2) {
                try {
                    return BOOL_PARAMETER.valueOf(token.getName().toUpperCase());
                }
                catch (Exception exception3) {
                    try {
                        return BOOL_FUNCTION_FLOAT.valueOf(token.getName().toUpperCase());
                    }
                    catch (Exception exception4) {
                        try {
                            return BOOL_FUNCTION_BOOL.valueOf(token.getName().toUpperCase());
                        }
                        catch (Exception exception5) {
                            throw new IllegalArgumentException("Unknown symbol \"" + token.getName() + "\"");
                        }
                    }
                }
            }
        }
    }

    private static Token initParseLoop(String input) {
        int i;
        ArrayList<String> work = new ArrayList<String>(Arrays.asList(input.replaceAll("\\s*(\\+|-|\\*|/|%|!=|\\|\\||&&|>=|<=|==|>|<)\\s*", " $1 ").replaceAll("!\\s*(\\w)", " ! $1").replaceAll("\\s*([(),])\\s*", " $1 ").replaceAll("(\\s)+", " ").replaceAll("\u00a7", "").trim().split(" ")));
        Pattern garbagePattern = Pattern.compile("^[+\\-*/%!=|&><\\w(),].*$");
        for (String badboi : work) {
            if (garbagePattern.matcher(badboi).find()) continue;
            throw new IllegalArgumentException("Garbage symbol \"" + badboi + "\"");
        }
        Pattern functionPattern = Pattern.compile("^(\\w\\d?)+$");
        int j = 0;
        while ((i = CemStringParser.regIndexOf(work, "^\\($", j)) >= 0) {
            j = i + 1;
            if (i <= 0 || !functionPattern.matcher(work.get(i - 1)).find()) continue;
            work.set(i + CemStringParser.takeParen(work, i).size() + 1, "}");
            work.set(i, "{");
        }
        return CemStringParser.parseLoop(work, new ArrayList<Token>());
    }

    private static Token parseLoop(ArrayList<String> input, ArrayList<Token> tokens) {
        ArrayList<String> work = new ArrayList<String>(input);
        int i = -1;
        try {
            int j;
            while ((i = CemStringParser.regIndexOf(work, "^\\{$")) >= 0) {
                int k = CemStringParser.indexOfEndOfArgs(work, i);
                tokens.add(new Token(work.get(i - 1), CemStringParser.parseArgs(work, tokens, i, k)));
                for (j = k - i + 2; j > 0; --j) {
                    work.remove(i - 1);
                }
                work.add(i - 1, "\u00a7" + (tokens.size() - 1));
            }
            while ((i = CemStringParser.regIndexOf(work, "^\\($")) >= 0) {
                ArrayList<String> sub = CemStringParser.takeParen(work, i);
                if (sub.size() == 0) {
                    throw new IllegalArgumentException("Invalid Syntax: " + (i > 0 ? work.get(i - 1) : "") + work.get(i) + (i < work.size() - 1 ? work.get(i + 1) : ""));
                }
                for (j = sub.size() + 2; j > 0; --j) {
                    work.remove(i);
                }
                tokens.add(CemStringParser.parseLoop(sub, tokens));
                work.add(i, "\u00a7" + (tokens.size() - 1));
            }
            while ((i = CemStringParser.regIndexOf(work, "^(\\d+)([.]\\d+)?$")) >= 0) {
                tokens.add(new NumToken(Float.parseFloat(work.set(i, "\u00a7" + tokens.size()))));
            }
            while ((i = CemStringParser.regIndexOf(work, "^\\w(\\w\\d?:?)+([.]\\w\\w)?$")) >= 0) {
                tokens.add(new Token(work.set(i, "\u00a7" + tokens.size())));
            }
            i = 0;
            while (true) {
                if (!((i = CemStringParser.regIndexOf(work, "^[-+]$", i)) < 0 || i != 0 && work.get(i - 1).startsWith("\u00a7"))) {
                    if (work.get(i).equals("-")) {
                        tokens.add(new NumToken(0.0f));
                        work.add(i, "\u00a7" + (tokens.size() - 1));
                        ArrayList<Token> args = new ArrayList<Token>();
                        args.add(CemStringParser.getToken(work.get(++i - 1), tokens));
                        args.add(CemStringParser.getToken(work.get(i + 1), tokens));
                        tokens.add(new Token("SUB", args));
                        work.remove(i);
                        work.remove(i);
                        work.set(i - 1, "\u00a7" + (tokens.size() - 1));
                        continue;
                    }
                    work.remove(i);
                    continue;
                }
                if (i == -1) break;
                ++i;
            }
            while ((i = CemStringParser.regIndexOf(work, "^[*/%]$")) >= 0) {
                ArrayList<Token> args = new ArrayList<Token>();
                args.add(CemStringParser.getToken(work.get(i - 1), tokens));
                args.add(CemStringParser.getToken(work.get(i + 1), tokens));
                String name = switch (work.get(i)) {
                    case "*" -> "MULT";
                    case "/" -> "DIV";
                    case "%" -> "MOD";
                    default -> throw new IllegalStateException("Unexpected value: " + work.get(i));
                };
                tokens.add(new Token(name, args));
                work.remove(i);
                work.remove(i);
                work.set(i - 1, "\u00a7" + (tokens.size() - 1));
            }
            while ((i = CemStringParser.regIndexOf(work, "^[+-]$")) >= 0) {
                ArrayList<Token> args = new ArrayList<Token>();
                args.add(CemStringParser.getToken(work.get(i - 1), tokens));
                args.add(CemStringParser.getToken(work.get(i + 1), tokens));
                tokens.add(new Token(work.get(i).equals("+") ? "ADD" : "SUB", args));
                work.remove(i);
                work.remove(i);
                work.set(i - 1, "\u00a7" + (tokens.size() - 1));
            }
            while ((i = CemStringParser.regIndexOf(work, "^!$")) >= 0) {
                ArrayList<Token> args = new ArrayList<Token>();
                args.add(CemStringParser.getToken(work.get(i + 1), tokens));
                work.remove(i + 1);
                tokens.add(new Token("NOT", args));
                work.set(i, "\u00a7" + (tokens.size() - 1));
            }
            while ((i = CemStringParser.regIndexOf(work, "^==|!=|<=|>=|<|>$")) >= 0) {
                ArrayList<Token> args = new ArrayList<Token>();
                args.add(CemStringParser.getToken(work.get(i - 1), tokens));
                args.add(CemStringParser.getToken(work.get(i + 1), tokens));
                String name = switch (work.get(i)) {
                    case "==" -> "EQ";
                    case "!=" -> "NOTEQ";
                    case "<=" -> "LESSEQ";
                    case ">=" -> "GREATEREQ";
                    case "<" -> "LESS";
                    case ">" -> "GREATER";
                    default -> throw new IllegalStateException("Unexpected value: " + work.get(i));
                };
                tokens.add(new Token(name, args));
                work.remove(i);
                work.remove(i);
                work.set(i - 1, "\u00a7" + (tokens.size() - 1));
            }
            while ((i = CemStringParser.regIndexOf(work, "^&&|\\|\\|$")) >= 0) {
                ArrayList<Token> args = new ArrayList<Token>();
                args.add(CemStringParser.getToken(work.get(i - 1), tokens));
                args.add(CemStringParser.getToken(work.get(i + 1), tokens));
                tokens.add(new Token(work.get(i).equals("&&") ? "AND" : "OR", args));
                work.remove(i);
                work.remove(i);
                work.set(i - 1, "\u00a7" + (tokens.size() - 1));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\"" + e + "\" occurred when trying to parse animation at index " + i + "!");
        }
        if (work.size() != 1) {
            for (String badboi : work) {
                if (badboi.charAt(0) == '\u00a7') continue;
                throw new IllegalArgumentException("Unknown symbol \"" + badboi + "\"");
            }
            throw new IllegalArgumentException("Error parsing " + work);
        }
        return CemStringParser.getToken(work.get(0), tokens);
    }

    private static ArrayList<String> takeParen(ArrayList<String> strings, int start) {
        int lvl = 0;
        if (!strings.get(start).equals("(")) {
            throw new IllegalArgumentException("Expecting \"(\", received \"" + strings.get(start) + "\"");
        }
        for (int w = start; w < strings.size(); ++w) {
            if (strings.get(w).equals("(")) {
                ++lvl;
            }
            if (!strings.get(w).equals(")") || --lvl != 0) continue;
            return new ArrayList<String>(strings.subList(start + 1, w));
        }
        throw new NullPointerException("expected \")\"");
    }

    private static int indexOfEndOfArgs(ArrayList<String> strings, int start) {
        int lvl = 0;
        if (!strings.get(start).equals("{")) {
            throw new IllegalArgumentException("Expecting \"{\", received \"" + strings.get(start) + "\"");
        }
        for (int w = start; w < strings.size(); ++w) {
            if (strings.get(w).equals("{")) {
                ++lvl;
            }
            if (!strings.get(w).equals("}") || --lvl != 0) continue;
            return w;
        }
        throw new NullPointerException("expected \"}\"");
    }

    private static ArrayList<Token> parseArgs(ArrayList<String> strings, ArrayList<Token> tokens, int start, int end) {
        int count = 0;
        int lvl = 0;
        ArrayList args = new ArrayList();
        ArrayList<Token> tokenArgs = new ArrayList<Token>();
        for (int w = start + 1; w < end; ++w) {
            if (strings.get(w).equals(",") && lvl == 0) {
                ++count;
                continue;
            }
            if (strings.get(w).equals("{")) {
                ++lvl;
            }
            if (strings.get(w).equals("}")) {
                --lvl;
            }
            if (args.size() == count) {
                args.add(new ArrayList());
            }
            ((ArrayList)args.get(count)).add(strings.get(w));
        }
        for (ArrayList arrayList : args) {
            tokenArgs.add(CemStringParser.parseLoop(arrayList, tokens));
        }
        return tokenArgs;
    }

    private static int regIndexOf(ArrayList<String> input, String regex, int start) {
        Pattern pattern = Pattern.compile(regex);
        return CemStringParser.regIndexOf(input, pattern, start);
    }

    private static int regIndexOf(ArrayList<String> input, Pattern pattern, int start) {
        for (int i = start; i < input.size(); ++i) {
            if (!pattern.matcher(input.get(i)).find()) continue;
            return i;
        }
        return -1;
    }

    private static int regIndexOf(ArrayList<String> input, String regex) {
        return CemStringParser.regIndexOf(input, regex, 0);
    }

    private static Token getToken(String expression, ArrayList<Token> temp) {
        if (expression.charAt(0) == '\u00a7') {
            return temp.get(Integer.parseInt(expression.substring(1)));
        }
        throw new IllegalArgumentException("Invalid token reference " + expression);
    }

    private static class Token {
        private final String name;
        private final ArrayList<Token> args;

        Token(String name, ArrayList<Token> args) {
            this.name = name;
            this.args = args;
        }

        Token(String name) {
            this.name = name;
            this.args = null;
        }

        String getName() {
            return this.name;
        }

        ArrayList<Token> getArgs() {
            return this.args;
        }
    }

    static interface ParsedFunction {
        public ParsedFunctionType getType();

        public int getArgNumber();

        public static interface ParsedFunctionBool
        extends ParsedFunction {
            public Boolean eval(ArrayList<ParsedExpression> var1, Environment var2);

            public ParsedFunctionType getArgType();

            @Override
            default public ParsedFunctionType getType() {
                return ParsedFunctionType.BOOL;
            }
        }

        public static interface ParsedFunctionFloat
        extends ParsedFunction {
            public Float eval(ArrayList<ParsedExpression> var1, Environment var2);

            @Override
            default public ParsedFunctionType getType() {
                return ParsedFunctionType.FLOAT;
            }
        }

        public static enum ParsedFunctionType {
            FLOAT,
            BOOL;

        }
    }

    static class ParsedExpressionFloat
    implements ParsedExpression {
        private final ParsedFunction.ParsedFunctionFloat operation;
        private final ArrayList<ParsedExpression> arguments;

        ParsedExpressionFloat(Token token, CemModelRegistry registry, CemModelEntry parent) {
            ParsedFunction temp = CemStringParser.matchToken(token, registry, parent);
            if (temp.getType() != ParsedFunction.ParsedFunctionType.FLOAT) {
                throw new InvalidParameterException("\"" + token.getName() + "\" is not a number and will not return a number!");
            }
            this.operation = (ParsedFunction.ParsedFunctionFloat)temp;
            if (token.getArgs() != null && this.operation.getClass() != ParsedIf.class) {
                this.arguments = new ArrayList();
                for (Token arg : token.getArgs()) {
                    try {
                        this.arguments.add(new ParsedExpressionFloat(arg, registry, parent));
                    }
                    catch (InvalidParameterException ignored) {
                        throw new IllegalArgumentException("\"" + token.getName() + "\" requires numbers as arguments and \"" + arg.getName() + "\" is not a number!");
                    }
                }
            } else {
                this.arguments = token.getArgs() != null ? new ArrayList() : null;
            }
            this.checkArgs(this.arguments, this.operation.getArgNumber());
        }

        float eval(Environment env) {
            return this.operation.eval(this.arguments, env).floatValue();
        }

        @Override
        public String getName() {
            return this.operation.toString();
        }
    }

    static class ParsedExpressionBool
    implements ParsedExpression {
        private final ParsedFunction.ParsedFunctionBool operation;
        private final ArrayList<ParsedExpression> arguments;

        ParsedExpressionBool(Token token, CemModelRegistry registry, CemModelEntry parent) {
            ParsedFunction temp = CemStringParser.matchToken(token, registry, parent);
            if (temp.getType() != ParsedFunction.ParsedFunctionType.BOOL) {
                throw new InvalidParameterException("\"" + token.getName() + "\" is not a number and will not return a number!");
            }
            this.operation = (ParsedFunction.ParsedFunctionBool)temp;
            if (token.getArgs() != null) {
                this.arguments = new ArrayList();
                for (Token arg : token.getArgs()) {
                    if (this.operation.getArgType() == ParsedFunction.ParsedFunctionType.FLOAT) {
                        try {
                            this.arguments.add(new ParsedExpressionFloat(arg, registry, parent));
                            continue;
                        }
                        catch (InvalidParameterException ignored) {
                            throw new IllegalArgumentException("\"" + token.getName() + "\" requires numbers as arguments and \"" + arg.getName() + "\" is not a number!");
                        }
                    }
                    try {
                        this.arguments.add(new ParsedExpressionBool(arg, registry, parent));
                    }
                    catch (InvalidParameterException ignored) {
                        throw new IllegalArgumentException("\"" + token.getName() + "\" requires bools as arguments and \"" + arg.getName() + "\" is not a bool!");
                    }
                }
            } else {
                this.arguments = null;
            }
            this.checkArgs(this.arguments, this.operation.getArgNumber());
        }

        boolean eval(Environment env) {
            return this.operation.eval(this.arguments, env);
        }

        @Override
        public String getName() {
            return this.operation.toString();
        }
    }

    static class ParsedNumber
    implements ParsedFunction.ParsedFunctionFloat {
        private final float num;

        ParsedNumber(NumToken token) {
            this.num = token.getNum();
        }

        @Override
        public int getArgNumber() {
            return -2;
        }

        @Override
        public Float eval(ArrayList<ParsedExpression> args, Environment env) {
            return Float.valueOf(this.num);
        }
    }

    private static class NumToken
    extends Token {
        private final float num;

        NumToken(float num) {
            super("NUM", null);
            this.num = num;
        }

        float getNum() {
            return this.num;
        }
    }

    static class ParsedVar
    implements ParsedFunction.ParsedFunctionFloat {
        private static final Pattern PATTERN = Pattern.compile("(\\w\\d?:?)+[.][trs][xyz]");
        private final CemModelEntry entry;
        private final char val;
        private final char axis;

        ParsedVar(Token token, CemModelRegistry registry, CemModelEntry parent) {
            if (!PATTERN.matcher(token.getName()).find()) {
                throw new IllegalArgumentException("\"" + token.getName() + "\" isn't a reference to a model part");
            }
            this.entry = registry.findChild(token.getName().substring(0, token.getName().indexOf(".")), parent);
            this.val = token.getName().charAt(token.getName().indexOf(".") + 1);
            this.axis = token.getName().charAt(token.getName().indexOf(".") + 2);
        }

        @Override
        public int getArgNumber() {
            return -2;
        }

        @Override
        public Float eval(ArrayList<ParsedExpression> args, Environment env) {
            return switch (this.val) {
                case 't' -> Float.valueOf(this.entry.getTranslate(this.axis));
                case 'r' -> Float.valueOf(this.entry.getModel().getRotation(this.axis));
                case 's' -> Float.valueOf(this.entry.getModel().getScale(this.axis));
                default -> throw new IllegalStateException("Unknown operation \"" + this.val + "\"");
            };
        }
    }

    static class ParsedIf
    implements ParsedFunction.ParsedFunctionFloat {
        private final ArrayList<ParsedExpressionBool> conditions;
        private final ArrayList<ParsedExpressionFloat> expressions;

        ParsedIf(Token token, CemModelRegistry registry, CemModelEntry parent) {
            if (token.getArgs() == null) {
                throw new IllegalArgumentException("\"" + token.getName() + "\" requires arguments!");
            }
            this.conditions = new ArrayList();
            this.expressions = new ArrayList();
            for (int i = 0; i < token.getArgs().size(); ++i) {
                ParsedFunction.ParsedFunctionType wantedType;
                ParsedFunction.ParsedFunctionType parsedFunctionType = wantedType = i % 2 == 1 || i == token.getArgs().size() - 1 ? ParsedFunction.ParsedFunctionType.FLOAT : ParsedFunction.ParsedFunctionType.BOOL;
                if (wantedType == ParsedFunction.ParsedFunctionType.BOOL) {
                    try {
                        this.conditions.add(new ParsedExpressionBool(token.getArgs().get(i), registry, parent));
                        continue;
                    }
                    catch (InvalidParameterException ignored) {
                        throw new IllegalArgumentException("\"" + token.getName() + "\" requires a bool for argument #" + (i + 1) + ", but a number was provided");
                    }
                }
                try {
                    this.expressions.add(new ParsedExpressionFloat(token.getArgs().get(i), registry, parent));
                    continue;
                }
                catch (InvalidParameterException ignored) {
                    throw new IllegalArgumentException("\"" + token.getName() + "\" requires a number for argument #" + (i + 1) + ", but a bool was provided");
                }
            }
            if (this.conditions.size() == 0) {
                throw new IllegalArgumentException("\"" + token.getName() + "\" requires at least one condition!");
            }
            if (this.conditions.size() + 1 != this.expressions.size()) {
                throw new IllegalArgumentException("\"" + token.getName() + "\" is missing an \"val_else\" value, please add a number at the end.");
            }
        }

        @Override
        public Float eval(ArrayList<ParsedExpression> args, Environment env) {
            for (int i = 0; i < this.conditions.size(); ++i) {
                if (!this.conditions.get(i).eval(env)) continue;
                return Float.valueOf(this.expressions.get(i).eval(env));
            }
            return Float.valueOf(this.expressions.get(this.expressions.size() - 1).eval(env));
        }

        @Override
        public ParsedFunction.ParsedFunctionType getType() {
            return ParsedFunction.ParsedFunctionType.FLOAT;
        }

        @Override
        public int getArgNumber() {
            return -1;
        }
    }

    static enum FLOAT_PARAMETER implements ParsedFunction.ParsedFunctionFloat
    {
        LIMB_SWING,
        LIMB_SPEED,
        AGE,
        HEAD_YAW,
        HEAD_PITCH,
        HEALTH,
        HURT_TIME,
        IDLE_TIME,
        MAX_HEALTH,
        MOVE_FORWARD,
        MOVE_STRAFING,
        POS_X,
        POS_Y,
        POS_Z,
        REVENGE_TIME,
        SWING_PROGRESS,
        TIME,
        PI;


        @Override
        public Float eval(ArrayList<ParsedExpression> args, Environment env) {
            switch (this) {
                case AGE: {
                    return Float.valueOf(env.getAge());
                }
                case HEAD_YAW: {
                    return Float.valueOf(env.getHead_yaw());
                }
                case HEAD_PITCH: {
                    return Float.valueOf(env.getHead_pitch());
                }
                case LIMB_SPEED: {
                    return Float.valueOf(env.getLimbDistance());
                }
                case LIMB_SWING: {
                    return Float.valueOf(env.getLimbAngle());
                }
                case TIME: {
                    class_310 minecraft = class_310.method_1551();
                    class_638 world = minecraft.field_1687;
                    return Float.valueOf(world == null ? 0.0f : (float)(world.method_8510() % 24000L) + minecraft.method_1488());
                }
                case PI: {
                    return Float.valueOf(3.1415925f);
                }
                case HEALTH: {
                    return Float.valueOf(env.getLivingEntity().method_6032());
                }
                case HURT_TIME: {
                    return Float.valueOf(env.getLivingEntity().field_6235);
                }
                case IDLE_TIME: {
                    return Float.valueOf(env.getLivingEntity().method_6083());
                }
                case MAX_HEALTH: {
                    return Float.valueOf(env.getLivingEntity().method_6063());
                }
                case MOVE_FORWARD: {
                    return Float.valueOf(env.getLivingEntity().field_6250);
                }
                case MOVE_STRAFING: {
                    return Float.valueOf(env.getLivingEntity().field_6212);
                }
                case POS_X: {
                    return Float.valueOf((float)env.getEntity().method_23317());
                }
                case POS_Y: {
                    return Float.valueOf((float)env.getEntity().method_23318());
                }
                case POS_Z: {
                    return Float.valueOf((float)env.getEntity().method_23321());
                }
                case REVENGE_TIME: {
                    return Float.valueOf(env.getLivingEntity().method_6117());
                }
                case SWING_PROGRESS: {
                    return Float.valueOf(env.getLivingEntity().field_6251);
                }
            }
            throw new NullPointerException("uwu");
        }

        @Override
        public ParsedFunction.ParsedFunctionType getType() {
            return ParsedFunction.ParsedFunctionType.FLOAT;
        }

        @Override
        public int getArgNumber() {
            return -2;
        }
    }

    static enum FLOAT_FUNCTION implements ParsedFunction.ParsedFunctionFloat
    {
        SIN,
        COS,
        ASIN,
        ACOS,
        TAN,
        ATAN,
        ATAN2,
        TORAD,
        TODEG,
        MIN,
        MAX,
        CLAMP,
        ABS,
        FLOOR,
        CEIL,
        EXP,
        FRAC,
        LOG,
        POW,
        RANDOM,
        ROUND,
        SIGNUM,
        SQRT,
        FMOD,
        ADD,
        SUB,
        MULT,
        DIV,
        MOD;


        @Override
        public Float eval(ArrayList<ParsedExpression> args, Environment env) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case SIN -> Float.valueOf(class_3532.method_15374((float)((ParsedExpressionFloat)args.get(0)).eval(env)));
                case COS -> Float.valueOf(class_3532.method_15362((float)((ParsedExpressionFloat)args.get(0)).eval(env)));
                case ASIN -> Float.valueOf((float)Math.asin(((ParsedExpressionFloat)args.get(0)).eval(env)));
                case ACOS -> Float.valueOf((float)Math.acos(((ParsedExpressionFloat)args.get(0)).eval(env)));
                case TAN -> Float.valueOf((float)Math.tan(((ParsedExpressionFloat)args.get(0)).eval(env)));
                case ATAN -> Float.valueOf((float)Math.atan(((ParsedExpressionFloat)args.get(0)).eval(env)));
                case ATAN2 -> Float.valueOf((float)class_3532.method_15349((double)((ParsedExpressionFloat)args.get(0)).eval(env), (double)((ParsedExpressionFloat)args.get(1)).eval(env)));
                case TORAD -> Float.valueOf((float)Math.toRadians(((ParsedExpressionFloat)args.get(0)).eval(env)));
                case TODEG -> Float.valueOf((float)Math.toDegrees(((ParsedExpressionFloat)args.get(0)).eval(env)));
                case MIN -> Float.valueOf(this.findExtreme(args, env, false));
                case MAX -> Float.valueOf(this.findExtreme(args, env, true));
                case CLAMP -> Float.valueOf(class_3532.method_15363((float)((ParsedExpressionFloat)args.get(0)).eval(env), (float)((ParsedExpressionFloat)args.get(1)).eval(env), (float)((ParsedExpressionFloat)args.get(2)).eval(env)));
                case ABS -> Float.valueOf(class_3532.method_15379((float)((ParsedExpressionFloat)args.get(0)).eval(env)));
                case FLOOR -> Float.valueOf(class_3532.method_15365((double)((ParsedExpressionFloat)args.get(0)).eval(env)));
                case CEIL -> Float.valueOf(class_3532.method_15386((float)((ParsedExpressionFloat)args.get(0)).eval(env)));
                case EXP -> Float.valueOf((float)Math.exp(((ParsedExpressionFloat)args.get(0)).eval(env)));
                case FRAC -> Float.valueOf(class_3532.method_22450((float)((ParsedExpressionFloat)args.get(0)).eval(env)));
                case LOG -> Float.valueOf((float)Math.log(((ParsedExpressionFloat)args.get(0)).eval(env)));
                case POW -> Float.valueOf((float)Math.pow(((ParsedExpressionFloat)args.get(0)).eval(env), ((ParsedExpressionFloat)args.get(1)).eval(env)));
                case RANDOM -> Float.valueOf((float)Math.random());
                case ROUND -> Float.valueOf(Math.round(((ParsedExpressionFloat)args.get(0)).eval(env)));
                case SIGNUM -> Float.valueOf(Math.signum(((ParsedExpressionFloat)args.get(0)).eval(env)));
                case SQRT -> Float.valueOf(class_3532.method_15355((float)((ParsedExpressionFloat)args.get(0)).eval(env)));
                case FMOD -> Float.valueOf(class_3532.method_15341((float)((ParsedExpressionFloat)args.get(0)).eval(env), (float)((ParsedExpressionFloat)args.get(1)).eval(env)));
                case ADD -> Float.valueOf(((ParsedExpressionFloat)args.get(0)).eval(env) + ((ParsedExpressionFloat)args.get(1)).eval(env));
                case SUB -> Float.valueOf(((ParsedExpressionFloat)args.get(0)).eval(env) - ((ParsedExpressionFloat)args.get(1)).eval(env));
                case MULT -> Float.valueOf(((ParsedExpressionFloat)args.get(0)).eval(env) * ((ParsedExpressionFloat)args.get(1)).eval(env));
                case DIV -> Float.valueOf(((ParsedExpressionFloat)args.get(0)).eval(env) / ((ParsedExpressionFloat)args.get(1)).eval(env));
                case MOD -> Float.valueOf(((ParsedExpressionFloat)args.get(0)).eval(env) % ((ParsedExpressionFloat)args.get(1)).eval(env));
            };
        }

        @Override
        public ParsedFunction.ParsedFunctionType getType() {
            return ParsedFunction.ParsedFunctionType.FLOAT;
        }

        private float findExtreme(ArrayList<ParsedExpression> args, Environment env, boolean big) {
            float[] nums = new float[args.size()];
            for (int i = 0; i < args.size(); ++i) {
                nums[i] = ((ParsedExpressionFloat)args.get(i)).eval(env);
            }
            Arrays.sort(nums);
            return big ? nums[nums.length - 1] : nums[0];
        }

        @Override
        public int getArgNumber() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case SIN, COS, ASIN, ACOS, TAN, ATAN, TORAD, TODEG, ABS, FLOOR, CEIL, EXP, FRAC, LOG, ROUND, SIGNUM, SQRT -> 1;
                case ATAN2, POW, FMOD, ADD, SUB, MULT, DIV, MOD -> 2;
                case MIN, MAX -> -1;
                case CLAMP -> 3;
                case RANDOM -> 0;
            };
        }
    }

    static enum BOOL_PARAMETER implements ParsedFunction.ParsedFunctionBool
    {
        IS_ALIVE,
        IS_BURNING,
        IS_CHILD,
        IS_GLOWING,
        IS_HURT,
        IS_IN_LAVA,
        IS_IN_WATER,
        IS_INVISIBLE,
        IS_ON_GROUND,
        IS_RIDDEN,
        IS_RIDING,
        IS_SNEAKING,
        IS_SPRINTING,
        IS_WET,
        TRUE,
        FALSE;


        @Override
        public Boolean eval(ArrayList<ParsedExpression> args, Environment env) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case IS_ALIVE -> env.getEntity().method_5805();
                case IS_BURNING -> env.getEntity().method_5809();
                case IS_CHILD -> env.getLivingEntity().method_6109();
                case IS_GLOWING -> env.getEntity().method_5851();
                case IS_HURT -> env.getLivingEntity().field_6235 != 0;
                case IS_IN_LAVA -> env.getEntity().method_5771();
                case IS_IN_WATER -> env.getEntity().method_5869();
                case IS_INVISIBLE -> env.getEntity().method_5767();
                case IS_ON_GROUND -> env.getEntity().method_24828();
                case IS_RIDDEN -> env.getEntity().method_5782();
                case IS_RIDING -> env.getEntity().method_5765();
                case IS_SNEAKING -> env.getEntity().method_5715();
                case IS_SPRINTING -> env.getEntity().method_5624();
                case IS_WET -> env.getEntity().method_5637();
                case TRUE -> true;
                case FALSE -> false;
            };
        }

        @Override
        public ParsedFunction.ParsedFunctionType getArgType() {
            return null;
        }

        @Override
        public ParsedFunction.ParsedFunctionType getType() {
            return ParsedFunction.ParsedFunctionType.BOOL;
        }

        @Override
        public int getArgNumber() {
            return -2;
        }
    }

    static enum BOOL_FUNCTION_FLOAT implements ParsedFunction.ParsedFunctionBool
    {
        BETWEEN,
        EQUALS,
        IN,
        GREATER,
        GREATEREQ,
        LESS,
        LESSEQ,
        EQ,
        NOTEQ;


        @Override
        public Boolean eval(ArrayList<ParsedExpression> args, Environment env) {
            switch (this) {
                case BETWEEN: {
                    return ((ParsedExpressionFloat)args.get(1)).eval(env) <= ((ParsedExpressionFloat)args.get(0)).eval(env) && ((ParsedExpressionFloat)args.get(0)).eval(env) <= ((ParsedExpressionFloat)args.get(2)).eval(env);
                }
                case EQUALS: {
                    return ((ParsedExpressionFloat)args.get(1)).eval(env) - ((ParsedExpressionFloat)args.get(2)).eval(env) <= ((ParsedExpressionFloat)args.get(0)).eval(env) && ((ParsedExpressionFloat)args.get(0)).eval(env) <= ((ParsedExpressionFloat)args.get(1)).eval(env) + ((ParsedExpressionFloat)args.get(2)).eval(env);
                }
                case IN: {
                    boolean x = false;
                    for (int i = 1; i < args.size(); ++i) {
                        x = x || ((ParsedExpressionFloat)args.get(0)).eval(env) == ((ParsedExpressionFloat)args.get(i)).eval(env);
                    }
                    return x;
                }
                case GREATER: {
                    return ((ParsedExpressionFloat)args.get(0)).eval(env) > ((ParsedExpressionFloat)args.get(1)).eval(env);
                }
                case GREATEREQ: {
                    return ((ParsedExpressionFloat)args.get(0)).eval(env) >= ((ParsedExpressionFloat)args.get(1)).eval(env);
                }
                case LESS: {
                    return ((ParsedExpressionFloat)args.get(0)).eval(env) < ((ParsedExpressionFloat)args.get(1)).eval(env);
                }
                case LESSEQ: {
                    return ((ParsedExpressionFloat)args.get(0)).eval(env) <= ((ParsedExpressionFloat)args.get(1)).eval(env);
                }
                case EQ: {
                    return ((ParsedExpressionFloat)args.get(0)).eval(env) == ((ParsedExpressionFloat)args.get(1)).eval(env);
                }
                case NOTEQ: {
                    return ((ParsedExpressionFloat)args.get(0)).eval(env) != ((ParsedExpressionFloat)args.get(1)).eval(env);
                }
            }
            throw new NullPointerException("my brain ... TREMBLES!");
        }

        @Override
        public ParsedFunction.ParsedFunctionType getArgType() {
            return ParsedFunction.ParsedFunctionType.FLOAT;
        }

        @Override
        public ParsedFunction.ParsedFunctionType getType() {
            return ParsedFunction.ParsedFunctionType.BOOL;
        }

        @Override
        public int getArgNumber() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case BETWEEN, EQUALS -> 3;
                case IN -> -1;
                case GREATER, GREATEREQ, LESS, LESSEQ, EQ, NOTEQ -> 2;
            };
        }
    }

    static enum BOOL_FUNCTION_BOOL implements ParsedFunction.ParsedFunctionBool
    {
        NOT,
        AND,
        OR;


        @Override
        public Boolean eval(ArrayList<ParsedExpression> args, Environment env) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NOT -> !((ParsedExpressionBool)args.get(0)).eval(env);
                case AND -> ((ParsedExpressionBool)args.get(0)).eval(env) && ((ParsedExpressionBool)args.get(1)).eval(env);
                case OR -> ((ParsedExpressionBool)args.get(0)).eval(env) || ((ParsedExpressionBool)args.get(1)).eval(env);
            };
        }

        @Override
        public ParsedFunction.ParsedFunctionType getArgType() {
            return ParsedFunction.ParsedFunctionType.BOOL;
        }

        @Override
        public ParsedFunction.ParsedFunctionType getType() {
            return ParsedFunction.ParsedFunctionType.BOOL;
        }

        @Override
        public int getArgNumber() {
            return this == NOT ? 1 : 2;
        }
    }

    private static class Environment {
        private final float limbAngle;
        private final float limbDistance;
        private final float age;
        private final float head_yaw;
        private final float head_pitch;
        private final class_1297 entity;

        private Environment(float limbAngle, float limbDistance, float age, float head_yaw, float head_pitch, class_1297 entity) {
            this.limbAngle = limbAngle;
            this.limbDistance = limbDistance;
            this.age = age;
            this.head_yaw = head_yaw;
            this.head_pitch = head_pitch;
            this.entity = entity;
        }

        private float getLimbAngle() {
            return this.limbAngle;
        }

        private float getLimbDistance() {
            return this.limbDistance;
        }

        private float getAge() {
            return this.age;
        }

        private float getHead_yaw() {
            return this.head_yaw;
        }

        private float getHead_pitch() {
            return this.head_pitch;
        }

        private class_1297 getEntity() {
            return this.entity;
        }

        private class_1309 getLivingEntity() {
            return (class_1309)this.entity;
        }
    }

    public static interface ParsedExpression {
        default public void checkArgs(ArrayList<ParsedExpression> args, int paramNum) {
            if (args == null && paramNum != -2) {
                throw new IllegalArgumentException("Function \"" + this.getName().toLowerCase() + "\" should be be followed with \"()\", as it is not a parameter!");
            }
            if (args != null && paramNum == -2) {
                throw new IllegalArgumentException("Parameter \"" + this.getName().toLowerCase() + "\" does not take arguments and should not have any \"()\"!");
            }
            if (paramNum > -1 && args.size() != paramNum) {
                throw new IllegalArgumentException("Function \"" + this.getName().toLowerCase() + "\" needs exactly " + paramNum + " parameters, but " + args.size() + " " + (args.size() == 1 ? "was" : "were") + " given!");
            }
        }

        public String getName();

        default public float eval(float limbAngle, float limbDistance, float age, float head_yaw, float head_pitch, class_1297 entity, CemModelRegistry registry) {
            if (this.getClass() == ParsedExpressionBool.class) {
                throw new WrongMethodTypeException("\"" + this.getName() + " must evaluate to a number, not a boolean!");
            }
            return ((ParsedExpressionFloat)this).eval(new Environment(limbAngle, limbDistance, age, head_yaw, head_pitch, entity));
        }
    }
}

