/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.animatica.util;

import com.google.common.collect.ImmutableMap;
import io.github.foundationgames.animatica.util.exception.InvalidPropertyException;
import io.github.foundationgames.animatica.util.exception.MissingPropertyException;
import io.github.foundationgames.animatica.util.exception.PropertyParseException;
import java.util.Map;
import java.util.Properties;
import net.minecraft.class_2960;

public final class PropertyUtil
extends Enum<PropertyUtil> {
    private static final /* synthetic */ PropertyUtil[] $VALUES;

    public static PropertyUtil[] values() {
        return (PropertyUtil[])$VALUES.clone();
    }

    public static PropertyUtil valueOf(String name) {
        return Enum.valueOf(PropertyUtil.class, name);
    }

    public static String get(class_2960 file, Properties properties, String key) throws PropertyParseException {
        String p = properties.getProperty(key);
        if (p == null) {
            throw new MissingPropertyException(file, key);
        }
        return p;
    }

    public static Properties getSubProperties(Properties properties, String key) {
        Properties p = new Properties();
        String prefix = key + ".";
        for (String k : properties.stringPropertyNames()) {
            if (!k.startsWith(prefix)) continue;
            String newKey = k.replaceFirst(prefix, "");
            p.setProperty(newKey, properties.getProperty(k));
        }
        return p;
    }

    public static int getInt(class_2960 file, Properties properties, String key) throws PropertyParseException {
        int r;
        try {
            r = Integer.parseInt(PropertyUtil.get(file, properties, key));
        }
        catch (NumberFormatException ignored) {
            throw new InvalidPropertyException(file, key, "integer (whole number)");
        }
        return r;
    }

    public static boolean getBool(class_2960 file, Properties properties, String key) throws PropertyParseException {
        String p = PropertyUtil.get(file, properties, key);
        if ("false".equals(p) || "true".equals(p)) {
            return "true".equals(p);
        }
        throw new InvalidPropertyException(file, key, "boolean (false/true)");
    }

    public static String getOr(class_2960 file, Properties properties, String key, String defaultVal) throws PropertyParseException {
        String p = properties.getProperty(key);
        if (p == null) {
            return defaultVal;
        }
        return p;
    }

    public static int getIntOr(class_2960 file, Properties properties, String key, int defaultVal) throws PropertyParseException {
        int r;
        String p = properties.getProperty(key);
        if (p == null) {
            return defaultVal;
        }
        try {
            r = Integer.parseInt(p);
        }
        catch (NumberFormatException ignored) {
            throw new InvalidPropertyException(file, key, "integer");
        }
        return r;
    }

    public static boolean getBoolOr(class_2960 file, Properties properties, String key, boolean defaultVal) throws PropertyParseException {
        String p = properties.getProperty(key);
        if (p == null) {
            return defaultVal;
        }
        if ("false".equals(p) || "true".equals(p)) {
            return "true".equals(p);
        }
        throw new InvalidPropertyException(file, key, "boolean (false/true)");
    }

    public static Map<Integer, Integer> intToIntMap(Properties in) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String k : in.stringPropertyNames()) {
            try {
                builder.put((Object)Integer.parseInt(k), (Object)Integer.parseInt(in.getProperty(k)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return builder.build();
    }

    private static /* synthetic */ PropertyUtil[] $values() {
        return new PropertyUtil[0];
    }

    static {
        $VALUES = PropertyUtil.$values();
    }
}

