/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.animatica.config;

import io.github.foundationgames.animatica.Animatica;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_7172;

public class AnimaticaConfig {
    public boolean animatedTextures;
    public Integer maxAnimFrames;
    public boolean safeMode;
    public static String ANIMATED_TEXTURES_KEY = "animated_textures";
    public static String MAX_ANIM_FRAMES_KEY = "max_animation_frames";
    public static String SAFE_MODE_KEY = "safe_mode";
    public static final String FILE_NAME = "animatica.properties";
    public static final String[] COMMENTS = new String[]{"Configuration file for Animatica", "animated_textures=<true|false> - Determines whether custom texture animation support should be enabled or not", "max_animation_frames=<integer value, or 'none'> - Maximum unique animation frames a texture can have, to prevent high RAM/VRAM usage (disabled when set to 'none')", "safe_mode=<true|false> - When enabled, doesn't generate animations, however provides important debug information"};
    private final class_7172<Boolean> option;

    public AnimaticaConfig() {
        try {
            this.load();
        }
        catch (IOException e) {
            Animatica.LOG.error("Error loading config during initialization!", (Throwable)e);
        }
        this.option = class_7172.method_41751((String)"option.animatica.animated_textures", (boolean)this.animatedTextures, value -> {
            this.animatedTextures = value;
            try {
                this.save();
            }
            catch (IOException e) {
                Animatica.LOG.error("Error saving config while changing in game!", (Throwable)e);
            }
            class_310.method_1551().method_1521();
        });
    }

    public void writeTo(Properties properties) {
        properties.put(ANIMATED_TEXTURES_KEY, Boolean.toString(this.animatedTextures));
        properties.put(MAX_ANIM_FRAMES_KEY, this.maxAnimFrames == null ? "none" : this.maxAnimFrames.toString());
        properties.put(SAFE_MODE_KEY, Boolean.toString(this.safeMode));
    }

    public void readFrom(Properties properties) {
        this.animatedTextures = AnimaticaConfig.boolFrom(properties.getProperty(ANIMATED_TEXTURES_KEY), true);
        this.maxAnimFrames = AnimaticaConfig.nullableIntFrom(properties.getProperty(MAX_ANIM_FRAMES_KEY), 7000);
        this.safeMode = AnimaticaConfig.boolFrom(properties.getProperty(SAFE_MODE_KEY), false);
    }

    public Path getFile() throws IOException {
        Path file = FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
        }
        return file;
    }

    public class_7172<Boolean> getOption() {
        return this.option;
    }

    public void save() throws IOException {
        Path file = this.getFile();
        Properties ppt = new Properties();
        this.writeTo(ppt);
        try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
            ppt.store(os, String.join((CharSequence)"\n", COMMENTS));
        }
    }

    public void load() throws IOException {
        Path file = this.getFile();
        Properties ppt = new Properties();
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            ppt.load(is);
        }
        this.readFrom(ppt);
    }

    private static boolean boolFrom(String s, boolean defaultVal) {
        return s == null ? defaultVal : "true".equals(s);
    }

    private static Integer nullableIntFrom(String s, Integer defaultVal) {
        try {
            return s == null ? defaultVal : (s.equals("none") ? null : Integer.valueOf(Integer.parseInt(s)));
        }
        catch (NumberFormatException ex) {
            Animatica.LOG.error("Value {} must be an integer, or 'none'", (Object)s);
            return defaultVal;
        }
    }
}

