/*
 * Decompiled with CFR 0.152.
 */
package xyz.holocons.mc.holdthatchunk;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import xyz.holocons.mc.holdthatchunk.HoldThatChunkMod;

public class Configuration {
    private static final Path configPath = FabricLoader.getInstance().getConfigDir().normalize().resolve("holdthatchunk.json");
    private static final Gson gson = new Gson();
    public int chunkUnloadDistance = 64;
    public boolean ignoreServerRenderDistance = false;

    public void deserialize(JsonObject jsonObject) {
        if (jsonObject == null) {
            HoldThatChunkMod.LOGGER.warn("[{}] Config was empty", (Object)"holdthatchunk");
        } else {
            try {
                this.chunkUnloadDistance = jsonObject.get("chunkUnloadDistance").getAsInt();
            }
            catch (Exception e) {
                HoldThatChunkMod.LOGGER.warn("[{}] Could not parse chunkUnloadDistance option", (Object)"holdthatchunk");
            }
            try {
                this.ignoreServerRenderDistance = jsonObject.get("ignoreServerRenderDistance").getAsBoolean();
            }
            catch (Exception e) {
                HoldThatChunkMod.LOGGER.warn("[{}] Could not parse ignoreServerRenderDistance option", (Object)"holdthatchunk");
            }
        }
    }

    public JsonObject serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("chunkUnloadDistance", (Number)this.chunkUnloadDistance);
        jsonObject.addProperty("ignoreServerRenderDistance", Boolean.valueOf(this.ignoreServerRenderDistance));
        return jsonObject;
    }

    public void load() {
        File configFile = configPath.toFile();
        if (!configFile.exists()) {
            this.save();
        } else {
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                this.deserialize((JsonObject)gson.fromJson((Reader)reader, JsonObject.class));
            }
            catch (Exception e) {
                HoldThatChunkMod.LOGGER.error("[{}] Could not read config", (Object)"holdthatchunk", (Object)e);
            }
        }
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            gson.toJson((Object)this.serialize(), JsonObject.class, (Appendable)writer);
        }
        catch (Exception e) {
            HoldThatChunkMod.LOGGER.error("[{}] Could not write config", (Object)"holdthatchunk", (Object)e);
        }
    }
}

