/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.placement;

import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_6328;

@class_6328
public interface IPlacementHelper {
    public static final class_2680 ID = new class_2680(class_2246.field_10124, null, null);

    public Predicate<class_1799> getItemPredicate();

    public Predicate<class_2680> getStatePredicate();

    public PlacementOffset getOffset(class_1657 var1, class_1937 var2, class_2680 var3, class_2338 var4, class_3965 var5);

    default public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray, class_1799 heldItem) {
        PlacementOffset offset = this.getOffset(player, world, state, pos, ray);
        if (heldItem.method_7909() instanceof class_1747) {
            class_1747 blockItem = (class_1747)heldItem.method_7909();
            offset = offset.withGhostState(blockItem.method_7711().method_9564());
        }
        return offset;
    }

    default public void renderAt(class_2338 pos, class_2680 state, class_3965 ray, PlacementOffset offset) {
        this.displayGhost(offset);
    }

    public static void renderArrow(class_243 center, class_243 target, class_2350 arrowPlane) {
        IPlacementHelper.renderArrow(center, target, arrowPlane, 1.0);
    }

    public static void renderArrow(class_243 center, class_243 target, class_2350 arrowPlane, double distanceFromCenter) {
        class_243 direction = target.method_1020(center).method_1029();
        class_243 facing = class_243.method_24954((class_2382)arrowPlane.method_10163());
        class_243 start = center.method_1019(direction);
        class_243 offset = direction.method_1021(distanceFromCenter - 1.0);
        class_243 offsetA = direction.method_1036(facing).method_1029().method_1021(0.25);
        class_243 offsetB = facing.method_1036(direction).method_1029().method_1021(0.25);
        class_243 endA = center.method_1019(direction.method_1021(0.75)).method_1019(offsetA);
        class_243 endB = center.method_1019(direction.method_1021(0.75)).method_1019(offsetB);
        CreateClient.OUTLINER.showLine("placementArrowA" + center + target, start.method_1019(offset), endA.method_1019(offset)).lineWidth(0.0625f);
        CreateClient.OUTLINER.showLine("placementArrowB" + center + target, start.method_1019(offset), endB.method_1019(offset)).lineWidth(0.0625f);
    }

    default public void displayGhost(PlacementOffset offset) {
        if (!offset.hasGhostState()) {
            return;
        }
        CreateClient.GHOST_BLOCKS.showGhostState(this, offset.getTransform().apply(offset.getGhostState())).at(offset.getBlockPos()).breathingAlpha();
    }

    public static List<class_2350> orderedByDistanceOnlyAxis(class_2338 pos, class_243 hit, class_2350.class_2351 axis) {
        return IPlacementHelper.orderedByDistance(pos, hit, (class_2350 dir) -> dir.method_10166() == axis);
    }

    public static List<class_2350> orderedByDistanceOnlyAxis(class_2338 pos, class_243 hit, class_2350.class_2351 axis, Predicate<class_2350> includeDirection) {
        return IPlacementHelper.orderedByDistance(pos, hit, ((Predicate<class_2350>)dir -> dir.method_10166() == axis).and(includeDirection));
    }

    public static List<class_2350> orderedByDistanceExceptAxis(class_2338 pos, class_243 hit, class_2350.class_2351 axis) {
        return IPlacementHelper.orderedByDistance(pos, hit, (class_2350 dir) -> dir.method_10166() != axis);
    }

    public static List<class_2350> orderedByDistanceExceptAxis(class_2338 pos, class_243 hit, class_2350.class_2351 axis, Predicate<class_2350> includeDirection) {
        return IPlacementHelper.orderedByDistance(pos, hit, ((Predicate<class_2350>)dir -> dir.method_10166() != axis).and(includeDirection));
    }

    public static List<class_2350> orderedByDistanceExceptAxis(class_2338 pos, class_243 hit, class_2350.class_2351 first, class_2350.class_2351 second) {
        return IPlacementHelper.orderedByDistanceExceptAxis(pos, hit, first, (class_2350 d) -> d.method_10166() != second);
    }

    public static List<class_2350> orderedByDistanceExceptAxis(class_2338 pos, class_243 hit, class_2350.class_2351 first, class_2350.class_2351 second, Predicate<class_2350> includeDirection) {
        return IPlacementHelper.orderedByDistanceExceptAxis(pos, hit, first, ((Predicate<class_2350>)d -> d.method_10166() != second).and(includeDirection));
    }

    public static List<class_2350> orderedByDistance(class_2338 pos, class_243 hit) {
        return IPlacementHelper.orderedByDistance(pos, hit, (class_2350 _$) -> true);
    }

    public static List<class_2350> orderedByDistance(class_2338 pos, class_243 hit, Predicate<class_2350> includeDirection) {
        class_243 centerToHit = hit.method_1020(VecHelper.getCenterOf((class_2382)pos));
        return Arrays.stream(Iterate.directions).filter(includeDirection).map(dir -> Pair.of(dir, class_243.method_24954((class_2382)dir.method_10163()).method_1022(centerToHit))).sorted(Comparator.comparingDouble(Pair::getSecond)).map(Pair::getFirst).collect(Collectors.toList());
    }

    public static List<class_2350> orderedByDistance(class_2338 pos, class_243 hit, Collection<class_2350> directions) {
        class_243 centerToHit = hit.method_1020(VecHelper.getCenterOf((class_2382)pos));
        return directions.stream().map(dir -> Pair.of(dir, class_243.method_24954((class_2382)dir.method_10163()).method_1022(centerToHit))).sorted(Comparator.comparingDouble(Pair::getSecond)).map(Pair::getFirst).toList();
    }

    default public boolean matchesItem(class_1799 item) {
        return this.getItemPredicate().test(item);
    }

    default public boolean matchesState(class_2680 state) {
        return this.getStatePredicate().test(state);
    }
}

