/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.BulkScrollValueBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.animation.PhysicalFloat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_638;

public class ScrollValueHandler {
    private static float lastPassiveScroll = 0.0f;
    private static float passiveScroll = 0.0f;
    private static float passiveScrollDirection = 1.0f;
    private static final PhysicalFloat wrenchCog = PhysicalFloat.create().withDrag(0.3);

    @Environment(value=EnvType.CLIENT)
    public static boolean onScroll(double delta) {
        class_310 mc = class_310.method_1551();
        class_239 objectMouseOver = mc.field_1765;
        if (!(objectMouseOver instanceof class_3965)) {
            return false;
        }
        class_638 world = mc.field_1687;
        class_3965 result = (class_3965)objectMouseOver;
        class_2338 blockPos = result.method_17777();
        ScrollValueBehaviour scrolling = TileEntityBehaviour.get((class_1922)world, blockPos, ScrollValueBehaviour.TYPE);
        if (scrolling == null) {
            return false;
        }
        if (!scrolling.canInteract((class_1657)mc.field_1724)) {
            return false;
        }
        if (!scrolling.isActive()) {
            return false;
        }
        if (!mc.field_1724.method_7294()) {
            return false;
        }
        if (scrolling.needsWrench && !AllItems.WRENCH.isIn(mc.field_1724.method_6047())) {
            return false;
        }
        passiveScrollDirection = (float)(-delta);
        wrenchCog.bump(3, -delta * 10.0);
        int prev = scrolling.scrollableValue;
        if (scrolling.slotPositioning instanceof ValueBoxTransform.Sided) {
            ((ValueBoxTransform.Sided)scrolling.slotPositioning).fromSide(result.method_17780());
        }
        if (!scrolling.testHit(objectMouseOver.method_17784())) {
            return false;
        }
        if (scrolling instanceof BulkScrollValueBehaviour && AllKeys.ctrlDown()) {
            BulkScrollValueBehaviour bulkScrolling = (BulkScrollValueBehaviour)scrolling;
            for (SmartTileEntity smartTileEntity : bulkScrolling.getBulk()) {
                ScrollValueBehaviour other = smartTileEntity.getBehaviour(ScrollValueBehaviour.TYPE);
                if (other == null) continue;
                ScrollValueHandler.applyTo(delta, other);
            }
        } else {
            ScrollValueHandler.applyTo(delta, scrolling);
        }
        if (prev != scrolling.scrollableValue) {
            float pitch = (float)(scrolling.scrollableValue - scrolling.min) / (float)(scrolling.max - scrolling.min);
            pitch = class_3532.method_16439((float)pitch, (float)1.5f, (float)2.0f);
            AllSoundEvents.SCROLL_VALUE.play((class_1937)world, (class_1657)mc.field_1724, (class_2382)blockPos, 1.0f, pitch);
        }
        return true;
    }

    public static float getScroll(float partialTicks) {
        return wrenchCog.getValue(partialTicks) + class_3532.method_16439((float)partialTicks, (float)lastPassiveScroll, (float)passiveScroll);
    }

    @Environment(value=EnvType.CLIENT)
    public static void tick() {
        if (!class_310.method_1551().method_1493()) {
            lastPassiveScroll = passiveScroll;
            wrenchCog.tick();
            passiveScroll = (float)((double)passiveScroll + (double)passiveScrollDirection * 0.5);
        }
    }

    protected static void applyTo(double delta, ScrollValueBehaviour scrolling) {
        scrolling.ticksUntilScrollPacket = 10;
        int valueBefore = scrolling.scrollableValue;
        ScrollValueBehaviour.StepContext context = new ScrollValueBehaviour.StepContext();
        context.control = AllKeys.ctrlDown();
        context.shift = AllKeys.shiftDown();
        context.currentValue = scrolling.scrollableValue;
        context.forward = delta > 0.0;
        double newValue = (double)scrolling.scrollableValue + Math.signum(delta) * (double)scrolling.step.apply(context).intValue();
        scrolling.scrollableValue = (int)class_3532.method_15350((double)newValue, (double)scrolling.min, (double)scrolling.max);
        if (valueBefore != scrolling.scrollableValue) {
            scrolling.clientCallback.accept(scrolling.scrollableValue);
        }
    }
}

