/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.inventory;

import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import io.github.fabricators_of_create.porting_lib.util.StorageProvider;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;

public abstract class CapManipulationBehaviourBase<T, S extends CapManipulationBehaviourBase<?, ?>>
extends TileEntityBehaviour {
    protected InterfaceProvider target;
    private StorageProvider<T> targetStorageProvider;
    protected boolean simulateNext;
    protected boolean bypassSided;
    protected class_2350 side;

    public CapManipulationBehaviourBase(SmartTileEntity te, InterfaceProvider target) {
        super(te);
        this.setLazyTickRate(5);
        this.target = target;
        this.targetStorageProvider = null;
        this.simulateNext = false;
        this.bypassSided = false;
    }

    protected abstract StorageProvider<T> getProvider(class_2338 var1, boolean var2);

    public S bypassSidedness() {
        this.bypassSided = true;
        return (S)this;
    }

    public S simulate() {
        this.simulateNext = true;
        return (S)this;
    }

    public boolean hasInventory() {
        return this.getInventory() != null;
    }

    @Nullable
    public Storage<T> getInventory() {
        if (this.targetStorageProvider == null || this.side == null) {
            return null;
        }
        return this.targetStorageProvider.get(this.side);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.targetStorageProvider == null) {
            BlockFace targetBlockFace = this.target.getTarget(this.getWorld(), this.tileEntity.method_11016(), this.tileEntity.method_11010()).getOpposite();
            class_2338 pos = targetBlockFace.getPos();
            this.targetStorageProvider = this.getProvider(pos, this.bypassSided);
            this.side = targetBlockFace.getFace();
        }
    }

    public int getAmountFromFilter() {
        int amount = -1;
        FilteringBehaviour filter = this.tileEntity.getBehaviour(FilteringBehaviour.TYPE);
        if (filter != null && !filter.anyAmount()) {
            amount = filter.getAmount();
        }
        return amount;
    }

    @FunctionalInterface
    public static interface InterfaceProvider {
        public static InterfaceProvider towardBlockFacing() {
            return (w, p, s) -> new BlockFace(p, s.method_28498((class_2769)class_2741.field_12525) ? (class_2350)s.method_11654((class_2769)class_2741.field_12525) : (class_2350)s.method_11654((class_2769)class_2741.field_12481));
        }

        public static InterfaceProvider oppositeOfBlockFacing() {
            return (w, p, s) -> new BlockFace(p, (s.method_28498((class_2769)class_2741.field_12525) ? (class_2350)s.method_11654((class_2769)class_2741.field_12525) : (class_2350)s.method_11654((class_2769)class_2741.field_12481)).method_10153());
        }

        public BlockFace getTarget(class_1937 var1, class_2338 var2, class_2680 var3);
    }

    public static abstract class UnsidedStorageProvider<T>
    extends StorageProvider<T> {
        protected UnsidedStorageProvider(BlockApiLookup<Storage<T>, class_2350> lookup, class_1937 level, class_2338 pos) {
            super(lookup, level, pos);
        }

        @Nullable
        public Storage<T> get(class_2350 direction) {
            return this.get();
        }

        @Nullable
        public abstract Storage<T> get();
    }
}

