/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity;

import com.simibubi.create.api.event.TileEntityBehaviourEvent;
import com.simibubi.create.content.schematics.ISpecialBlockEntityItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.tileEntity.CachedRenderBBTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.utility.IInteractionChecker;
import com.simibubi.create.foundation.utility.IPartialSafeNBT;
import io.github.fabricators_of_create.porting_lib.block.ChunkUnloadListeningBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public abstract class SmartTileEntity
extends CachedRenderBBTileEntity
implements IPartialSafeNBT,
IInteractionChecker,
ChunkUnloadListeningBlockEntity,
ISpecialBlockEntityItemRequirement {
    private final Map<BehaviourType<?>, TileEntityBehaviour> behaviours = new HashMap();
    private boolean initialized = false;
    private boolean firstNbtRead = true;
    protected int lazyTickRate;
    protected int lazyTickCounter;
    private boolean chunkUnloaded;
    private boolean virtualMode;

    public SmartTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        ArrayList<TileEntityBehaviour> list = new ArrayList<TileEntityBehaviour>();
        this.addBehaviours(list);
        list.forEach(b -> this.behaviours.put(b.getType(), (TileEntityBehaviour)b));
    }

    public abstract void addBehaviours(List<TileEntityBehaviour> var1);

    public void addBehavioursDeferred(List<TileEntityBehaviour> behaviours) {
    }

    public void initialize() {
        if (this.firstNbtRead) {
            this.firstNbtRead = false;
            ((TileEntityBehaviourEvent.TileEntityBehaviorCallback)TileEntityBehaviourEvent.EVENT.invoker()).onDeserialize(new TileEntityBehaviourEvent<SmartTileEntity>(this.method_11010(), this, this.behaviours));
        }
        this.forEachBehaviour(TileEntityBehaviour::initialize);
        this.lazyTick();
    }

    public void tick() {
        if (!this.initialized && this.method_11002()) {
            this.initialize();
            this.initialized = true;
        }
        if (this.lazyTickCounter-- <= 0) {
            this.lazyTickCounter = this.lazyTickRate;
            this.lazyTick();
        }
        this.forEachBehaviour(TileEntityBehaviour::tick);
    }

    public void lazyTick() {
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.method_11007(tag);
        this.forEachBehaviour(tb -> tb.write(tag, clientPacket));
    }

    @Override
    public void writeSafe(class_2487 tag) {
        super.method_11007(tag);
        this.forEachBehaviour(tb -> {
            if (tb.isSafeNBT()) {
                tb.write(tag, false);
            }
        });
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        if (this.firstNbtRead) {
            this.firstNbtRead = false;
            ArrayList<TileEntityBehaviour> list = new ArrayList<TileEntityBehaviour>();
            this.addBehavioursDeferred(list);
            list.forEach(b -> this.behaviours.put(b.getType(), (TileEntityBehaviour)b));
            ((TileEntityBehaviourEvent.TileEntityBehaviorCallback)TileEntityBehaviourEvent.EVENT.invoker()).onDeserialize(new TileEntityBehaviourEvent<SmartTileEntity>(this.method_11010(), this, this.behaviours));
        }
        super.method_11014(tag);
        this.forEachBehaviour(tb -> tb.read(tag, clientPacket));
    }

    public final void method_11014(class_2487 tag) {
        this.read(tag, false);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.chunkUnloaded = true;
    }

    public final void method_11012() {
        super.method_11012();
        if (!this.chunkUnloaded) {
            this.remove();
        }
        this.invalidate();
    }

    public void invalidate() {
        this.forEachBehaviour(TileEntityBehaviour::unload);
    }

    public void remove() {
    }

    public void destroy() {
        this.forEachBehaviour(TileEntityBehaviour::destroy);
    }

    public final void method_11007(class_2487 tag) {
        this.write(tag, false);
    }

    @Override
    public final void readClient(class_2487 tag) {
        this.read(tag, true);
    }

    @Override
    public final class_2487 writeClient(class_2487 tag) {
        this.write(tag, true);
        return tag;
    }

    public <T extends TileEntityBehaviour> T getBehaviour(BehaviourType<T> type) {
        return (T)this.behaviours.get(type);
    }

    protected void forEachBehaviour(Consumer<TileEntityBehaviour> action) {
        this.behaviours.values().forEach(action);
    }

    protected void attachBehaviourLate(TileEntityBehaviour behaviour) {
        this.behaviours.put(behaviour.getType(), behaviour);
        behaviour.initialize();
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state) {
        return this.behaviours.values().stream().reduce(ItemRequirement.NONE, (r, b) -> r.union(b.getRequiredItems()), (r, r1) -> r.union((ItemRequirement)r1));
    }

    protected void removeBehaviour(BehaviourType<?> type) {
        TileEntityBehaviour remove = this.behaviours.remove(type);
        if (remove != null) {
            remove.unload();
        }
    }

    public void setLazyTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    public void markVirtual() {
        this.virtualMode = true;
    }

    public boolean isVirtual() {
        return this.virtualMode;
    }

    public boolean isChunkUnloaded() {
        return this.chunkUnloaded;
    }

    @Override
    public boolean canPlayerUse(class_1657 player) {
        if (this.field_11863 == null || this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void sendToContainer(class_2540 buffer) {
        buffer.method_10807(this.method_11016());
        buffer.method_10794(this.method_16887());
    }

    public void refreshBlockState() {
        this.method_31664(this.method_10997().method_8320(this.method_11016()));
    }

    public void registerAwardables(List<TileEntityBehaviour> behaviours, CreateAdvancement ... advancements) {
        for (TileEntityBehaviour behaviour : behaviours) {
            if (!(behaviour instanceof AdvancementBehaviour)) continue;
            AdvancementBehaviour ab = (AdvancementBehaviour)behaviour;
            ab.add(advancements);
            return;
        }
        behaviours.add(new AdvancementBehaviour(this, advancements));
    }

    public void award(CreateAdvancement advancement) {
        AdvancementBehaviour behaviour = this.getBehaviour(AdvancementBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.awardPlayer(advancement);
        }
    }

    public void awardIfNear(CreateAdvancement advancement, int range) {
        AdvancementBehaviour behaviour = this.getBehaviour(AdvancementBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.awardPlayerIfNear(advancement, range);
        }
    }
}

