/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.instruction;

import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.IBearingTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyTileEntity;
import com.simibubi.create.content.logistics.trains.track.StandardBogeyTileEntity;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.instruction.TickingInstruction;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2586;

public class AnimateTileEntityInstruction
extends TickingInstruction {
    protected double deltaPerTick;
    protected double totalDelta;
    protected double target;
    protected final class_2338 location;
    private BiConsumer<PonderWorld, Float> setter;
    private Function<PonderWorld, Float> getter;

    public static AnimateTileEntityInstruction bearing(class_2338 location, float totalDelta, int ticks) {
        return new AnimateTileEntityInstruction(location, totalDelta, ticks, (w, f) -> AnimateTileEntityInstruction.castIfPresent(w, location, IBearingTileEntity.class).ifPresent(bte -> bte.setAngle(f.floatValue())), w -> AnimateTileEntityInstruction.castIfPresent(w, location, IBearingTileEntity.class).map(bte -> Float.valueOf(bte.getInterpolatedAngle(0.0f))).orElse(Float.valueOf(0.0f)));
    }

    public static AnimateTileEntityInstruction bogey(class_2338 location, float totalDelta, int ticks) {
        float movedPerTick = totalDelta / (float)ticks;
        return new AnimateTileEntityInstruction(location, totalDelta, ticks, (w, f) -> AnimateTileEntityInstruction.castIfPresent(w, location, StandardBogeyTileEntity.class).ifPresent(bte -> bte.animate(f.equals(Float.valueOf(totalDelta)) ? 0.0f : movedPerTick)), w -> Float.valueOf(0.0f));
    }

    public static AnimateTileEntityInstruction pulley(class_2338 location, float totalDelta, int ticks) {
        return new AnimateTileEntityInstruction(location, totalDelta, ticks, (w, f) -> AnimateTileEntityInstruction.castIfPresent(w, location, PulleyTileEntity.class).ifPresent(pulley -> pulley.animateOffset(f.floatValue())), w -> AnimateTileEntityInstruction.castIfPresent(w, location, PulleyTileEntity.class).map(pulley -> Float.valueOf(pulley.offset)).orElse(Float.valueOf(0.0f)));
    }

    public static AnimateTileEntityInstruction deployer(class_2338 location, float totalDelta, int ticks) {
        return new AnimateTileEntityInstruction(location, totalDelta, ticks, (w, f) -> AnimateTileEntityInstruction.castIfPresent(w, location, DeployerTileEntity.class).ifPresent(deployer -> deployer.setAnimatedOffset(f.floatValue())), w -> AnimateTileEntityInstruction.castIfPresent(w, location, DeployerTileEntity.class).map(deployer -> Float.valueOf(deployer.getHandOffset(1.0f))).orElse(Float.valueOf(0.0f)));
    }

    protected AnimateTileEntityInstruction(class_2338 location, float totalDelta, int ticks, BiConsumer<PonderWorld, Float> setter, Function<PonderWorld, Float> getter) {
        super(false, ticks);
        this.location = location;
        this.setter = setter;
        this.getter = getter;
        this.deltaPerTick = (double)totalDelta * (1.0 / (double)ticks);
        this.totalDelta = totalDelta;
        this.target = totalDelta;
    }

    @Override
    protected final void firstTick(PonderScene scene) {
        super.firstTick(scene);
        this.target = (double)this.getter.apply(scene.getWorld()).floatValue() + this.totalDelta;
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        PonderWorld world = scene.getWorld();
        float current = this.getter.apply(world).floatValue();
        float next = (float)(this.remainingTicks == 0 ? this.target : (double)current + this.deltaPerTick);
        this.setter.accept(world, Float.valueOf(next));
        if (this.remainingTicks == 0) {
            this.setter.accept(world, Float.valueOf(next));
        }
    }

    private static <T> Optional<T> castIfPresent(PonderWorld world, class_2338 pos, Class<T> teType) {
        class_2586 tileEntity = world.method_8321(pos);
        if (teType.isInstance(tileEntity)) {
            return Optional.of(teType.cast(tileEntity));
        }
        return Optional.empty();
    }
}

