/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.particle.RotationIndicatorParticleData;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.content.PonderIndex;
import com.simibubi.create.foundation.ponder.element.BeltItemElement;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.element.ParrotElement;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.ponder.instruction.EmitParticlesInstruction;
import com.simibubi.create.foundation.utility.Pointing;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;

public class DebugScenes {
    private static int index;

    public static void registerAll() {
        index = 1;
        DebugScenes.add(DebugScenes::coordinateScene);
        DebugScenes.add(DebugScenes::blocksScene);
        DebugScenes.add(DebugScenes::fluidsScene);
        DebugScenes.add(DebugScenes::offScreenScene);
        DebugScenes.add(DebugScenes::particleScene);
        DebugScenes.add(DebugScenes::controlsScene);
        DebugScenes.add(DebugScenes::birbScene);
        DebugScenes.add(DebugScenes::sectionsScene);
        DebugScenes.add(DebugScenes::itemScene);
        DebugScenes.add(DebugScenes::pipeScene);
    }

    private static void add(PonderStoryBoardEntry.PonderStoryBoard sb) {
        ItemEntry<class_1792> item = AllItems.BRASS_HAND;
        String schematicPath = "debug/scene_" + index;
        PonderIndex.HELPER.addStoryBoard((ItemProviderEntry<?>)item, schematicPath, sb, new PonderTag[0]).highlightAllTags().chapter(PonderIndex.HELPER.getOrCreateChapter("debug"));
        ++index;
    }

    public static void empty(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_empty", "Missing Content");
        scene.showBasePlate();
        scene.idle(5);
    }

    public static void coordinateScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_coords", "Coordinate Space");
        scene.showBasePlate();
        scene.idle(10);
        scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
        Selection xAxis = util.select.fromTo(2, 1, 1, 4, 1, 1);
        Selection yAxis = util.select.fromTo(1, 2, 1, 1, 4, 1);
        Selection zAxis = util.select.fromTo(1, 1, 2, 1, 1, 4);
        scene.idle(10);
        scene.overlay.showSelectionWithText(xAxis, 20).colored(PonderPalette.RED).text("Das X axis");
        scene.idle(20);
        scene.overlay.showSelectionWithText(yAxis, 20).colored(PonderPalette.GREEN).text("Das Y axis");
        scene.idle(20);
        scene.overlay.showSelectionWithText(zAxis, 20).colored(PonderPalette.BLUE).text("Das Z axis");
    }

    public static void blocksScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_blocks", "Changing Blocks");
        scene.showBasePlate();
        scene.idle(10);
        scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
        scene.idle(10);
        scene.overlay.showText(1000).independent(10).text("Blocks can be modified");
        scene.idle(20);
        scene.world.replaceBlocks(util.select.fromTo(1, 1, 3, 2, 2, 4), AllBlocks.REFINED_RADIANCE_CASING.getDefaultState(), true);
        scene.idle(10);
        scene.world.replaceBlocks(util.select.position(3, 1, 1), class_2246.field_10205.method_9564(), true);
        scene.rotateCameraY(180.0f);
        scene.markAsFinished();
    }

    public static void fluidsScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_fluids", "Showing Fluids");
        scene.showBasePlate();
        scene.idle(10);
        class_243 parrotPos = util.vector.topOf(1, 0, 1);
        scene.special.createBirb(parrotPos, ParrotElement.FacePointOfInterestPose::new);
        scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
        scene.overlay.showText(1000).text("Fluid rendering test.").pointAt(new class_243(1.0, 2.5, 4.5));
        scene.markAsFinished();
        Object outlineSlot = new Object();
        class_243 vec1 = util.vector.topOf(1, 0, 0);
        class_243 vec2 = util.vector.topOf(0, 0, 1);
        class_238 boundingBox1 = new class_238(vec1, vec1).method_1012(0.0, 2.5, 0.0).method_1009(0.15, 0.0, 0.15);
        class_238 boundingBox2 = new class_238(vec2, vec2).method_1012(0.0, 0.125, 0.0).method_1009(0.45, 0.0, 0.45);
        class_243 poi1 = boundingBox1.method_1005();
        class_243 poi2 = boundingBox2.method_1005();
        for (int i = 0; i < 10; ++i) {
            scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, outlineSlot, i % 2 == 0 ? boundingBox1 : boundingBox2, 15);
            scene.idle(3);
            scene.special.movePointOfInterest(i % 2 == 0 ? poi1 : poi2);
            scene.idle(12);
        }
        scene.idle(12);
        scene.special.movePointOfInterest(util.grid.at(-4, 5, 4));
        scene.overlay.showText(40).colored(PonderPalette.RED).text("wut?").pointAt(parrotPos.method_1031(-0.25, 0.25, 0.25));
    }

    public static void offScreenScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_baseplate", "Out of bounds / configureBasePlate");
        scene.configureBasePlate(1, 0, 6);
        scene.showBasePlate();
        Selection out1 = util.select.fromTo(7, 0, 0, 8, 0, 5);
        Selection out2 = util.select.fromTo(0, 0, 0, 0, 0, 5);
        Selection blocksExceptBasePlate = util.select.layersFrom(1).add(out1).add(out2);
        scene.idle(10);
        scene.world.showSection(blocksExceptBasePlate, class_2350.field_11033);
        scene.idle(10);
        scene.overlay.showSelectionWithText(out1, 100).colored(PonderPalette.BLACK).text("Blocks outside of the base plate do not affect scaling");
        scene.overlay.showSelectionWithText(out2, 100).colored(PonderPalette.BLACK).text("configureBasePlate() makes sure of that.");
        scene.markAsFinished();
    }

    public static void particleScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_particles", "Emitting particles");
        scene.showBasePlate();
        scene.idle(10);
        scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
        scene.idle(10);
        class_243 emitterPos = util.vector.of(2.5, 2.25, 2.5);
        EmitParticlesInstruction.Emitter emitter = EmitParticlesInstruction.Emitter.simple(class_2398.field_11239, util.vector.of(0.0, 0.1, 0.0));
        EmitParticlesInstruction.Emitter rotation = EmitParticlesInstruction.Emitter.simple(new RotationIndicatorParticleData(IRotate.SpeedLevel.MEDIUM.getColor(), 12.0f, 1.0f, 1.0f, 20, 'Y'), util.vector.of(0.0, 0.1, 0.0));
        scene.overlay.showText(20).text("Incoming...").pointAt(emitterPos);
        scene.idle(30);
        scene.effects.emitParticles(emitterPos, emitter, 1.0f, 60);
        scene.effects.emitParticles(emitterPos, rotation, 20.0f, 1);
        scene.idle(30);
        scene.rotateCameraY(180.0f);
    }

    public static void controlsScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_controls", "Basic player interaction");
        scene.showBasePlate();
        scene.idle(10);
        scene.world.showSection(util.select.layer(1), class_2350.field_11033);
        scene.idle(4);
        scene.world.showSection(util.select.layer(2), class_2350.field_11033);
        scene.idle(4);
        scene.world.showSection(util.select.layer(3), class_2350.field_11033);
        scene.idle(10);
        class_2338 shaftPos = util.grid.at(3, 1, 1);
        Selection shaftSelection = util.select.position(shaftPos);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(shaftPos), Pointing.DOWN).rightClick().whileSneaking().withWrench(), 40);
        scene.idle(20);
        scene.world.replaceBlocks(shaftSelection, AllBlocks.SHAFT.getDefaultState(), true);
        scene.idle(20);
        scene.world.hideSection(shaftSelection, class_2350.field_11036);
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(util.vector.of(1.0, 4.5, 3.5), Pointing.LEFT).rightClick().withItem(new class_1799((class_1935)class_2246.field_10093)), 20);
        scene.world.showSection(util.select.layer(4), class_2350.field_11033);
        scene.idle(40);
        class_2338 chassis = util.grid.at(1, 1, 3);
        class_243 chassisSurface = util.vector.blockSurface(chassis, class_2350.field_11043);
        Object chassisValueBoxHighlight = new Object();
        Object chassisEffectHighlight = new Object();
        class_238 point = new class_238(chassisSurface, chassisSurface);
        class_238 expanded = point.method_1009(0.25, 0.25, 0.0625);
        Selection singleBlock = util.select.position(1, 2, 3);
        Selection twoBlocks = util.select.fromTo(1, 2, 3, 1, 3, 3);
        Selection threeBlocks = util.select.fromTo(1, 2, 3, 1, 4, 3);
        Selection singleRow = util.select.fromTo(1, 2, 3, 3, 2, 3);
        Selection twoRows = util.select.fromTo(1, 2, 3, 3, 3, 3);
        Selection threeRows = twoRows.copy().add(threeBlocks);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, chassisValueBoxHighlight, point, 1);
        scene.idle(1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, chassisValueBoxHighlight, expanded, 120);
        scene.overlay.showControls(new InputWindowElement(chassisSurface, Pointing.UP).scroll().withWrench(), 40);
        PonderPalette white = PonderPalette.WHITE;
        scene.overlay.showOutline(white, chassisEffectHighlight, singleBlock, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, twoBlocks, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, threeBlocks, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, twoBlocks, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, singleBlock, 10);
        scene.idle(10);
        scene.idle(30);
        scene.overlay.showControls(new InputWindowElement(chassisSurface, Pointing.UP).whileCTRL().scroll().withWrench(), 40);
        scene.overlay.showOutline(white, chassisEffectHighlight, singleRow, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, twoRows, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, threeRows, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, twoRows, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, singleRow, 10);
        scene.idle(10);
        scene.markAsFinished();
    }

    public static void birbScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_birbs", "Birbs");
        scene.showBasePlate();
        scene.idle(10);
        scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
        scene.idle(10);
        class_2338 pos = new class_2338(1, 2, 3);
        scene.special.birbOnSpinnyShaft(pos);
        scene.overlay.showText(100).colored(PonderPalette.GREEN).text("More birbs = More interesting").pointAt(util.vector.topOf(pos));
        scene.idle(10);
        scene.special.createBirb(util.vector.topOf(0, 1, 2), ParrotElement.DancePose::new);
        scene.idle(10);
        scene.special.createBirb(util.vector.centerOf(3, 1, 3).method_1031(0.0, 0.25, 0.0), ParrotElement.FacePointOfInterestPose::new);
        scene.idle(20);
        class_2338 poi1 = util.grid.at(4, 1, 0);
        class_2338 poi2 = util.grid.at(0, 1, 4);
        scene.world.setBlock(poi1, class_2246.field_10205.method_9564(), true);
        scene.special.movePointOfInterest(poi1);
        scene.idle(20);
        scene.world.setBlock(poi2, class_2246.field_10205.method_9564(), true);
        scene.special.movePointOfInterest(poi2);
        scene.overlay.showText(20).text("Point of Interest").pointAt(util.vector.centerOf(poi2));
        scene.idle(20);
        scene.world.destroyBlock(poi1);
        scene.special.movePointOfInterest(poi1);
        scene.idle(20);
        scene.world.destroyBlock(poi2);
        scene.special.movePointOfInterest(poi2);
    }

    public static void sectionsScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_sections", "Sections");
        scene.showBasePlate();
        scene.idle(10);
        scene.rotateCameraY(95.0f);
        class_2338 mergePos = util.grid.at(1, 1, 1);
        class_2338 independentPos = util.grid.at(3, 1, 1);
        Selection toMerge = util.select.position(mergePos);
        Selection independent = util.select.position(independentPos);
        Selection start = util.select.layersFrom(1).substract(toMerge).substract(independent);
        scene.world.showSection(start, class_2350.field_11033);
        scene.idle(20);
        scene.world.showSection(toMerge, class_2350.field_11033);
        ElementLink<WorldSectionElement> link = scene.world.showIndependentSection(independent, class_2350.field_11033);
        scene.idle(20);
        scene.overlay.showText(40).colored(PonderPalette.GREEN).text("This Section got merged to base.").pointAt(util.vector.topOf(mergePos));
        scene.idle(10);
        scene.overlay.showText(40).colored(PonderPalette.RED).text("This Section renders independently.").pointAt(util.vector.topOf(independentPos));
        scene.idle(40);
        scene.world.hideIndependentSection(link, class_2350.field_11033);
        scene.world.hideSection(util.select.fromTo(mergePos, util.grid.at(1, 1, 4)), class_2350.field_11033);
        scene.idle(20);
        Selection hiddenReplaceArea = util.select.fromTo(2, 1, 2, 4, 1, 4).substract(util.select.position(4, 1, 3)).substract(util.select.position(2, 1, 3));
        scene.world.hideSection(hiddenReplaceArea, class_2350.field_11036);
        scene.idle(20);
        scene.world.setBlocks(hiddenReplaceArea, AllBlocks.REFINED_RADIANCE_CASING.getDefaultState(), false);
        scene.world.showSection(hiddenReplaceArea, class_2350.field_11033);
        scene.idle(20);
        scene.overlay.showSelectionWithText(hiddenReplaceArea, 30).colored(PonderPalette.BLUE).text("Seamless substitution of blocks");
        scene.idle(40);
        ElementLink<WorldSectionElement> helicopter = scene.world.makeSectionIndependent(hiddenReplaceArea);
        scene.world.rotateSection(helicopter, 50.0, 1800.0, 0.0, 60);
        scene.world.moveSection(helicopter, util.vector.of(0.0, 4.0, 5.0), 50);
        scene.overlay.showText(30).colored(PonderPalette.BLUE).text("Up, up and away.").independent(30);
        scene.idle(40);
        scene.world.hideIndependentSection(helicopter, class_2350.field_11036);
    }

    public static void itemScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_items", "Manipulating Items");
        scene.configureBasePlate(0, 0, 6);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(10);
        scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
        class_1799 brassItem = AllItems.BRASS_INGOT.asStack();
        class_1799 copperItem = new class_1799((class_1935)class_1802.field_27022);
        for (int z = 4; z >= 2; --z) {
            scene.world.createItemEntity(util.vector.centerOf(0, 4, z), class_243.field_1353, brassItem.method_7972());
            scene.idle(10);
        }
        class_2338 beltPos = util.grid.at(2, 1, 3);
        ElementLink<BeltItemElement> itemOnBelt = scene.world.createItemOnBelt(beltPos, class_2350.field_11034, copperItem.method_7972());
        scene.idle(10);
        scene.world.stallBeltItem(itemOnBelt, true);
        scene.idle(5);
        scene.overlay.showText(40).colored(PonderPalette.FAST).text("Belt Items can only be force-stalled on the belt they were created on.").pointAt(util.vector.topOf(2, 1, 2));
        scene.idle(45);
        scene.world.stallBeltItem(itemOnBelt, false);
        scene.idle(20);
        scene.world.modifyEntities(class_1542.class, entity -> {
            if (copperItem.method_7962(entity.method_6983())) {
                entity.method_5875(true);
            }
        });
        scene.idle(20);
        scene.world.modifyEntities(class_1542.class, entity -> {
            if (brassItem.method_7962(entity.method_6983())) {
                entity.method_18799(util.vector.of(-0.15f, 0.5, 0.0));
            }
        });
        scene.idle(27);
        scene.world.modifyEntities(class_1542.class, class_1297::method_31472);
    }

    public static void pipeScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_pipes", "Manipulating Items");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(10);
        scene.world.showSection(util.select.layersFrom(1), class_2350.field_11033);
    }
}

