/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.CargoThresholdCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class ItemThresholdCondition
extends CargoThresholdCondition {
    public class_1799 stack = class_1799.field_8037;

    @Override
    protected class_2561 getUnit() {
        return Components.literal(this.inStacks() ? "\u25a4" : "");
    }

    @Override
    protected class_1799 getIcon() {
        return this.stack;
    }

    @Override
    protected boolean test(class_1937 level, Train train, class_2487 context) {
        CargoThresholdCondition.Ops operator = this.getOperator();
        long target = this.getThreshold();
        boolean stacks = this.inStacks();
        int foundItems = 0;
        for (Carriage carriage : train.carriages) {
            Contraption.ContraptionInvWrapper items = carriage.storage.getItems();
            Transaction t = TransferUtil.getTransaction();
            try {
                for (StorageView view : TransferUtil.getNonEmpty((Storage)items)) {
                    ItemVariant variant = (ItemVariant)view.getResource();
                    if (!FilterItem.test(level, variant.toStack(), this.stack)) continue;
                    if (stacks) {
                        foundItems += view.getAmount() == (long)variant.getItem().method_7882() ? 1 : 0;
                        continue;
                    }
                    foundItems = (int)((long)foundItems + view.getAmount());
                }
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
        this.requestStatusToUpdate(foundItems, context);
        return operator.test(foundItems, target);
    }

    @Override
    protected void writeAdditional(class_2487 tag) {
        super.writeAdditional(tag);
        tag.method_10566("Item", (class_2520)NBTSerializer.serializeNBTCompound((Object)this.stack));
    }

    @Override
    protected void readAdditional(class_2487 tag) {
        super.readAdditional(tag);
        this.stack = class_1799.method_7915((class_2487)tag.method_10562("Item"));
    }

    @Override
    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        return super.tickCompletion(level, train, context);
    }

    @Override
    public void setItem(int slot, class_1799 stack) {
        this.stack = stack;
    }

    @Override
    public class_1799 getItem(int slot) {
        return this.stack;
    }

    @Override
    public List<class_2561> getTitleAs(String type) {
        return ImmutableList.of((Object)Lang.translateDirect("schedule.condition.threshold.train_holds", Lang.translateDirect("schedule.condition.threshold." + Lang.asId(this.getOperator().name()), new Object[0])), (Object)Lang.translateDirect("schedule.condition.threshold.x_units_of_item", this.getThreshold(), Lang.translateDirect("schedule.condition.threshold." + (this.inStacks() ? "stacks" : "items"), new Object[0]), this.stack.method_7960() ? Lang.translateDirect("schedule.condition.threshold.anything", new Object[0]) : (this.stack.method_7909() instanceof FilterItem ? Lang.translateDirect("schedule.condition.threshold.matching_content", new Object[0]) : this.stack.method_7964())).method_27692(class_124.field_1062));
    }

    private boolean inStacks() {
        return this.intData("Measure") == 1;
    }

    @Override
    public class_2960 getId() {
        return Create.asResource("item_threshold");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        super.initConfigurationWidgets(builder);
        builder.addSelectionScrollInput(71, 50, (i, l) -> i.forOptions((List<? extends class_2561>)ImmutableList.of((Object)Lang.translateDirect("schedule.condition.threshold.items", new Object[0]), (Object)Lang.translateDirect("schedule.condition.threshold.stacks", new Object[0]))).titled(Lang.translateDirect("schedule.condition.threshold.item_measure", new Object[0])), "Measure");
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        long lastDisplaySnapshot = this.getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1L) {
            return Components.empty();
        }
        int offset = this.getOperator() == CargoThresholdCondition.Ops.LESS ? -1 : (this.getOperator() == CargoThresholdCondition.Ops.GREATER ? 1 : 0);
        return Lang.translateDirect("schedule.condition.threshold.status", lastDisplaySnapshot, Math.max(0L, this.getThreshold() + (long)offset), Lang.translateDirect("schedule.condition.threshold." + (this.inStacks() ? "stacks" : "items"), new Object[0]));
    }
}

