/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1262;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2487;

public class ShulkerFillLevelAttribute
implements ItemAttribute {
    public static final ShulkerFillLevelAttribute EMPTY = new ShulkerFillLevelAttribute(null);
    private final ShulkerLevels levels;

    public ShulkerFillLevelAttribute(ShulkerLevels levels) {
        this.levels = levels;
    }

    @Override
    public boolean appliesTo(class_1799 stack) {
        return this.levels != null && this.levels.canApply(stack);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(class_1799 stack) {
        return Arrays.stream(ShulkerLevels.values()).filter(shulkerLevels -> shulkerLevels.canApply(stack)).map(ShulkerFillLevelAttribute::new).collect(Collectors.toList());
    }

    @Override
    public String getTranslationKey() {
        return "shulker_level";
    }

    @Override
    public Object[] getTranslationParameters() {
        String parameter = "";
        if (this.levels != null) {
            parameter = Lang.translateDirect("item_attributes." + this.getTranslationKey() + "." + this.levels.key, new Object[0]).getString();
        }
        return new Object[]{parameter};
    }

    @Override
    public void writeNBT(class_2487 nbt) {
        if (this.levels != null) {
            nbt.method_10582("id", this.levels.key);
        }
    }

    @Override
    public ItemAttribute readNBT(class_2487 nbt) {
        return nbt.method_10545("id") ? new ShulkerFillLevelAttribute(ShulkerLevels.fromKey(nbt.method_10558("id"))) : EMPTY;
    }

    static enum ShulkerLevels {
        EMPTY("empty", amount -> amount == 0),
        PARTIAL("partial", amount -> amount > 0 && amount < Integer.MAX_VALUE),
        FULL("full", amount -> amount == Integer.MAX_VALUE);

        private final Predicate<Integer> requiredSize;
        private final String key;

        private ShulkerLevels(String key, Predicate<Integer> requiredSize) {
            this.key = key;
            this.requiredSize = requiredSize;
        }

        @Nullable
        public static ShulkerLevels fromKey(String key) {
            return Arrays.stream(ShulkerLevels.values()).filter(shulkerLevels -> shulkerLevels.key.equals(key)).findFirst().orElse(null);
        }

        private static boolean isShulker(class_1799 stack) {
            return class_2248.method_9503((class_1792)stack.method_7909()) instanceof class_2480;
        }

        public boolean canApply(class_1799 testStack) {
            if (!ShulkerLevels.isShulker(testStack)) {
                return false;
            }
            class_2487 compoundnbt = testStack.method_7941("BlockEntityTag");
            if (compoundnbt == null) {
                return this.requiredSize.test(0);
            }
            if (compoundnbt.method_10573("LootTable", 8)) {
                return false;
            }
            if (compoundnbt.method_10573("Items", 9)) {
                int rawSize = compoundnbt.method_10554("Items", 10).size();
                if (rawSize < 27) {
                    return this.requiredSize.test(rawSize);
                }
                class_2371 inventory = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
                class_1262.method_5429((class_2487)compoundnbt, (class_2371)inventory);
                boolean isFull = inventory.stream().allMatch(itemStack -> !itemStack.method_7960() && itemStack.method_7947() == itemStack.method_7914());
                return this.requiredSize.test(isFull ? Integer.MAX_VALUE : rawSize);
            }
            return this.requiredSize.test(0);
        }
    }
}

