/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display.source;

import com.simibubi.create.content.contraptions.fluids.tank.BoilerData;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.content.logistics.block.display.DisplayLinkContext;
import com.simibubi.create.content.logistics.block.display.source.DisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTargetStats;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayLayout;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplaySection;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayTileEntity;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import joptsimple.internal.Strings;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3722;
import net.minecraft.class_5250;

public class BoilerDisplaySource
extends DisplaySource {
    public static final List<class_5250> notEnoughSpaceSingle = List.of(Lang.translateDirect("display_source.boiler.not_enough_space", new Object[0]).method_10852((class_2561)Lang.translateDirect("display_source.boiler.for_boiler_status", new Object[0])));
    public static final List<class_5250> notEnoughSpaceDouble = List.of(Lang.translateDirect("display_source.boiler.not_enough_space", new Object[0]), Lang.translateDirect("display_source.boiler.for_boiler_status", new Object[0]));
    public static final List<List<class_5250>> notEnoughSpaceFlap = List.of(List.of(Lang.translateDirect("display_source.boiler.not_enough_space", new Object[0])), List.of(Lang.translateDirect("display_source.boiler.for_boiler_status", new Object[0])));

    @Override
    public List<class_5250> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        if (stats.maxRows() < 2) {
            return notEnoughSpaceSingle;
        }
        if (stats.maxRows() < 4) {
            return notEnoughSpaceDouble;
        }
        boolean isBook = context.getTargetTE() instanceof class_3722;
        if (isBook) {
            Stream<class_5250> componentList = this.getComponents(context, false).map(components -> {
                Optional reduce = components.stream().reduce(class_5250::method_10852);
                return reduce.orElse(EMPTY_LINE);
            });
            return List.of(componentList.reduce((comp1, comp2) -> comp1.method_10852((class_2561)Components.literal("\n")).method_10852((class_2561)comp2)).orElse(EMPTY_LINE));
        }
        return this.getComponents(context, false).map(components -> {
            Optional reduce = components.stream().reduce(class_5250::method_10852);
            return reduce.orElse(EMPTY_LINE);
        }).toList();
    }

    @Override
    public List<List<class_5250>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        if (stats.maxRows() < 4) {
            context.flapDisplayContext = Boolean.FALSE;
            return notEnoughSpaceFlap;
        }
        List<List<class_5250>> components = this.getComponents(context, true).toList();
        if ((float)stats.maxColumns() * 7.0f < 42.0f + (float)components.get(1).get(1).getString().length() * 9.0f) {
            context.flapDisplayContext = Boolean.FALSE;
            return notEnoughSpaceFlap;
        }
        return components;
    }

    @Override
    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayTileEntity flapDisplay, FlapDisplayLayout layout, int lineIndex) {
        Boolean b;
        Object object;
        if (lineIndex == 0 || (object = context.flapDisplayContext) instanceof Boolean && !(b = (Boolean)object).booleanValue()) {
            if (layout.isLayout("Default")) {
                return;
            }
            layout.loadDefault(flapDisplay.getMaxCharCount());
            return;
        }
        String layoutKey = "Boiler";
        if (layout.isLayout(layoutKey)) {
            return;
        }
        int labelLength = (int)((float)this.labelWidth() * 7.0f);
        float maxSpace = (float)flapDisplay.getMaxCharCount(1) * 7.0f;
        FlapDisplaySection label = new FlapDisplaySection(labelLength, "alphabet", false, true);
        FlapDisplaySection symbols = new FlapDisplaySection(maxSpace - (float)labelLength, "pixel", false, false).wideFlaps();
        layout.configure(layoutKey, List.of(label, symbols));
    }

    private Stream<List<class_5250>> getComponents(DisplayLinkContext context, boolean forFlapDisplay) {
        class_2586 sourceTE = context.getSourceTE();
        if (!(sourceTE instanceof FluidTankTileEntity)) {
            return Stream.of(EMPTY);
        }
        FluidTankTileEntity tankTile = (FluidTankTileEntity)sourceTE;
        tankTile = tankTile.getControllerTE();
        if (tankTile == null) {
            return Stream.of(EMPTY);
        }
        BoilerData boiler = tankTile.boiler;
        int totalTankSize = tankTile.getTotalTankSize();
        boiler.calcMinMaxForSize(totalTankSize);
        String label = forFlapDisplay ? "boiler.status" : "boiler.status_short";
        class_5250 size = this.labelOf(forFlapDisplay ? "size" : "");
        class_5250 water = this.labelOf(forFlapDisplay ? "water" : "");
        class_5250 heat = this.labelOf(forFlapDisplay ? "heat" : "");
        int lw = this.labelWidth();
        if (forFlapDisplay) {
            size = Components.literal(Strings.repeat((char)' ', (int)(lw - this.labelWidthOf("size")))).method_10852((class_2561)size);
            water = Components.literal(Strings.repeat((char)' ', (int)(lw - this.labelWidthOf("water")))).method_10852((class_2561)water);
            heat = Components.literal(Strings.repeat((char)' ', (int)(lw - this.labelWidthOf("heat")))).method_10852((class_2561)heat);
        }
        return Stream.of(List.of(Lang.translateDirect(label, boiler.getHeatLevelTextComponent())), List.of(size, boiler.getSizeComponent(!forFlapDisplay, forFlapDisplay, class_124.field_1074)), List.of(water, boiler.getWaterComponent(!forFlapDisplay, forFlapDisplay, class_124.field_1074)), List.of(heat, boiler.getHeatComponent(!forFlapDisplay, forFlapDisplay, class_124.field_1074)));
    }

    private int labelWidth() {
        return Math.max(this.labelWidthOf("water"), Math.max(this.labelWidthOf("size"), this.labelWidthOf("heat")));
    }

    private int labelWidthOf(String label) {
        return this.labelOf(label).getString().length();
    }

    private class_5250 labelOf(String label) {
        if (label.isBlank()) {
            return Components.empty();
        }
        return Lang.translateDirect("boiler." + label, new Object[0]);
    }

    @Override
    protected String getTranslationKey() {
        return "boiler_status";
    }
}

