/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.girder;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.curiosities.girder.GirderBlock;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class GirderWrenchBehavior {
    @Environment(value=EnvType.CLIENT)
    public static void tick() {
        class_239 class_23910;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null || !((class_23910 = mc.field_1765) instanceof class_3965)) {
            return;
        }
        class_3965 result = (class_3965)class_23910;
        class_638 world = mc.field_1687;
        class_2338 pos = result.method_17777();
        class_746 player = mc.field_1724;
        class_1799 heldItem = player.method_6047();
        if (player.method_21749()) {
            return;
        }
        if (!AllBlocks.METAL_GIRDER.has(world.method_8320(pos))) {
            return;
        }
        if (!AllItems.WRENCH.isIn(heldItem)) {
            return;
        }
        Pair<class_2350, Action> dirPair = GirderWrenchBehavior.getDirectionAndAction(result, (class_1937)world, pos);
        if (dirPair == null) {
            return;
        }
        class_243 center = VecHelper.getCenterOf((class_2382)pos);
        class_243 edge = center.method_1019(class_243.method_24954((class_2382)dirPair.getFirst().method_10163()).method_1021(0.4));
        class_2350.class_2351[] axes = (class_2350.class_2351[])Arrays.stream(Iterate.axes).filter(axis -> axis != ((class_2350)dirPair.getFirst()).method_10166()).toArray(class_2350.class_2351[]::new);
        double normalMultiplier = dirPair.getSecond() == Action.PAIR ? 4.0 : 1.0;
        class_243 corner1 = edge.method_1019(class_243.method_24954((class_2382)class_2350.method_10169((class_2350.class_2351)axes[0], (class_2350.class_2352)class_2350.class_2352.field_11056).method_10163()).method_1021(0.3)).method_1019(class_243.method_24954((class_2382)class_2350.method_10169((class_2350.class_2351)axes[1], (class_2350.class_2352)class_2350.class_2352.field_11056).method_10163()).method_1021(0.3)).method_1019(class_243.method_24954((class_2382)dirPair.getFirst().method_10163()).method_1021(0.1 * normalMultiplier));
        normalMultiplier = dirPair.getSecond() == Action.HORIZONTAL ? 9.0 : 2.0;
        class_243 corner2 = edge.method_1019(class_243.method_24954((class_2382)class_2350.method_10169((class_2350.class_2351)axes[0], (class_2350.class_2352)class_2350.class_2352.field_11060).method_10163()).method_1021(0.3)).method_1019(class_243.method_24954((class_2382)class_2350.method_10169((class_2350.class_2351)axes[1], (class_2350.class_2352)class_2350.class_2352.field_11060).method_10163()).method_1021(0.3)).method_1019(class_243.method_24954((class_2382)dirPair.getFirst().method_10153().method_10163()).method_1021(0.1 * normalMultiplier));
        CreateClient.OUTLINER.showAABB("girderWrench", new class_238(corner1, corner2)).lineWidth(0.03125f).colored(new Color(127, 127, 127));
    }

    @Nullable
    private static Pair<class_2350, Action> getDirectionAndAction(class_3965 result, class_1937 world, class_2338 pos) {
        List<Pair<class_2350, Action>> validDirections = GirderWrenchBehavior.getValidDirections((class_1922)world, pos);
        if (validDirections.isEmpty()) {
            return null;
        }
        List<class_2350> directions = IPlacementHelper.orderedByDistance(pos, result.method_17784(), validDirections.stream().map(Pair::getFirst).toList());
        if (directions.isEmpty()) {
            return null;
        }
        class_2350 dir = directions.get(0);
        return validDirections.stream().filter(pair -> pair.getFirst() == dir).findFirst().orElseGet(() -> Pair.of(dir, Action.SINGLE));
    }

    public static List<Pair<class_2350, Action>> getValidDirections(class_1922 level, class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);
        if (!AllBlocks.METAL_GIRDER.has(blockState)) {
            return Collections.emptyList();
        }
        return Arrays.stream(Iterate.directions).mapMulti((direction, consumer) -> {
            class_2680 other = level.method_8320(pos.method_10093(direction));
            if (!((Boolean)blockState.method_11654((class_2769)GirderBlock.X)).booleanValue() && !((Boolean)blockState.method_11654((class_2769)GirderBlock.Z)).booleanValue()) {
                return;
            }
            if (direction.method_10166() == class_2350.class_2351.field_11052) {
                if (!AllBlocks.METAL_GIRDER.has(other)) {
                    if ((Boolean)blockState.method_11654((class_2769)GirderBlock.X) == false ^ (Boolean)blockState.method_11654((class_2769)GirderBlock.Z) == false) {
                        consumer.accept(Pair.of(direction, Action.SINGLE));
                    }
                    return;
                }
                if (blockState.method_11654((class_2769)GirderBlock.X) == blockState.method_11654((class_2769)GirderBlock.Z)) {
                    return;
                }
                if (other.method_11654((class_2769)GirderBlock.X) == other.method_11654((class_2769)GirderBlock.Z)) {
                    return;
                }
                consumer.accept(Pair.of(direction, Action.PAIR));
                return;
            }
        }).toList();
    }

    public static boolean handleClick(class_1937 level, class_2338 pos, class_2680 state, class_3965 result) {
        Pair<class_2350, Action> dirPair = GirderWrenchBehavior.getDirectionAndAction(result, level, pos);
        if (dirPair == null) {
            return false;
        }
        if (level.field_9236) {
            return true;
        }
        if (!((Boolean)state.method_11654((class_2769)GirderBlock.X)).booleanValue() && !((Boolean)state.method_11654((class_2769)GirderBlock.Z)).booleanValue()) {
            return false;
        }
        class_2350 dir = dirPair.getFirst();
        class_2338 otherPos = pos.method_10093(dir);
        class_2680 other = level.method_8320(otherPos);
        if (dir == class_2350.field_11036) {
            level.method_8652(pos, GirderWrenchBehavior.postProcess((class_2680)state.method_28493((class_2769)GirderBlock.TOP)), 18);
            if (dirPair.getSecond() == Action.PAIR && AllBlocks.METAL_GIRDER.has(other)) {
                level.method_8652(otherPos, GirderWrenchBehavior.postProcess((class_2680)other.method_28493((class_2769)GirderBlock.BOTTOM)), 18);
            }
            return true;
        }
        if (dir == class_2350.field_11033) {
            level.method_8652(pos, GirderWrenchBehavior.postProcess((class_2680)state.method_28493((class_2769)GirderBlock.BOTTOM)), 18);
            if (dirPair.getSecond() == Action.PAIR && AllBlocks.METAL_GIRDER.has(other)) {
                level.method_8652(otherPos, GirderWrenchBehavior.postProcess((class_2680)other.method_28493((class_2769)GirderBlock.TOP)), 18);
            }
            return true;
        }
        return true;
    }

    private static class_2680 postProcess(class_2680 newState) {
        if (((Boolean)newState.method_11654((class_2769)GirderBlock.TOP)).booleanValue() && ((Boolean)newState.method_11654((class_2769)GirderBlock.BOTTOM)).booleanValue()) {
            return newState;
        }
        if (newState.method_11654(GirderBlock.AXIS) != class_2350.class_2351.field_11052) {
            return newState;
        }
        return (class_2680)newState.method_11657(GirderBlock.AXIS, (Comparable)((Boolean)newState.method_11654((class_2769)GirderBlock.X) != false ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051));
    }

    private static enum Action {
        SINGLE,
        PAIR,
        HORIZONTAL;

    }
}

