/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.function.Predicate;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class BracketedTileEntityBehaviour
extends TileEntityBehaviour {
    public static final BehaviourType<BracketedTileEntityBehaviour> TYPE = new BehaviourType();
    private class_2680 bracket;
    private boolean reRender;
    private Predicate<class_2680> pred;

    public BracketedTileEntityBehaviour(SmartTileEntity te) {
        this(te, state -> true);
    }

    public BracketedTileEntityBehaviour(SmartTileEntity te, Predicate<class_2680> pred) {
        super(te);
        this.pred = pred;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void applyBracket(class_2680 state) {
        this.bracket = state;
        this.reRender = true;
        this.tileEntity.notifyUpdate();
        class_1937 world = this.getWorld();
        if (world.field_9236) {
            return;
        }
        this.tileEntity.method_11010().method_30101((class_1936)world, this.getPos(), 3);
    }

    public void transformBracket(StructureTransform transform) {
        if (this.isBracketPresent()) {
            class_2680 transformedBracket = transform.apply(this.bracket);
            this.applyBracket(transformedBracket);
        }
    }

    @Nullable
    public class_2680 removeBracket(boolean inOnReplacedContext) {
        if (this.bracket == null) {
            return null;
        }
        class_2680 removed = this.bracket;
        class_1937 world = this.getWorld();
        if (!world.field_9236) {
            world.method_20290(2001, this.getPos(), class_2248.method_9507((class_2680)this.bracket));
        }
        this.bracket = null;
        this.reRender = true;
        if (inOnReplacedContext) {
            this.tileEntity.sendData();
            return removed;
        }
        this.tileEntity.notifyUpdate();
        if (world.field_9236) {
            return removed;
        }
        this.tileEntity.method_11010().method_30101((class_1936)world, this.getPos(), 3);
        return removed;
    }

    public boolean isBracketPresent() {
        return this.bracket != null;
    }

    @Nullable
    public class_2680 getBracket() {
        return this.bracket;
    }

    public boolean canHaveBracket() {
        return this.pred.test(this.tileEntity.method_11010());
    }

    @Override
    public ItemRequirement getRequiredItems() {
        if (!this.isBracketPresent()) {
            return ItemRequirement.NONE;
        }
        return ItemRequirement.of(this.bracket, null);
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        if (this.isBracketPresent()) {
            nbt.method_10566("Bracket", (class_2520)class_2512.method_10686((class_2680)this.bracket));
        }
        if (clientPacket && this.reRender) {
            NBTHelper.putMarker(nbt, "Redraw");
            this.reRender = false;
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        if (nbt.method_10545("Bracket")) {
            this.bracket = class_2512.method_10681((class_2487)nbt.method_10562("Bracket"));
        }
        if (clientPacket && nbt.method_10545("Redraw")) {
            this.getWorld().method_8413(this.getPos(), this.tileEntity.method_11010(), this.tileEntity.method_11010(), 16);
        }
        super.read(nbt, clientPacket);
    }
}

