/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class BeltShapes {
    private static final class_265 SLOPE_DESC_PART = BeltShapes.makeSlopePart(false);
    private static final class_265 SLOPE_ASC_PART = BeltShapes.makeSlopePart(true);
    private static final class_265 SIDEWAYS_FULL_PART = BeltShapes.makeSidewaysFull();
    private static final class_265 SIDEWAYS_END_PART = BeltShapes.makeSidewaysEnding();
    private static final class_265 FLAT_FULL_PART = BeltShapes.makeFlatFull();
    private static final class_265 FLAT_END_PART = BeltShapes.makeFlatEnding();
    private static final class_265 SOUTH_MASK = class_2248.method_9541((double)0.0, (double)-5.0, (double)8.0, (double)16.0, (double)21.0, (double)16.0);
    private static final class_265 NORTH_MASK = class_2248.method_9541((double)0.0, (double)-5.0, (double)0.0, (double)16.0, (double)21.0, (double)8.0);
    private static final VoxelShaper VERTICAL_FULL = VerticalBeltShaper.make(FLAT_FULL_PART);
    private static final VoxelShaper VERTICAL_END = VerticalBeltShaper.make(BeltShapes.compose(FLAT_END_PART, FLAT_FULL_PART));
    private static final VoxelShaper VERTICAL_START = VerticalBeltShaper.make(BeltShapes.compose(FLAT_FULL_PART, FLAT_END_PART));
    private static final VoxelShaper FLAT_FULL = VoxelShaper.forHorizontalAxis(FLAT_FULL_PART, class_2350.class_2351.field_11051);
    private static final VoxelShaper FLAT_END = VoxelShaper.forHorizontal(BeltShapes.compose(FLAT_END_PART, FLAT_FULL_PART), class_2350.field_11035);
    private static final VoxelShaper FLAT_START = VoxelShaper.forHorizontal(BeltShapes.compose(FLAT_FULL_PART, FLAT_END_PART), class_2350.field_11035);
    private static final VoxelShaper SIDE_FULL = VoxelShaper.forHorizontalAxis(SIDEWAYS_FULL_PART, class_2350.class_2351.field_11051);
    private static final VoxelShaper SIDE_END = VoxelShaper.forHorizontal(BeltShapes.compose(SIDEWAYS_END_PART, SIDEWAYS_FULL_PART), class_2350.field_11035);
    private static final VoxelShaper SIDE_START = VoxelShaper.forHorizontal(BeltShapes.compose(SIDEWAYS_FULL_PART, SIDEWAYS_END_PART), class_2350.field_11035);
    private static final VoxelShaper SLOPE_DESC = VoxelShaper.forHorizontal(SLOPE_DESC_PART, class_2350.field_11035);
    private static final VoxelShaper SLOPE_ASC = VoxelShaper.forHorizontal(SLOPE_ASC_PART, class_2350.field_11035);
    private static final VoxelShaper SLOPE_DESC_END = VoxelShaper.forHorizontal(BeltShapes.compose(FLAT_END_PART, SLOPE_DESC_PART), class_2350.field_11035);
    private static final VoxelShaper SLOPE_DESC_START = VoxelShaper.forHorizontal(BeltShapes.compose(SLOPE_DESC_PART, FLAT_END_PART), class_2350.field_11035);
    private static final VoxelShaper SLOPE_ASC_END = VoxelShaper.forHorizontal(BeltShapes.compose(FLAT_END_PART, SLOPE_ASC_PART), class_2350.field_11035);
    private static final VoxelShaper SLOPE_ASC_START = VoxelShaper.forHorizontal(BeltShapes.compose(SLOPE_ASC_PART, FLAT_END_PART), class_2350.field_11035);
    private static final VoxelShaper PARTIAL_CASING = VoxelShaper.forHorizontal(class_2248.method_9541((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)11.0, (double)16.0), class_2350.field_11035);
    static Map<class_2680, class_265> cache = new HashMap<class_2680, class_265>();
    static Map<class_2680, class_265> collisionCache = new HashMap<class_2680, class_265>();

    private static class_265 compose(class_265 southPart, class_265 northPart) {
        return class_259.method_1084((class_265)class_259.method_1082((class_265)SOUTH_MASK, (class_265)southPart, (class_247)class_247.field_16896), (class_265)class_259.method_1082((class_265)NORTH_MASK, (class_265)northPart, (class_247)class_247.field_16896));
    }

    private static class_265 makeSlopePart(boolean ascendingInstead) {
        class_265 slice = class_2248.method_9541((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)11.0, (double)16.0);
        class_265 result = class_259.method_1073();
        for (int i = 0; i < 16; ++i) {
            int yOffset = ascendingInstead ? 10 - i : i - 5;
            result = class_259.method_1084((class_265)result, (class_265)slice.method_1096(0.0, (double)((float)yOffset / 16.0f), (double)((float)(-i) / 16.0f)));
        }
        return result;
    }

    private static class_265 makeFlatEnding() {
        return class_259.method_1084((class_265)class_2248.method_9541((double)1.0, (double)4.0, (double)0.0, (double)15.0, (double)12.0, (double)16.0), (class_265)class_2248.method_9541((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0));
    }

    private static class_265 makeFlatFull() {
        return class_2248.method_9541((double)1.0, (double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0);
    }

    private static class_265 makeSidewaysEnding() {
        return class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)15.0, (double)16.0), (class_265)class_2248.method_9541((double)3.0, (double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0));
    }

    private static class_265 makeSidewaysFull() {
        return class_2248.method_9541((double)3.0, (double)1.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0);
    }

    public static class_265 getShape(class_2680 state) {
        if (cache.containsKey(state)) {
            return cache.get(state);
        }
        class_265 createdShape = class_259.method_1084((class_265)BeltShapes.getBeltShape(state), (class_265)BeltShapes.getCasingShape(state));
        cache.put(state, createdShape);
        return createdShape;
    }

    public static class_265 getCollisionShape(class_2680 state) {
        if (collisionCache.containsKey(state)) {
            return collisionCache.get(state);
        }
        class_265 createdShape = class_259.method_1082((class_265)AllShapes.BELT_COLLISION_MASK, (class_265)BeltShapes.getShape(state), (class_247)class_247.field_16896);
        collisionCache.put(state, createdShape);
        return createdShape;
    }

    private static class_265 getBeltShape(class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654(BeltBlock.HORIZONTAL_FACING);
        class_2350.class_2351 axis = facing.method_10166();
        BeltPart part = (BeltPart)((Object)state.method_11654(BeltBlock.PART));
        BeltSlope slope = (BeltSlope)((Object)state.method_11654(BeltBlock.SLOPE));
        if (slope == BeltSlope.VERTICAL) {
            if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY) {
                return VERTICAL_FULL.get(axis);
            }
            return (part == BeltPart.START ? VERTICAL_START : VERTICAL_END).get(facing);
        }
        if (slope == BeltSlope.HORIZONTAL) {
            if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY) {
                return FLAT_FULL.get(axis);
            }
            return (part == BeltPart.START ? FLAT_START : FLAT_END).get(facing);
        }
        if (slope == BeltSlope.SIDEWAYS) {
            if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY) {
                return SIDE_FULL.get(axis);
            }
            return (part == BeltPart.START ? SIDE_START : SIDE_END).get(facing);
        }
        if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY) {
            return (slope == BeltSlope.DOWNWARD ? SLOPE_DESC : SLOPE_ASC).get(facing);
        }
        if (part == BeltPart.START) {
            return (slope == BeltSlope.DOWNWARD ? SLOPE_DESC_START : SLOPE_ASC_START).get(facing);
        }
        if (part == BeltPart.END) {
            return (slope == BeltSlope.DOWNWARD ? SLOPE_DESC_END : SLOPE_ASC_END).get(facing);
        }
        return class_259.method_1073();
    }

    private static class_265 getCasingShape(class_2680 state) {
        if (!((Boolean)state.method_11654((class_2769)BeltBlock.CASING)).booleanValue()) {
            return class_259.method_1073();
        }
        class_2350 facing = (class_2350)state.method_11654(BeltBlock.HORIZONTAL_FACING);
        BeltPart part = (BeltPart)((Object)state.method_11654(BeltBlock.PART));
        BeltSlope slope = (BeltSlope)((Object)state.method_11654(BeltBlock.SLOPE));
        if (slope == BeltSlope.VERTICAL) {
            return class_259.method_1073();
        }
        if (slope == BeltSlope.SIDEWAYS) {
            return class_259.method_1073();
        }
        if (slope == BeltSlope.HORIZONTAL) {
            return AllShapes.CASING_11PX.get(class_2350.field_11036);
        }
        if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY) {
            return PARTIAL_CASING.get(slope == BeltSlope.UPWARD ? facing : facing.method_10153());
        }
        if (part == BeltPart.START) {
            return slope == BeltSlope.UPWARD ? AllShapes.CASING_11PX.get(class_2350.field_11036) : PARTIAL_CASING.get(facing.method_10153());
        }
        if (part == BeltPart.END) {
            return slope == BeltSlope.DOWNWARD ? AllShapes.CASING_11PX.get(class_2350.field_11036) : PARTIAL_CASING.get(facing);
        }
        return class_259.method_1077();
    }

    private static class VerticalBeltShaper
    extends VoxelShaper {
        private VerticalBeltShaper() {
        }

        public static VoxelShaper make(class_265 southBeltShape) {
            return VerticalBeltShaper.forDirectionsWithRotation(VerticalBeltShaper.rotatedCopy(southBeltShape, new class_243(-90.0, 0.0, 0.0)), class_2350.field_11035, (Iterable<class_2350>)class_2350.class_2353.field_11062, direction -> new class_243(direction.method_10171() == class_2350.class_2352.field_11056 ? 0.0 : 180.0, (double)(-direction.method_10144()), 0.0));
        }
    }
}

