/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_746;

public class BlazeBurnerTileEntity
extends SmartTileEntity {
    public static final int MAX_HEAT_CAPACITY = 10000;
    public static final int INSERTION_THRESHOLD = 500;
    protected FuelType activeFuel = FuelType.NONE;
    protected int remainingBurnTime = 0;
    protected LerpedFloat headAnimation = LerpedFloat.linear();
    protected LerpedFloat headAngle = LerpedFloat.angular();
    protected boolean isCreative = false;
    protected boolean goggles = false;
    protected boolean hat;

    public BlazeBurnerTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.headAngle.startWithValue((AngleHelper.horizontalAngle(state.method_28500((class_2769)BlazeBurnerBlock.field_11177).orElse(class_2350.field_11035)) + 180.0f) % 360.0f);
    }

    public FuelType getActiveFuel() {
        return this.activeFuel;
    }

    public int getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.field_9236) {
            this.tickAnimation();
            if (!this.isVirtual()) {
                this.spawnParticles(this.getHeatLevelFromBlock(), 1.0);
            }
            return;
        }
        if (this.isCreative) {
            return;
        }
        if (this.remainingBurnTime > 0) {
            --this.remainingBurnTime;
        }
        if (this.activeFuel == FuelType.NORMAL) {
            this.updateBlockState();
        }
        if (this.remainingBurnTime > 0) {
            return;
        }
        if (this.activeFuel == FuelType.SPECIAL) {
            this.activeFuel = FuelType.NORMAL;
            this.remainingBurnTime = 5000;
        } else {
            this.activeFuel = FuelType.NONE;
        }
        this.updateBlockState();
    }

    @Environment(value=EnvType.CLIENT)
    private void tickAnimation() {
        boolean active;
        boolean bl = active = this.getHeatLevelFromBlock().isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && this.isValidBlockAbove();
        if (!active) {
            float target = 0.0f;
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && !player.method_5767()) {
                double z;
                double x;
                if (this.isVirtual()) {
                    x = -4.0;
                    z = -10.0;
                } else {
                    x = player.method_23317();
                    z = player.method_23321();
                }
                double dx = x - ((double)this.method_11016().method_10263() + 0.5);
                double dz = z - ((double)this.method_11016().method_10260() + 0.5);
                target = AngleHelper.deg(-class_3532.method_15349((double)dz, (double)dx)) - 90.0f;
            }
            target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff(this.headAngle.getValue(), target);
            this.headAngle.chase(target, 0.25, LerpedFloat.Chaser.exp(5.0));
            this.headAngle.tickChaser();
        } else {
            this.headAngle.chase((AngleHelper.horizontalAngle(this.method_11010().method_28500((class_2769)BlazeBurnerBlock.field_11177).orElse(class_2350.field_11035)) + 180.0f) % 360.0f, 0.125, LerpedFloat.Chaser.EXP);
            this.headAngle.tickChaser();
        }
        this.headAnimation.chase(active ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.exp(0.25));
        this.headAnimation.tickChaser();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        if (!this.isCreative) {
            compound.method_10569("fuelLevel", this.activeFuel.ordinal());
            compound.method_10569("burnTimeRemaining", this.remainingBurnTime);
        } else {
            compound.method_10556("isCreative", true);
        }
        if (this.goggles) {
            compound.method_10556("Goggles", true);
        }
        if (this.hat) {
            compound.method_10556("TrainHat", true);
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.activeFuel = FuelType.values()[compound.method_10550("fuelLevel")];
        this.remainingBurnTime = compound.method_10550("burnTimeRemaining");
        this.isCreative = compound.method_10577("isCreative");
        this.goggles = compound.method_10545("Goggles");
        this.hat = compound.method_10545("TrainHat");
        super.read(compound, clientPacket);
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return BlazeBurnerBlock.getHeatLevelOf(this.method_11010());
    }

    public void updateBlockState() {
        this.setBlockHeat(this.getHeatLevel());
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel heat) {
        BlazeBurnerBlock.HeatLevel inBlockState = this.getHeatLevelFromBlock();
        if (inBlockState == heat) {
            return;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)heat)));
        this.notifyUpdate();
    }

    protected boolean tryUpdateFuel(class_1799 itemStack, boolean forceOverflow, TransactionContext ctx) {
        int newBurnTime;
        if (this.isCreative) {
            return false;
        }
        FuelType newFuel = FuelType.NONE;
        if (AllTags.AllItemTags.BLAZE_BURNER_FUEL_SPECIAL.matches(itemStack)) {
            newBurnTime = 3200;
            newFuel = FuelType.SPECIAL;
        } else {
            Integer fuel = (Integer)FuelRegistry.INSTANCE.get((class_1935)itemStack.method_7909());
            int n = newBurnTime = fuel == null ? 0 : fuel;
            if (newBurnTime > 0) {
                newFuel = FuelType.NORMAL;
            } else if (AllTags.AllItemTags.BLAZE_BURNER_FUEL_REGULAR.matches(itemStack)) {
                newBurnTime = 1600;
                newFuel = FuelType.NORMAL;
            }
        }
        if (newFuel == FuelType.NONE) {
            return false;
        }
        if (newFuel.ordinal() < this.activeFuel.ordinal()) {
            return false;
        }
        if (newFuel == this.activeFuel) {
            if (this.remainingBurnTime <= 500) {
                newBurnTime += this.remainingBurnTime;
            } else if (forceOverflow && newFuel == FuelType.NORMAL) {
                newBurnTime = this.remainingBurnTime < 10000 ? Math.min(this.remainingBurnTime + newBurnTime, 10000) : this.remainingBurnTime;
            } else {
                return false;
            }
        }
        FuelType finalNewFuel = newFuel;
        int finalNewBurnTime = newBurnTime;
        TransactionCallback.onSuccess((TransactionContext)ctx, () -> {
            this.activeFuel = finalNewFuel;
            this.remainingBurnTime = finalNewBurnTime;
            if (this.field_11863.field_9236) {
                this.spawnParticleBurst(this.activeFuel == FuelType.SPECIAL);
                return;
            }
            BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
            this.playSound();
            this.updateBlockState();
            if (prev != this.getHeatLevelFromBlock()) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14991, class_3419.field_15245, 0.125f + this.field_11863.field_9229.method_43057() * 0.125f, 1.15f - this.field_11863.field_9229.method_43057() * 0.25f);
            }
        });
        return true;
    }

    protected void applyCreativeFuel() {
        this.activeFuel = FuelType.NONE;
        this.remainingBurnTime = 0;
        this.isCreative = true;
        BlazeBurnerBlock.HeatLevel next = this.getHeatLevelFromBlock().nextActiveLevel();
        if (this.field_11863.field_9236) {
            this.spawnParticleBurst(next.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING));
            return;
        }
        this.playSound();
        if (next == BlazeBurnerBlock.HeatLevel.FADING) {
            next = next.nextActiveLevel();
        }
        this.setBlockHeat(next);
    }

    public boolean isCreativeFuel(class_1799 stack) {
        return AllItems.CREATIVE_BLAZE_CAKE.isIn(stack);
    }

    public boolean isValidBlockAbove() {
        class_2680 blockState = this.field_11863.method_8320(this.field_11867.method_10084());
        return AllBlocks.BASIN.has(blockState) || blockState.method_26204() instanceof FluidTankBlock;
    }

    protected void playSound() {
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_14970, class_3419.field_15245, 0.125f + this.field_11863.field_9229.method_43057() * 0.125f, 0.75f - this.field_11863.field_9229.method_43057() * 0.25f);
    }

    protected BlazeBurnerBlock.HeatLevel getHeatLevel() {
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.SMOULDERING;
        switch (this.activeFuel) {
            case SPECIAL: {
                level = BlazeBurnerBlock.HeatLevel.SEETHING;
                break;
            }
            case NORMAL: {
                boolean lowPercent = (double)this.remainingBurnTime / 10000.0 < 0.0125;
                level = lowPercent ? BlazeBurnerBlock.HeatLevel.FADING : BlazeBurnerBlock.HeatLevel.KINDLED;
                break;
            }
        }
        return level;
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel, double burstMult) {
        if (this.field_11863 == null) {
            return;
        }
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        class_5819 r = this.field_11863.method_8409();
        class_243 c = VecHelper.getCenterOf((class_2382)this.field_11867);
        class_243 v = c.method_1019(VecHelper.offsetRandomly(class_243.field_1353, r, 0.125f).method_18805(1.0, 0.0, 1.0));
        if (r.method_43048(4) != 0) {
            return;
        }
        boolean empty = this.field_11863.method_8320(this.field_11867.method_10084()).method_26220((class_1922)this.field_11863, this.field_11867.method_10084()).method_1110();
        if (empty || r.method_43048(8) == 0) {
            this.field_11863.method_8406((class_2394)class_2398.field_11237, v.field_1352, v.field_1351, v.field_1350, 0.0, 0.0, 0.0);
        }
        double yMotion = empty ? 0.0625 : r.method_43058() * (double)0.0125f;
        class_243 v2 = c.method_1019(VecHelper.offsetRandomly(class_243.field_1353, r, 0.5f).method_18805(1.0, 0.25, 1.0).method_1029().method_1021((empty ? 0.25 : 0.5) + r.method_43058() * 0.125)).method_1031(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            this.field_11863.method_8406((class_2394)class_2398.field_22246, v2.field_1352, v2.field_1351, v2.field_1350, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            this.field_11863.method_8406((class_2394)class_2398.field_11240, v2.field_1352, v2.field_1351, v2.field_1350, 0.0, yMotion, 0.0);
        }
    }

    public void spawnParticleBurst(boolean soulFlame) {
        class_243 c = VecHelper.getCenterOf((class_2382)this.field_11867);
        class_5819 r = this.field_11863.field_9229;
        for (int i = 0; i < 20; ++i) {
            class_243 offset = VecHelper.offsetRandomly(class_243.field_1353, r, 0.5f).method_18805(1.0, 0.25, 1.0).method_1029();
            class_243 v = c.method_1019(offset.method_1021(0.5 + r.method_43058() * 0.125)).method_1031(0.0, 0.125, 0.0);
            class_243 m = offset.method_1021(0.03125);
            this.field_11863.method_8406((class_2394)(soulFlame ? class_2398.field_22246 : class_2398.field_11240), v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    public static enum FuelType {
        NONE,
        NORMAL,
        SPECIAL;

    }
}

