/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerRenderer;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraption;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4597;
import net.minecraft.class_5819;

public class BlazeBurnerMovementBehaviour
implements MovementBehaviour {
    @Override
    public boolean renderAsNormalTileEntity() {
        return false;
    }

    @Override
    public void tick(MovementContext context) {
        if (!context.world.method_8608()) {
            return;
        }
        if (!this.shouldRender(context)) {
            return;
        }
        class_5819 r = context.world.method_8409();
        class_243 c = context.position;
        class_243 v = c.method_1019(VecHelper.offsetRandomly(class_243.field_1353, r, 0.125f).method_18805(1.0, 0.0, 1.0));
        if (r.method_43048(3) == 0 && context.motion.method_1033() < 0.015625) {
            context.world.method_8406((class_2394)class_2398.field_11237, v.field_1352, v.field_1351, v.field_1350, 0.0, 0.0, 0.0);
        }
        LerpedFloat headAngle = this.getHeadAngle(context);
        boolean quickTurn = this.shouldRenderHat(context) && !class_3532.method_20390((double)context.relativeMotion.method_1033(), (double)0.0);
        headAngle.chase(headAngle.getValue() + AngleHelper.getShortestAngleDiff(headAngle.getValue(), this.getTargetAngle(context)), 0.5, quickTurn ? LerpedFloat.Chaser.EXP : LerpedFloat.Chaser.exp(5.0));
        headAngle.tickChaser();
    }

    public void invalidate(MovementContext context) {
        context.data.method_10551("Conductor");
    }

    private boolean shouldRender(MovementContext context) {
        return context.state.method_28500(BlazeBurnerBlock.HEAT_LEVEL).orElse(BlazeBurnerBlock.HeatLevel.NONE) != BlazeBurnerBlock.HeatLevel.NONE;
    }

    private LerpedFloat getHeadAngle(MovementContext context) {
        if (!(context.temporaryData instanceof LerpedFloat)) {
            context.temporaryData = LerpedFloat.angular().startWithValue(this.getTargetAngle(context));
        }
        return (LerpedFloat)context.temporaryData;
    }

    private float getTargetAngle(MovementContext context) {
        AbstractContraptionEntity abstractContraptionEntity;
        if (this.shouldRenderHat(context) && !class_3532.method_20390((double)context.relativeMotion.method_1033(), (double)0.0) && (abstractContraptionEntity = context.contraption.entity) instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
            float angle = AngleHelper.deg(-class_3532.method_15349((double)context.relativeMotion.field_1352, (double)context.relativeMotion.field_1350));
            return cce.getInitialOrientation().method_10166() == class_2350.class_2351.field_11048 ? angle + 180.0f : angle;
        }
        class_1297 player = class_310.method_1551().field_1719;
        if (player != null && !player.method_5767() && context.position != null) {
            class_243 applyRotation = context.contraption.entity.reverseRotation(player.method_19538().method_1020(context.position), 1.0f);
            double dx = applyRotation.field_1352;
            double dz = applyRotation.field_1350;
            return AngleHelper.deg(-class_3532.method_15349((double)dz, (double)dx)) - 90.0f;
        }
        return 0.0f;
    }

    private boolean shouldRenderHat(MovementContext context) {
        CarriageContraptionEntity cce;
        AbstractContraptionEntity abstractContraptionEntity;
        class_2487 data = context.data;
        if (!data.method_10545("Conductor")) {
            data.method_10556("Conductor", this.determineIfConducting(context));
        }
        return data.method_10577("Conductor") && (abstractContraptionEntity = context.contraption.entity) instanceof CarriageContraptionEntity && (cce = (CarriageContraptionEntity)abstractContraptionEntity).hasSchedule();
    }

    private boolean determineIfConducting(MovementContext context) {
        Contraption contraption = context.contraption;
        if (!(contraption instanceof CarriageContraption)) {
            return false;
        }
        CarriageContraption carriageContraption = (CarriageContraption)contraption;
        class_2350 assemblyDirection = carriageContraption.getAssemblyDirection();
        for (class_2350 direction : Iterate.directionsInAxis(assemblyDirection.method_10166())) {
            if (!carriageContraption.inControl(context.localPos, direction)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
        if (!this.shouldRender(context)) {
            return;
        }
        BlazeBurnerRenderer.renderInContraption(context, renderWorld, matrices, buffer, this.getHeadAngle(context), this.shouldRenderHat(context));
    }
}

