/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.millstone;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.millstone.MillingRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.sound.SoundScapes;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.ViewOnlyWrappedStorageView;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MillstoneTileEntity
extends KineticTileEntity
implements SidedStorageBlockEntity {
    public ItemStackHandlerContainer inputInv = new ItemStackHandlerContainer(1);
    public ItemStackHandler outputInv = new ItemStackHandler(9);
    public MillstoneInventoryHandler capability = new MillstoneInventoryHandler();
    public int timer;
    private MillingRecipe lastRecipe;

    public MillstoneTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this));
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.MILLSTONE);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inputInv.getStackInSlot(0).method_7960()) {
            return;
        }
        float pitch = class_3532.method_15363((float)(Math.abs(this.getSpeed()) / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        SoundScapes.play(SoundScapes.AmbienceGroup.MILLING, this.field_11867, pitch);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (this.outputInv.getStackInSlot(i).method_7947() != this.outputInv.getSlotLimit(i)) continue;
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.field_11863.field_9236) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        if (this.inputInv.getStackInSlot(0).method_7960()) {
            return;
        }
        if (this.lastRecipe == null || !this.lastRecipe.method_8115((class_1263)this.inputInv, this.field_11863)) {
            Optional recipe = AllRecipeTypes.MILLING.find(this.inputInv, this.field_11863);
            if (!recipe.isPresent()) {
                this.timer = 100;
                this.sendData();
            } else {
                this.lastRecipe = (MillingRecipe)recipe.get();
                this.timer = this.lastRecipe.getProcessingDuration();
                this.sendData();
            }
            return;
        }
        this.timer = this.lastRecipe.getProcessingDuration();
        this.sendData();
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public void destroy() {
        super.destroy();
        ItemHelper.dropContents(this.field_11863, this.field_11867, (Storage<ItemVariant>)this.inputInv);
        ItemHelper.dropContents(this.field_11863, this.field_11867, (Storage<ItemVariant>)this.outputInv);
    }

    private void process() {
        if (this.lastRecipe == null || !this.lastRecipe.method_8115((class_1263)this.inputInv, this.field_11863)) {
            Optional recipe = AllRecipeTypes.MILLING.find(this.inputInv, this.field_11863);
            if (!recipe.isPresent()) {
                return;
            }
            this.lastRecipe = (MillingRecipe)recipe.get();
        }
        class_1799 stackInSlot = this.inputInv.getStackInSlot(0);
        stackInSlot.method_7934(1);
        this.inputInv.setStackInSlot(0, stackInSlot);
        try (Transaction t = TransferUtil.getTransaction();){
            this.lastRecipe.rollResults().forEach(stack -> this.outputInv.insert(ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)t));
            t.commit();
        }
        this.award(AllAdvancements.MILLSTONE);
        this.sendData();
        this.method_5431();
    }

    public void spawnParticles() {
        class_1799 stackInSlot = this.inputInv.getStackInSlot(0);
        if (stackInSlot.method_7960()) {
            return;
        }
        class_2392 data = new class_2392(class_2398.field_11218, stackInSlot);
        float angle = this.field_11863.field_9229.method_43057() * 360.0f;
        class_243 offset = new class_243(0.0, 0.0, 0.5);
        offset = VecHelper.rotate(offset, angle, class_2350.class_2351.field_11052);
        class_243 target = VecHelper.rotate(offset, this.getSpeed() > 0.0f ? 25.0 : -25.0, class_2350.class_2351.field_11052);
        class_243 center = offset.method_1019(VecHelper.getCenterOf((class_2382)this.field_11867));
        target = VecHelper.offsetRandomly(target.method_1020(offset), this.field_11863.field_9229, 0.0078125f);
        this.field_11863.method_8406((class_2394)data, center.field_1352, center.field_1351, center.field_1350, target.field_1352, target.field_1351, target.field_1350);
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("Timer", this.timer);
        compound.method_10566("InputInventory", (class_2520)this.inputInv.serializeNBT());
        compound.method_10566("OutputInventory", (class_2520)this.outputInv.serializeNBT());
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.timer = compound.method_10550("Timer");
        this.inputInv.deserializeNBT(compound.method_10562("InputInventory"));
        this.outputInv.deserializeNBT(compound.method_10562("OutputInventory"));
        super.read(compound, clientPacket);
    }

    public int getProcessingSpeed() {
        return class_3532.method_15340((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 direction) {
        return this.capability;
    }

    private boolean canProcess(class_1799 stack) {
        ItemStackHandlerContainer tester = new ItemStackHandlerContainer(1);
        tester.setStackInSlot(0, stack);
        if (this.lastRecipe != null && this.lastRecipe.method_8115((class_1263)tester, this.field_11863)) {
            return true;
        }
        return AllRecipeTypes.MILLING.find(tester, this.field_11863).isPresent();
    }

    private class MillstoneInventoryHandler
    extends CombinedStorage<ItemVariant, ItemStackHandler> {
        public MillstoneInventoryHandler() {
            super(List.of(MillstoneTileEntity.this.inputInv, MillstoneTileEntity.this.outputInv));
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (MillstoneTileEntity.this.canProcess(resource.toStack())) {
                return MillstoneTileEntity.this.inputInv.insert(resource, maxAmount, transaction);
            }
            return 0L;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return MillstoneTileEntity.this.outputInv.extract(resource, maxAmount, transaction);
        }

        @NotNull
        public Iterator<StorageView<ItemVariant>> iterator() {
            return new MillstoneInventoryHandlerIterator();
        }

        private class MillstoneInventoryHandlerIterator
        implements Iterator<StorageView<ItemVariant>> {
            private boolean output = true;
            private Iterator<StorageView<ItemVariant>> wrapped;

            public MillstoneInventoryHandlerIterator() {
                this.wrapped = MillstoneTileEntity.this.outputInv.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.wrapped.hasNext();
            }

            @Override
            public StorageView<ItemVariant> next() {
                ViewOnlyWrappedStorageView view = this.wrapped.next();
                if (!this.output) {
                    view = new ViewOnlyWrappedStorageView(view);
                }
                if (this.output && !this.hasNext()) {
                    this.wrapped = MillstoneTileEntity.this.inputInv.iterator();
                    this.output = false;
                }
                return view;
            }
        }
    }
}

