/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.sequencedAssembly.JeiSequencedAssemblySubCategory;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedRecipe;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class SequencedAssemblyCategory
extends CreateRecipeCategory<SequencedAssemblyRecipe> {
    Map<class_2960, JeiSequencedAssemblySubCategory> subCategories = new HashMap<class_2960, JeiSequencedAssemblySubCategory>();
    final String[] romans = new String[]{"I", "II", "III", "IV", "V", "VI", "-"};

    public SequencedAssemblyCategory(CreateRecipeCategory.Info<SequencedAssemblyRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SequencedAssemblyRecipe recipe, IFocusGroup focuses) {
        boolean noRandomOutput = recipe.getOutputChance() == 1.0f;
        int xOffset = noRandomOutput ? 0 : -7;
        builder.addSlot(RecipeIngredientRole.INPUT, 27 + xOffset, 91).setBackground(SequencedAssemblyCategory.getRenderedSlot(), -1, -1).addItemStacks(List.of(recipe.getIngredient().method_8105()));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 132 + xOffset, 91).setBackground(SequencedAssemblyCategory.getRenderedSlot(recipe.getOutputChance()), -1, -1).addItemStack(recipe.method_8110())).addTooltipCallback((recipeSlotView, tooltip) -> {
            if (noRandomOutput) {
                return;
            }
            float chance = recipe.getOutputChance();
            tooltip.add(1, this.chanceComponent(chance));
        });
        int width = 0;
        int margin = 3;
        for (SequencedRecipe<?> sequencedRecipe : recipe.getSequence()) {
            width += this.getSubCategory(sequencedRecipe).getWidth() + margin;
        }
        int x = (width -= margin) / -2 + this.getBackground().getWidth() / 2;
        for (SequencedRecipe<?> sequencedRecipe : recipe.getSequence()) {
            JeiSequencedAssemblySubCategory subCategory = this.getSubCategory(sequencedRecipe);
            subCategory.setRecipe(builder, sequencedRecipe, focuses, x);
            x += subCategory.getWidth() + margin;
        }
    }

    private JeiSequencedAssemblySubCategory getSubCategory(SequencedRecipe<?> sequencedRecipe) {
        return this.subCategories.computeIfAbsent(RegisteredObjects.getKeyOrThrow(sequencedRecipe.getRecipe().method_8119()), rl -> sequencedRecipe.getAsAssemblyRecipe().getJEISubCategory().jei().get().get());
    }

    public void draw(SequencedAssemblyRecipe recipe, IRecipeSlotsView iRecipeSlotsView, class_4587 matrixStack, double mouseX, double mouseY) {
        class_327 font = class_310.method_1551().field_1772;
        matrixStack.method_22903();
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 15.0, 0.0);
        boolean singleOutput = recipe.getOutputChance() == 1.0f;
        int xOffset = singleOutput ? 0 : -7;
        AllGuiTextures.JEI_LONG_ARROW.render(matrixStack, 52 + xOffset, 79);
        if (!singleOutput) {
            AllGuiTextures.JEI_CHANCE_SLOT.render(matrixStack, 150 + xOffset, 75);
            class_5250 component = Components.literal("?").method_27692(class_124.field_1067);
            font.method_30881(matrixStack, (class_2561)component, (float)(font.method_27525((class_5348)component) / -2 + 8 + 150 + xOffset), 80.0f, 0xEFEFEF);
        }
        if (recipe.getLoops() > 1) {
            matrixStack.method_22903();
            matrixStack.method_22904(15.0, 9.0, 0.0);
            AllIcons.I_SEQ_REPEAT.render(matrixStack, 50 + xOffset, 75);
            class_5250 repeat = Components.literal("x" + recipe.getLoops());
            font.method_30883(matrixStack, (class_2561)repeat, (float)(66 + xOffset), 80.0f, 0x888888);
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
        int width = 0;
        int margin = 3;
        for (SequencedRecipe<?> sequencedRecipe : recipe.getSequence()) {
            width += this.getSubCategory(sequencedRecipe).getWidth() + margin;
        }
        matrixStack.method_22904((double)((width -= margin) / -2 + this.getBackground().getWidth() / 2), 0.0, 0.0);
        matrixStack.method_22903();
        List<SequencedRecipe<?>> sequence = recipe.getSequence();
        for (int i = 0; i < sequence.size(); ++i) {
            SequencedRecipe<?> sequencedRecipe = sequence.get(i);
            JeiSequencedAssemblySubCategory subCategory = this.getSubCategory(sequencedRecipe);
            int subWidth = subCategory.getWidth();
            class_5250 component = Components.literal(this.romans[Math.min(i, 6)]);
            font.method_30883(matrixStack, (class_2561)component, (float)(font.method_27525((class_5348)component) / -2 + subWidth / 2), 2.0f, 0x888888);
            subCategory.draw(sequencedRecipe, matrixStack, mouseX, mouseY, i);
            matrixStack.method_22904((double)(subWidth + margin), 0.0, 0.0);
        }
        matrixStack.method_22909();
        matrixStack.method_22909();
    }

    @NotNull
    public List<class_2561> getTooltipStrings(SequencedAssemblyRecipe recipe, IRecipeSlotsView iRecipeSlotsView, double mouseX, double mouseY) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        class_5250 junk = Lang.translateDirect("recipe.assembly.junk", new Object[0]);
        boolean singleOutput = recipe.getOutputChance() == 1.0f;
        boolean willRepeat = recipe.getLoops() > 1;
        int xOffset = -7;
        int minX = 150 + xOffset;
        int maxX = minX + 18;
        int minY = 90;
        int maxY = minY + 18;
        if (!singleOutput && mouseX >= (double)minX && mouseX < (double)maxX && mouseY >= (double)minY && mouseY < (double)maxY) {
            float chance = recipe.getOutputChance();
            tooltip.add((class_2561)junk);
            tooltip.add((class_2561)this.chanceComponent(1.0f - chance));
            return tooltip;
        }
        minX = 55 + xOffset;
        maxX = minX + 65;
        minY = 92;
        maxY = minY + 24;
        if (willRepeat && mouseX >= (double)minX && mouseX < (double)maxX && mouseY >= (double)minY && mouseY < (double)maxY) {
            tooltip.add((class_2561)Lang.translateDirect("recipe.assembly.repeat", recipe.getLoops()));
            return tooltip;
        }
        if (mouseY > 5.0 && mouseY < 84.0) {
            int width = 0;
            int margin = 3;
            for (SequencedRecipe<?> sequencedRecipe : recipe.getSequence()) {
                width += this.getSubCategory(sequencedRecipe).getWidth() + margin;
            }
            xOffset = (width -= margin) / 2 + this.getBackground().getWidth() / -2;
            double relativeX = mouseX + (double)xOffset;
            List<SequencedRecipe<?>> sequence = recipe.getSequence();
            for (int i = 0; i < sequence.size(); ++i) {
                SequencedRecipe<?> sequencedRecipe = sequence.get(i);
                JeiSequencedAssemblySubCategory subCategory = this.getSubCategory(sequencedRecipe);
                if (relativeX >= 0.0 && relativeX < (double)subCategory.getWidth()) {
                    tooltip.add((class_2561)Lang.translateDirect("recipe.assembly.step", i + 1));
                    tooltip.add((class_2561)sequencedRecipe.getAsAssemblyRecipe().getDescriptionForAssembly().method_27662().method_27692(class_124.field_1077));
                    return tooltip;
                }
                relativeX -= (double)(subCategory.getWidth() + margin);
            }
        }
        return tooltip;
    }

    protected class_5250 chanceComponent(float chance) {
        String number = (double)chance < 0.01 ? "<1" : ((double)chance > 0.99 ? ">99" : String.valueOf(Math.round(chance * 100.0f)));
        return Lang.translateDirect("recipe.processing.chance", number).method_27692(class_124.field_1065);
    }
}

