/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.emi.recipes;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.compat.emi.CreateSlotWidget;
import com.simibubi.create.content.contraptions.processing.BasinRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextureWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public abstract class CreateEmiRecipe<T extends class_1860<?>>
implements EmiRecipe {
    protected final EmiRecipeCategory category;
    protected final T recipe;
    protected class_2960 id;
    protected List<EmiIngredient> input;
    protected List<EmiStack> output;
    protected boolean chanced;
    protected int width;
    protected int height;

    public CreateEmiRecipe(EmiRecipeCategory category, T recipe, int width, int height) {
        this.category = category;
        this.recipe = recipe;
        this.id = recipe.method_8114();
        this.width = width;
        this.height = height;
        if (recipe instanceof BasinRecipe) {
            BasinRecipe basin = (BasinRecipe)recipe;
            ImmutableList.Builder input = ImmutableList.builder();
            ImmutableList.Builder output = ImmutableList.builder();
            for (Pair<class_1856, MutableInt> pair : ItemHelper.condenseIngredients((class_2371<class_1856>)recipe.method_8117())) {
                input.add((Object)EmiIngredient.of((class_1856)pair.getFirst(), (long)pair.getSecond().getValue().intValue()));
            }
            for (FluidIngredient ingredient : basin.getFluidIngredients()) {
                input.add((Object)CreateEmiRecipe.fluidStack(ingredient.getMatchingFluidStacks().get(0)));
            }
            for (class_1799 stack : basin.getRollableResultsAsItemStacks()) {
                output.add((Object)EmiStack.of((class_1799)stack));
            }
            for (class_1799 stack : basin.getFluidResults()) {
                output.add((Object)CreateEmiRecipe.fluidStack((FluidStack)stack));
            }
            this.input = input.build();
            this.output = output.build();
        } else {
            this.input = recipe.method_8117().stream().map(EmiIngredient::of).toList();
            if (recipe instanceof ProcessingRecipe) {
                ProcessingRecipe processing = (ProcessingRecipe)recipe;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (ProcessingOutput output : processing.getRollableResults()) {
                    if (output.getChance() != 1.0f) {
                        this.chanced = true;
                    }
                    builder.add((Object)EmiStack.of((class_1799)output.getStack()));
                }
                this.output = builder.build();
            } else {
                this.output = List.of(EmiStack.of((class_1799)recipe.method_8110()));
            }
        }
    }

    public CreateEmiRecipe(EmiRecipeCategory category, T recipe, int width, int height, Consumer<CreateEmiRecipe<T>> setup) {
        this.category = category;
        this.recipe = recipe;
        this.id = recipe.method_8114();
        this.width = width;
        this.height = height;
        setup.accept(this);
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return this.width;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    public boolean supportsRecipeTree() {
        return !this.chanced && super.supportsRecipeTree();
    }

    public static SlotWidget addSlot(WidgetHolder widgets, EmiIngredient stack, int x, int y) {
        return CreateEmiRecipe.addSlot(widgets, stack, x, y, AllGuiTextures.JEI_SLOT);
    }

    public static SlotWidget addSlot(WidgetHolder widgets, EmiIngredient stack, int x, int y, AllGuiTextures texture) {
        return ((CreateSlotWidget)widgets.add((Widget)new CreateSlotWidget(stack, x, y))).backgroundTexture(texture.location, texture.startX, texture.startY);
    }

    public SlotWidget addChancedSlot(WidgetHolder widgets, EmiIngredient stack, int x, int y, float chance) {
        if (chance != 1.0f) {
            return CreateEmiRecipe.addSlot(widgets, stack, x, y, AllGuiTextures.JEI_CHANCE_SLOT).appendTooltip((class_2561)Lang.translateDirect("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).method_27692(class_124.field_1065));
        }
        return CreateEmiRecipe.addSlot(widgets, stack, x, y);
    }

    public SlotWidget addChancedSlot(WidgetHolder widgets, EmiIngredient stack, int x, int y, int index) {
        ProcessingRecipe processing;
        List<ProcessingOutput> results;
        T t = this.recipe;
        if (t instanceof ProcessingRecipe && index < (results = (processing = (ProcessingRecipe)t).getRollableResults()).size()) {
            return this.addChancedSlot(widgets, stack, x, y, results.get(index).getChance());
        }
        return CreateEmiRecipe.addSlot(widgets, stack, x, y);
    }

    public static EmiStack fluidStack(FluidStack stack) {
        return EmiStack.of((FluidVariant)stack.getType(), (long)stack.getAmount());
    }

    public static TextureWidget addTexture(WidgetHolder widgets, AllGuiTextures texture, int x, int y) {
        return widgets.addTexture(texture.location, x, y, texture.width, texture.height, texture.startX, texture.startY);
    }
}

