/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.emi;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.contraptions.components.deployer.DeployerBlock;
import com.simibubi.create.content.contraptions.components.saw.SawBlock;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.gui.CustomLightingSettings;
import com.simibubi.create.foundation.gui.ILightingSettings;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import dev.emi.emi.api.widget.WidgetHolder;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class CreateEmiAnimations {
    private static final class_2680 WHEEL = (class_2680)AllBlocks.CRUSHING_WHEEL.getDefaultState().method_11657((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11048);
    public static final ILightingSettings DEFAULT_LIGHTING = CustomLightingSettings.builder().firstLightRotation(12.5f, 45.0f).secondLightRotation(-20.0f, 50.0f).build();

    public static GuiGameElement.GuiRenderBuilder defaultBlockElement(class_2680 state) {
        return GuiGameElement.of(state).lighting(DEFAULT_LIGHTING);
    }

    public static GuiGameElement.GuiRenderBuilder defaultBlockElement(PartialModel partial) {
        return GuiGameElement.of(partial).lighting(DEFAULT_LIGHTING);
    }

    public static float getCurrentAngle() {
        return AnimationTickHolder.getRenderTime() * 4.0f % 360.0f;
    }

    public static class_2680 shaft(class_2350.class_2351 axis) {
        return (class_2680)AllBlocks.SHAFT.getDefaultState().method_11657((class_2769)class_2741.field_12496, (Comparable)axis);
    }

    public static PartialModel cogwheel() {
        return AllBlockPartials.SHAFTLESS_COGWHEEL;
    }

    public static GuiGameElement.GuiRenderBuilder blockElement(class_2680 state) {
        return CreateEmiAnimations.defaultBlockElement(state);
    }

    public static GuiGameElement.GuiRenderBuilder blockElement(PartialModel partial) {
        return CreateEmiAnimations.defaultBlockElement(partial);
    }

    public static void addPress(WidgetHolder widgets, int x, int y, boolean basin) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> CreateEmiAnimations.renderPress(matrices, 0, basin));
    }

    public static void renderPress(class_4587 matrices, int offset, boolean basin) {
        matrices.method_22904(0.0, 0.0, 200.0);
        matrices.method_22907(class_1160.field_20703.method_23214(-15.5f));
        matrices.method_22907(class_1160.field_20705.method_23214(22.5f));
        int scale = basin ? 23 : 24;
        CreateEmiAnimations.blockElement(CreateEmiAnimations.shaft(class_2350.class_2351.field_11051)).rotateBlock(0.0, 0.0, CreateEmiAnimations.getCurrentAngle()).scale(scale).render(matrices);
        CreateEmiAnimations.blockElement(AllBlocks.MECHANICAL_PRESS.getDefaultState()).scale(scale).render(matrices);
        CreateEmiAnimations.blockElement(AllBlockPartials.MECHANICAL_PRESS_HEAD).atLocal(0.0, -CreateEmiAnimations.getAnimatedHeadOffset(offset), 0.0).scale(scale).render(matrices);
        if (basin) {
            CreateEmiAnimations.blockElement(AllBlocks.BASIN.getDefaultState()).atLocal(0.0, 1.65, 0.0).scale(scale).render(matrices);
        }
    }

    private static float getAnimatedHeadOffset(int offset) {
        float cycle = (AnimationTickHolder.getRenderTime() - (float)(offset * 8)) % 30.0f;
        if (cycle < 10.0f) {
            float progress = cycle / 10.0f;
            return -(progress * progress * progress);
        }
        if (cycle < 15.0f) {
            return -1.0f;
        }
        if (cycle < 20.0f) {
            return -1.0f + (1.0f - (20.0f - cycle) / 5.0f);
        }
        return 0.0f;
    }

    public static void addBlazeBurner(WidgetHolder widgets, int x, int y, BlazeBurnerBlock.HeatLevel heatLevel) {
        widgets.addDrawable(x, y, 0, 0, (matrixStack, mouseX, mouseY, delta) -> {
            matrixStack.method_22904(0.0, 0.0, 200.0);
            matrixStack.method_22907(class_1160.field_20703.method_23214(-15.5f));
            matrixStack.method_22907(class_1160.field_20705.method_23214(22.5f));
            int scale = 23;
            float offset = (class_3532.method_15374((float)(AnimationTickHolder.getRenderTime() / 16.0f)) + 0.5f) / 16.0f;
            CreateEmiAnimations.blockElement(AllBlocks.BLAZE_BURNER.getDefaultState()).atLocal(0.0, 1.65, 0.0).scale(scale).render(matrixStack);
            PartialModel blaze = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllBlockPartials.BLAZE_SUPER : AllBlockPartials.BLAZE_ACTIVE;
            PartialModel rods2 = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllBlockPartials.BLAZE_BURNER_SUPER_RODS_2 : AllBlockPartials.BLAZE_BURNER_RODS_2;
            CreateEmiAnimations.blockElement(blaze).atLocal(1.0, 1.8, 1.0).rotate(0.0, 180.0, 0.0).scale(scale).render(matrixStack);
            CreateEmiAnimations.blockElement(rods2).atLocal(1.0, 1.7 + (double)offset, 1.0).rotate(0.0, 180.0, 0.0).scale(scale).render(matrixStack);
            matrixStack.method_22905((float)scale, (float)(-scale), (float)scale);
            matrixStack.method_22904(0.0, -1.8, 0.0);
            SpriteShiftEntry spriteShift = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;
            float spriteWidth = spriteShift.getTarget().method_4577() - spriteShift.getTarget().method_4594();
            float spriteHeight = spriteShift.getTarget().method_4575() - spriteShift.getTarget().method_4593();
            float time = AnimationTickHolder.getRenderTime((class_1936)class_310.method_1551().field_1687);
            float speed = 0.03125f + 0.015625f * (float)heatLevel.ordinal();
            double vScroll = speed * time;
            vScroll -= Math.floor(vScroll);
            vScroll = vScroll * (double)spriteHeight / 2.0;
            double uScroll = speed * time / 2.0f;
            uScroll -= Math.floor(uScroll);
            uScroll = uScroll * (double)spriteWidth / 2.0;
            class_310 mc = class_310.method_1551();
            class_4597.class_4598 buffer = mc.method_22940().method_23000();
            class_4588 vb = buffer.getBuffer(class_1921.method_23579());
            CachedBufferer.partial(AllBlockPartials.BLAZE_BURNER_FLAME, class_2246.field_10124.method_9564()).shiftUVScrolling(spriteShift, (float)uScroll, (float)vScroll).light(0xF000F0).renderInto(matrixStack, vb);
        });
    }

    public static void addMixer(WidgetHolder widgets, int x, int y) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> {
            matrices.method_22904(0.0, 0.0, 200.0);
            matrices.method_22907(class_1160.field_20703.method_23214(-15.5f));
            matrices.method_22907(class_1160.field_20705.method_23214(22.5f));
            int scale = 23;
            CreateEmiAnimations.blockElement(CreateEmiAnimations.cogwheel()).rotateBlock(0.0, CreateEmiAnimations.getCurrentAngle() * 2.0f, 0.0).atLocal(0.0, 0.0, 0.0).scale(scale).render(matrices);
            CreateEmiAnimations.blockElement(AllBlocks.MECHANICAL_MIXER.getDefaultState()).atLocal(0.0, 0.0, 0.0).scale(scale).render(matrices);
            float animation = (class_3532.method_15374((float)(AnimationTickHolder.getRenderTime() / 32.0f)) + 1.0f) / 5.0f + 0.5f;
            CreateEmiAnimations.blockElement(AllBlockPartials.MECHANICAL_MIXER_POLE).atLocal(0.0, animation, 0.0).scale(scale).render(matrices);
            CreateEmiAnimations.blockElement(AllBlockPartials.MECHANICAL_MIXER_HEAD).rotateBlock(0.0, CreateEmiAnimations.getCurrentAngle() * 4.0f, 0.0).atLocal(0.0, animation, 0.0).scale(scale).render(matrices);
            CreateEmiAnimations.blockElement(AllBlocks.BASIN.getDefaultState()).atLocal(0.0, 1.65, 0.0).scale(scale).render(matrices);
        });
    }

    public static void addSaw(WidgetHolder widgets, int x, int y) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> CreateEmiAnimations.renderSaw(matrices, 0));
    }

    public static void renderSaw(class_4587 matrices, int offset) {
        matrices.method_22904(0.0, 0.0, 200.0);
        matrices.method_22904(2.0, 22.0, 0.0);
        matrices.method_22907(class_1160.field_20703.method_23214(-15.5f));
        matrices.method_22907(class_1160.field_20705.method_23214(112.5f));
        int scale = 25;
        CreateEmiAnimations.blockElement(CreateEmiAnimations.shaft(class_2350.class_2351.field_11048)).rotateBlock(-CreateEmiAnimations.getCurrentAngle(), 0.0, 0.0).scale(scale).render(matrices);
        CreateEmiAnimations.blockElement((class_2680)AllBlocks.MECHANICAL_SAW.getDefaultState().method_11657((class_2769)SawBlock.FACING, (Comparable)class_2350.field_11036)).rotateBlock(0.0, 0.0, 0.0).scale(scale).render(matrices);
        CreateEmiAnimations.blockElement(AllBlockPartials.SAW_BLADE_VERTICAL_ACTIVE).rotateBlock(0.0, -90.0, -90.0).scale(scale).render(matrices);
    }

    public static void addMillstone(WidgetHolder widgets, int x, int y) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> {
            int scale = 22;
            CreateEmiAnimations.blockElement(AllBlockPartials.MILLSTONE_COG).rotateBlock(22.5, CreateEmiAnimations.getCurrentAngle() * 2.0f, 0.0).scale(scale).render(matrices);
            CreateEmiAnimations.blockElement(AllBlocks.MILLSTONE.getDefaultState()).rotateBlock(22.5, 22.5, 0.0).scale(scale).render(matrices);
        });
    }

    public static void addCrushingWheels(WidgetHolder widgets, int x, int y) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> {
            matrices.method_22904(0.0, 0.0, 100.0);
            matrices.method_22907(class_1160.field_20705.method_23214(-22.5f));
            int scale = 22;
            CreateEmiAnimations.blockElement(WHEEL).rotateBlock(0.0, 90.0, -CreateEmiAnimations.getCurrentAngle()).scale(scale).render(matrices);
            CreateEmiAnimations.blockElement(WHEEL).rotateBlock(0.0, 90.0, CreateEmiAnimations.getCurrentAngle()).atLocal(2.0, 0.0, 0.0).scale(scale).render(matrices);
        });
    }

    public static void addFan(WidgetHolder widgets, int x, int y, Consumer<class_4587> renderAttachedBlock) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> {
            matrices.method_22904(0.0, 0.0, 200.0);
            matrices.method_22907(class_1160.field_20703.method_23214(-12.5f));
            matrices.method_22907(class_1160.field_20705.method_23214(22.5f));
            int scale = 24;
            CreateEmiAnimations.defaultBlockElement(AllBlockPartials.ENCASED_FAN_INNER).rotateBlock(180.0, 0.0, CreateEmiAnimations.getCurrentAngle() * 16.0f).scale(scale).render(matrices);
            CreateEmiAnimations.defaultBlockElement(AllBlocks.ENCASED_FAN.getDefaultState()).rotateBlock(0.0, 180.0, 0.0).atLocal(0.0, 0.0, 0.0).scale(scale).render(matrices);
            renderAttachedBlock.accept(matrices);
        });
    }

    public static void addDeployer(WidgetHolder widgets, int x, int y) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> CreateEmiAnimations.renderDeployer(matrices, 0));
    }

    public static void renderDeployer(class_4587 matrices, int offset) {
        matrices.method_22904(0.0, 0.0, 100.0);
        matrices.method_22907(class_1160.field_20703.method_23214(-15.5f));
        matrices.method_22907(class_1160.field_20705.method_23214(22.5f));
        int scale = 20;
        CreateEmiAnimations.blockElement(CreateEmiAnimations.shaft(class_2350.class_2351.field_11051)).rotateBlock(0.0, 0.0, CreateEmiAnimations.getCurrentAngle()).scale(scale).render(matrices);
        CreateEmiAnimations.blockElement((class_2680)((class_2680)AllBlocks.DEPLOYER.getDefaultState().method_11657((class_2769)DeployerBlock.FACING, (Comparable)class_2350.field_11033)).method_11657((class_2769)DeployerBlock.AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(false))).scale(scale).render(matrices);
        float cycle = (AnimationTickHolder.getRenderTime() - (float)(offset * 8)) % 30.0f;
        float off = cycle < 10.0f ? cycle / 10.0f : (cycle < 20.0f ? (20.0f - cycle) / 10.0f : 0.0f);
        matrices.method_22903();
        matrices.method_22904(0.0, (double)(off * 17.0f), 0.0);
        CreateEmiAnimations.blockElement(AllBlockPartials.DEPLOYER_POLE).rotateBlock(90.0, 0.0, 0.0).scale(scale).render(matrices);
        CreateEmiAnimations.blockElement(AllBlockPartials.DEPLOYER_HAND_HOLDING).rotateBlock(90.0, 0.0, 0.0).scale(scale).render(matrices);
        matrices.method_22909();
        CreateEmiAnimations.blockElement(AllBlocks.DEPOT.getDefaultState()).atLocal(0.0, 2.0, 0.0).scale(scale).render(matrices);
    }

    public static void addSpout(WidgetHolder widgets, int x, int y, List<FluidStack> fluids) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> CreateEmiAnimations.renderSpout(matrices, 0, fluids));
    }

    public static void renderSpout(class_4587 matrices, int offset, List<FluidStack> fluids) {
        matrices.method_22904(0.0, 0.0, 100.0);
        matrices.method_22907(class_1160.field_20703.method_23214(-15.5f));
        matrices.method_22907(class_1160.field_20705.method_23214(22.5f));
        int scale = 20;
        CreateEmiAnimations.blockElement(AllBlocks.SPOUT.getDefaultState()).scale(scale).render(matrices);
        float cycle = (AnimationTickHolder.getRenderTime() - (float)(offset * 8)) % 30.0f;
        float squeeze = cycle < 20.0f ? class_3532.method_15374((float)((float)((double)(cycle / 20.0f) * Math.PI))) : 0.0f;
        matrices.method_22903();
        CreateEmiAnimations.blockElement(AllBlockPartials.SPOUT_TOP).scale(scale).render(matrices);
        matrices.method_22904(0.0, (double)(-3.0f * (squeeze *= 20.0f) / 32.0f), 0.0);
        CreateEmiAnimations.blockElement(AllBlockPartials.SPOUT_MIDDLE).scale(scale).render(matrices);
        matrices.method_22904(0.0, (double)(-3.0f * squeeze / 32.0f), 0.0);
        CreateEmiAnimations.blockElement(AllBlockPartials.SPOUT_BOTTOM).scale(scale).render(matrices);
        matrices.method_22904(0.0, (double)(-3.0f * squeeze / 32.0f), 0.0);
        matrices.method_22909();
        CreateEmiAnimations.blockElement(AllBlocks.DEPOT.getDefaultState()).atLocal(0.0, 2.0, 0.0).scale(scale).render(matrices);
        DEFAULT_LIGHTING.applyLighting();
        class_4597.class_4598 buffer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        matrices.method_22903();
        UIRenderHelper.flipForGuiRender(matrices);
        matrices.method_22905(16.0f, 16.0f, 16.0f);
        float from = 0.1875f;
        float to = 1.0625f;
        FluidRenderer.renderFluidBox(fluids.get(0), from, from, from, to, to, to, (class_4597)buffer, matrices, 0xF000F0, false);
        matrices.method_22909();
        float width = 0.0078125f * squeeze;
        matrices.method_22904((double)((float)scale / 2.0f), (double)((float)scale * 1.5f), (double)((float)scale / 2.0f));
        UIRenderHelper.flipForGuiRender(matrices);
        matrices.method_22905(16.0f, 16.0f, 16.0f);
        matrices.method_22904(-0.5, 0.0, -0.5);
        from = -width / 2.0f + 0.5f;
        to = width / 2.0f + 0.5f;
        FluidRenderer.renderFluidBox(fluids.get(0), from, 0.0f, from, to, 2.0f, to, (class_4597)buffer, matrices, 0xF000F0, false);
        buffer.method_22993();
        class_308.method_24211();
    }

    public static void addDrain(WidgetHolder widgets, int x, int y, FluidStack fluid) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> {
            matrices.method_22904(0.0, 0.0, 100.0);
            matrices.method_22907(class_1160.field_20703.method_23214(-15.5f));
            matrices.method_22907(class_1160.field_20705.method_23214(22.5f));
            int scale = 20;
            CreateEmiAnimations.blockElement(AllBlocks.ITEM_DRAIN.getDefaultState()).scale(scale).render(matrices);
            class_4597.class_4598 buffer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            UIRenderHelper.flipForGuiRender(matrices);
            matrices.method_22905((float)scale, (float)scale, (float)scale);
            float from = 0.125f;
            float to = 1.0f - from;
            FluidRenderer.renderFluidBox(fluid, from, from, from, to, 0.75f, to, (class_4597)buffer, matrices, 0xF000F0, false);
            buffer.method_22993();
        });
    }

    public static void addCrafter(WidgetHolder widgets, int x, int y) {
        widgets.addDrawable(x, y, 0, 0, (matrices, mouseX, mouseY, delta) -> {
            matrices.method_22907(class_1160.field_20703.method_23214(-15.5f));
            matrices.method_22907(class_1160.field_20705.method_23214(-22.5f));
            int scale = 22;
            CreateEmiAnimations.blockElement(CreateEmiAnimations.cogwheel()).rotateBlock(90.0, 0.0, CreateEmiAnimations.getCurrentAngle()).scale(scale).render(matrices);
            CreateEmiAnimations.blockElement(AllBlocks.MECHANICAL_CRAFTER.getDefaultState()).rotateBlock(0.0, 180.0, 0.0).scale(scale).render(matrices);
        });
    }
}

