/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.connectivity;

import com.simibubi.create.content.contraptions.fluids.tank.CreativeFluidTankTileEntity;
import com.simibubi.create.foundation.tileEntity.IMultiTileContainer;
import com.simibubi.create.foundation.utility.Iterate;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.apache.commons.lang3.tuple.Pair;

public class ConnectivityHandler {
    public static <T extends class_2586> void formMulti(T be) {
        SearchCache cache = new SearchCache();
        ArrayList<T> frontier = new ArrayList<T>();
        frontier.add(be);
        ConnectivityHandler.formMulti(be.method_11017(), (class_1922)be.method_10997(), cache, frontier);
    }

    private static <T extends class_2586> void formMulti(class_2591<?> type, class_1922 level, SearchCache<T> cache, List<T> frontier) {
        PriorityQueue<Pair<Integer, T>> creationQueue = ConnectivityHandler.makeCreationQueue();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        class_2350.class_2351 mainAxis = ((IMultiTileContainer)((class_2586)frontier.get(0))).getMainConnectionAxis();
        int minX = mainAxis == class_2350.class_2351.field_11052 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int minY = mainAxis != class_2350.class_2351.field_11052 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int minZ = mainAxis == class_2350.class_2351.field_11052 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        for (class_2586 be : frontier) {
            class_2338 pos = be.method_11016();
            minX = Math.min(pos.method_10263(), minX);
            minY = Math.min(pos.method_10264(), minY);
            minZ = Math.min(pos.method_10260(), minZ);
        }
        if (mainAxis == class_2350.class_2351.field_11052) {
            minX -= ((IMultiTileContainer)((class_2586)frontier.get(0))).getMaxWidth();
        }
        if (mainAxis != class_2350.class_2351.field_11052) {
            minY -= ((IMultiTileContainer)((class_2586)frontier.get(0))).getMaxWidth();
        }
        if (mainAxis == class_2350.class_2351.field_11052) {
            minZ -= ((IMultiTileContainer)((class_2586)frontier.get(0))).getMaxWidth();
        }
        while (!frontier.isEmpty()) {
            class_2586 part = (class_2586)frontier.remove(0);
            class_2338 partPos = part.method_11016();
            if (visited.contains(partPos)) continue;
            visited.add(partPos);
            int amount = ConnectivityHandler.tryToFormNewMulti(part, cache, true);
            if (amount > 1) {
                creationQueue.add(Pair.of((Object)amount, (Object)part));
            }
            for (class_2350.class_2351 axis : Iterate.axes) {
                T nextBe;
                class_2350 dir = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11060, (class_2350.class_2351)axis);
                class_2338 next = partPos.method_10093(dir);
                if (next.method_10263() <= minX || next.method_10264() <= minY || next.method_10260() <= minZ || visited.contains(next) || (nextBe = ConnectivityHandler.partAt(type, level, next)) == null || nextBe.method_11015()) continue;
                frontier.add(nextBe);
            }
        }
        visited.clear();
        while (!creationQueue.isEmpty()) {
            Pair<Integer, T> next = creationQueue.poll();
            class_2586 toCreate = (class_2586)next.getValue();
            if (visited.contains(toCreate.method_11016())) continue;
            visited.add(toCreate.method_11016());
            ConnectivityHandler.tryToFormNewMulti(toCreate, cache, false);
        }
    }

    private static <T extends class_2586> int tryToFormNewMulti(T be, SearchCache<T> cache, boolean simulate) {
        int bestWidth = 1;
        int bestAmount = -1;
        if (!((IMultiTileContainer)be).isController()) {
            return 0;
        }
        int radius = ((IMultiTileContainer)be).getMaxWidth();
        for (int w = 1; w <= radius; ++w) {
            int amount = ConnectivityHandler.tryToFormNewMultiOfWidth(be, w, cache, true);
            if (amount < bestAmount) continue;
            bestWidth = w;
            bestAmount = amount;
        }
        if (!simulate) {
            IMultiTileContainer.Fluid ifluid;
            int beWidth = ((IMultiTileContainer)be).getWidth();
            if (beWidth == bestWidth && beWidth * beWidth * ((IMultiTileContainer)be).getHeight() == bestAmount) {
                return bestAmount;
            }
            ConnectivityHandler.splitMultiAndInvalidate(be, cache, false);
            if (be instanceof IMultiTileContainer.Fluid && (ifluid = (IMultiTileContainer.Fluid)be).hasTank()) {
                ifluid.setTankSize(0, bestAmount);
            }
            ConnectivityHandler.tryToFormNewMultiOfWidth(be, bestWidth, cache, false);
            ((IMultiTileContainer)be).preventConnectivityUpdate();
            ((IMultiTileContainer)be).setWidth(bestWidth);
            ((IMultiTileContainer)be).setHeight(bestAmount / bestWidth / bestWidth);
            ((IMultiTileContainer)be).notifyMultiUpdated();
        }
        return bestAmount;
    }

    private static <T extends class_2586> int tryToFormNewMultiOfWidth(T be, int width, SearchCache<T> cache, boolean simulate) {
        IMultiTileContainer.Fluid ifluid;
        int amount = 0;
        int height = 0;
        class_2591 type = be.method_11017();
        class_1937 level = be.method_10997();
        if (level == null) {
            return 0;
        }
        class_2338 origin = be.method_11016();
        FluidTank beTank = null;
        FluidStack fluid = FluidStack.EMPTY;
        if (be instanceof IMultiTileContainer.Fluid && (ifluid = (IMultiTileContainer.Fluid)be).hasTank()) {
            beTank = ifluid.getTank(0);
            fluid = beTank.getFluid();
        }
        class_2350.class_2351 axis = ((IMultiTileContainer)be).getMainConnectionAxis();
        block10: for (int yOffset = 0; yOffset < ((IMultiTileContainer)be).getMaxLength(axis, width); ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    IMultiTileContainer.Fluid ifluidCon;
                    class_2338 conPos;
                    class_2350.class_2351 conAxis;
                    class_2586 controller;
                    int otherWidth;
                    class_2338 pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case class_2350.class_2351.field_11048 -> origin.method_10069(yOffset, xOffset, zOffset);
                        case class_2350.class_2351.field_11052 -> origin.method_10069(xOffset, yOffset, zOffset);
                        case class_2350.class_2351.field_11051 -> origin.method_10069(xOffset, zOffset, yOffset);
                    };
                    Optional<T> part = cache.getOrCache(type, (class_1922)level, pos);
                    if (part.isEmpty() || (otherWidth = ((IMultiTileContainer)(controller = (class_2586)part.get())).getWidth()) > width || otherWidth == width && ((IMultiTileContainer)controller).getHeight() == ((IMultiTileContainer)be).getMaxLength(axis, width) || axis != (conAxis = ((IMultiTileContainer)controller).getMainConnectionAxis()) || !(conPos = controller.method_11016()).equals((Object)origin) && (axis != class_2350.class_2351.field_11052 ? axis == class_2350.class_2351.field_11051 && conPos.method_10263() < origin.method_10263() || conPos.method_10264() < origin.method_10264() || axis == class_2350.class_2351.field_11048 && conPos.method_10260() < origin.method_10260() || axis == class_2350.class_2351.field_11051 && conPos.method_10263() + otherWidth > origin.method_10263() + width || conPos.method_10264() + otherWidth > origin.method_10264() + width || axis == class_2350.class_2351.field_11048 && conPos.method_10260() + otherWidth > origin.method_10260() + width : conPos.method_10263() < origin.method_10263() || conPos.method_10260() < origin.method_10260() || conPos.method_10263() + otherWidth > origin.method_10263() + width || conPos.method_10260() + otherWidth > origin.method_10260() + width)) break block10;
                    if (!(controller instanceof IMultiTileContainer.Fluid) || !(ifluidCon = (IMultiTileContainer.Fluid)controller).hasTank()) continue;
                    FluidStack otherFluid = ifluidCon.getFluid(0);
                    if (!fluid.isEmpty() && !otherFluid.isEmpty() && !fluid.isFluidEqual(otherFluid)) break block10;
                }
            }
            amount += width * width;
            ++height;
        }
        if (simulate) {
            return amount;
        }
        Object extraData = ((IMultiTileContainer)be).getExtraData();
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    IMultiTileContainer.Fluid ifluidPart;
                    class_2338 pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case class_2350.class_2351.field_11048 -> origin.method_10069(yOffset, xOffset, zOffset);
                        case class_2350.class_2351.field_11052 -> origin.method_10069(xOffset, yOffset, zOffset);
                        case class_2350.class_2351.field_11051 -> origin.method_10069(xOffset, zOffset, yOffset);
                    };
                    T part = ConnectivityHandler.partAt(type, (class_1922)level, pos);
                    if (part == null || part == be) continue;
                    extraData = ((IMultiTileContainer)be).modifyExtraData(extraData);
                    if (part instanceof IMultiTileContainer.Fluid && (ifluidPart = (IMultiTileContainer.Fluid)part).hasTank()) {
                        FluidTank tankAt = ifluidPart.getTank(0);
                        FluidStack fluidAt = tankAt.getFluid();
                        if (!fluidAt.isEmpty()) {
                            IMultiTileContainer.Fluid ifluidBE;
                            if (beTank != null && fluid.isEmpty() && beTank instanceof CreativeFluidTankTileEntity.CreativeSmartFluidTank) {
                                ((CreativeFluidTankTileEntity.CreativeSmartFluidTank)beTank).setContainedFluid(fluidAt);
                            }
                            if (be instanceof IMultiTileContainer.Fluid && (ifluidBE = (IMultiTileContainer.Fluid)be).hasTank() && beTank != null) {
                                TransferUtil.insertFluid((Storage)beTank, (FluidStack)fluidAt);
                            }
                        }
                        TransferUtil.clearStorage((Storage)tankAt);
                    }
                    ConnectivityHandler.splitMultiAndInvalidate(part, cache, false);
                    ((IMultiTileContainer)part).setController(origin);
                    ((IMultiTileContainer)part).preventConnectivityUpdate();
                    cache.put(pos, be);
                    ((IMultiTileContainer)part).setHeight(height);
                    ((IMultiTileContainer)part).setWidth(width);
                    ((IMultiTileContainer)part).notifyMultiUpdated();
                }
            }
        }
        ((IMultiTileContainer)be).setExtraData(extraData);
        ((IMultiTileContainer)be).notifyMultiUpdated();
        return amount;
    }

    public static <T extends class_2586> void splitMulti(T be) {
        ConnectivityHandler.splitMultiAndInvalidate(be, null, false);
    }

    private static <T extends class_2586> void splitMultiAndInvalidate(T be, @Nullable SearchCache<T> cache, boolean tryReconnect) {
        IMultiTileContainer.Fluid ifluidBE;
        class_1937 level = be.method_10997();
        if (level == null) {
            return;
        }
        if ((be = ((IMultiTileContainer)be).getControllerTE()) == null) {
            return;
        }
        int height = ((IMultiTileContainer)be).getHeight();
        int width = ((IMultiTileContainer)be).getWidth();
        if (width == 1 && height == 1) {
            return;
        }
        class_2338 origin = be.method_11016();
        ArrayList<T> frontier = new ArrayList<T>();
        class_2350.class_2351 axis = ((IMultiTileContainer)be).getMainConnectionAxis();
        FluidStack toDistribute = FluidStack.EMPTY;
        long maxCapacity = 0L;
        if (be instanceof IMultiTileContainer.Fluid && (ifluidBE = (IMultiTileContainer.Fluid)be).hasTank()) {
            toDistribute = ifluidBE.getFluid(0);
            maxCapacity = ifluidBE.getTankSize(0);
            if (!toDistribute.isEmpty() && !be.method_11015()) {
                toDistribute.shrink(maxCapacity);
            }
            ifluidBE.setTankSize(0, 1);
        }
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    class_2338 pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case class_2350.class_2351.field_11048 -> origin.method_10069(yOffset, xOffset, zOffset);
                        case class_2350.class_2351.field_11052 -> origin.method_10069(xOffset, yOffset, zOffset);
                        case class_2350.class_2351.field_11051 -> origin.method_10069(xOffset, zOffset, yOffset);
                    };
                    T partAt = ConnectivityHandler.partAt(be.method_11017(), (class_1922)level, pos);
                    if (partAt == null || !((IMultiTileContainer)partAt).getController().equals((Object)origin)) continue;
                    Object controllerBE = ((IMultiTileContainer)partAt).getControllerTE();
                    ((IMultiTileContainer)partAt).setExtraData(controllerBE == null ? null : ((IMultiTileContainer)controllerBE).getExtraData());
                    ((IMultiTileContainer)partAt).removeController(true);
                    if (!toDistribute.isEmpty() && partAt != be) {
                        FluidTank tank;
                        FluidStack copy = toDistribute.copy();
                        if (partAt instanceof IMultiTileContainer.Fluid) {
                            IMultiTileContainer.Fluid ifluidPart = (IMultiTileContainer.Fluid)partAt;
                            v1 = ifluidPart.getTank(0);
                        } else {
                            v1 = tank = null;
                        }
                        if (tank instanceof CreativeFluidTankTileEntity.CreativeSmartFluidTank) {
                            CreativeFluidTankTileEntity.CreativeSmartFluidTank creativeTank = (CreativeFluidTankTileEntity.CreativeSmartFluidTank)tank;
                            if (creativeTank.isEmpty()) {
                                creativeTank.setContainedFluid(toDistribute);
                            }
                        } else {
                            long split = Math.min(maxCapacity, toDistribute.getAmount());
                            copy.setAmount(split);
                            toDistribute.shrink(split);
                            if (tank != null) {
                                TransferUtil.insertFluid((Storage)tank, (FluidStack)copy);
                            }
                        }
                    }
                    if (tryReconnect) {
                        frontier.add(partAt);
                        ((IMultiTileContainer)partAt).preventConnectivityUpdate();
                    }
                    if (cache == null) continue;
                    cache.put(pos, partAt);
                }
            }
        }
        if (tryReconnect) {
            ConnectivityHandler.formMulti(be.method_11017(), (class_1922)level, cache == null ? new SearchCache<T>() : cache, frontier);
        }
    }

    private static <T extends class_2586> PriorityQueue<Pair<Integer, T>> makeCreationQueue() {
        return new PriorityQueue<Pair<Integer, T>>((one, two) -> (Integer)two.getKey() - (Integer)one.getKey());
    }

    @Nullable
    public static <T extends class_2586> T partAt(class_2591<?> type, class_1922 level, class_2338 pos) {
        class_2586 be = level.method_8321(pos);
        if (be != null && be.method_11017() == type && !be.method_11015()) {
            return ConnectivityHandler.checked(be);
        }
        return null;
    }

    public static <T extends class_2586> boolean isConnected(class_1922 level, class_2338 pos, class_2338 other) {
        T one = ConnectivityHandler.checked(level.method_8321(pos));
        T two = ConnectivityHandler.checked(level.method_8321(other));
        if (one == null || two == null) {
            return false;
        }
        return ((IMultiTileContainer)one).getController().equals((Object)((IMultiTileContainer)two).getController());
    }

    @Nullable
    private static <T extends class_2586> T checked(class_2586 be) {
        if (be instanceof IMultiTileContainer) {
            return (T)be;
        }
        return null;
    }

    private static class SearchCache<T extends class_2586> {
        Map<class_2338, Optional<T>> controllerMap = new HashMap<class_2338, Optional<T>>();

        void put(class_2338 pos, T target) {
            this.controllerMap.put(pos, Optional.of(target));
        }

        void putEmpty(class_2338 pos) {
            this.controllerMap.put(pos, Optional.empty());
        }

        boolean hasVisited(class_2338 pos) {
            return this.controllerMap.containsKey(pos);
        }

        Optional<T> getOrCache(class_2591<?> type, class_1922 level, class_2338 pos) {
            if (this.hasVisited(pos)) {
                return this.controllerMap.get(pos);
            }
            Object partAt = ConnectivityHandler.partAt(type, level, pos);
            if (partAt == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            Object controller = ConnectivityHandler.checked(level.method_8321(((IMultiTileContainer)partAt).getController()));
            if (controller == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            this.put(pos, controller);
            return Optional.of(controller);
        }
    }
}

