/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.utils;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1438;
import net.minecraft.class_1439;
import net.minecraft.class_1440;
import net.minecraft.class_1451;
import net.minecraft.class_1472;
import net.minecraft.class_1474;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1560;
import net.minecraft.class_1577;
import net.minecraft.class_1590;
import net.minecraft.class_1593;
import net.minecraft.class_1606;
import net.minecraft.class_1617;
import net.minecraft.class_1621;
import net.minecraft.class_1632;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6053;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.mixin.accessor.MooshroomEntityAccessor;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public abstract class ETFTexturePropertiesUtils {
    public static void processNewOptifinePropertiesFile(class_1297 entity, class_2960 vanillaIdentifier, class_2960 properties) {
        block30: {
            ETFManager manager = ETFManager.getInstance();
            try {
                Properties props = ETFUtils2.readAndReturnPropertiesElseNull(properties);
                if (props != null) {
                    if (props.containsKey("vanillaBrightnessOverride")) {
                        int tryNumber;
                        String value = props.getProperty("vanillaBrightnessOverride").trim();
                        try {
                            tryNumber = Integer.parseInt(value.replaceAll("\\D", ""));
                        }
                        catch (NumberFormatException e) {
                            tryNumber = 0;
                        }
                        if (tryNumber >= 16) {
                            tryNumber = 15;
                        }
                        if (tryNumber < 0) {
                            tryNumber = 0;
                        }
                        manager.ENTITY_TYPE_VANILLA_BRIGHTNESS_OVERRIDE_VALUE.put((Object)entity.method_5864(), tryNumber);
                    }
                    if (entity instanceof class_1590 && props.containsKey("showHiddenModelParts") && "true".equals(props.getProperty("showHiddenModelParts"))) {
                        manager.zombiePiglinRightEarEnabled = true;
                    }
                    if (props.containsKey("suppressParticles") && "true".equals(props.getProperty("suppressParticles"))) {
                        manager.ENTITY_TYPE_IGNORE_PARTICLES.add((Object)entity.method_5864());
                    }
                    if (props.containsKey("entityRenderLayerOverride")) {
                        String layer;
                        switch (layer = props.getProperty("entityRenderLayerOverride")) {
                            case "translucent": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put((Object)entity.method_5864(), 1);
                                break;
                            }
                            case "translucent_cull": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put((Object)entity.method_5864(), 2);
                                break;
                            }
                            case "end_portal": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put((Object)entity.method_5864(), 3);
                                break;
                            }
                            case "outline": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put((Object)entity.method_5864(), 4);
                            }
                        }
                    }
                    Set<String> propIds = props.stringPropertyNames();
                    HashSet<Integer> numbers = new HashSet<Integer>();
                    for (String str : propIds) {
                        if ((str = str.replaceAll("\\D", "")).isEmpty()) continue;
                        try {
                            numbers.add(Integer.parseInt(str));
                        }
                        catch (NumberFormatException e) {
                            ETFUtils2.logWarn("properties file number error in start count");
                        }
                    }
                    ArrayList numbersList = new ArrayList(numbers);
                    Collections.sort(numbersList);
                    ArrayList<ETFTexturePropertyCase> allCasesForTexture = new ArrayList<ETFTexturePropertyCase>();
                    for (Integer num : numbersList) {
                        Integer[] suffixes = ETFTexturePropertiesUtils.getSuffixes(props, num);
                        if (suffixes != null && suffixes.length != 0) {
                            allCasesForTexture.add(new ETFTexturePropertyCase(suffixes, ETFTexturePropertiesUtils.getWeights(props, num), ETFTexturePropertiesUtils.getBiomes(props, num), ETFTexturePropertiesUtils.getHeights(props, num), ETFTexturePropertiesUtils.getNames(props, num), ETFTexturePropertiesUtils.getProfessions(props, num), ETFTexturePropertiesUtils.getColors(props, num), ETFTexturePropertiesUtils.getBaby(props, num), ETFTexturePropertiesUtils.getWeather(props, num), ETFTexturePropertiesUtils.getHealth(props, num), ETFTexturePropertiesUtils.getMoon(props, num), ETFTexturePropertiesUtils.getDayTime(props, num), ETFTexturePropertiesUtils.getBlocks(props, num), ETFTexturePropertiesUtils.getTeams(props, num), ETFTexturePropertiesUtils.getSizes(props, num), ETFTexturePropertiesUtils.getSpeed(props, num), ETFTexturePropertiesUtils.getJump(props, num), ETFTexturePropertiesUtils.getMaxHealth(props, num), ETFTexturePropertiesUtils.getLlamaInv(props, num), ETFTexturePropertiesUtils.getAngry(props, num), ETFTexturePropertiesUtils.getHiddenGene(props, num), ETFTexturePropertiesUtils.getPlayerCreated(props, num), ETFTexturePropertiesUtils.getScreamingGoat(props, num), ETFTexturePropertiesUtils.getDistanceFromPlayer(props, num), ETFTexturePropertiesUtils.getCreeperCharge(props, num), ETFTexturePropertiesUtils.getStatusEffect(props, num), ETFTexturePropertiesUtils.getItems(props, num), ETFTexturePropertiesUtils.getMoving(props, num)));
                            continue;
                        }
                        ETFUtils2.logWarn("property number \"" + num + ". in file \"" + vanillaIdentifier + ". failed to read.");
                    }
                    if (!allCasesForTexture.isEmpty()) {
                        manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, allCasesForTexture);
                    } else {
                        ETFUtils2.logMessage("Ignoring properties file that failed to load any cases @ " + vanillaIdentifier, false);
                        manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, null);
                    }
                    break block30;
                }
                ETFUtils2.logMessage("Ignoring properties file that was null @ " + vanillaIdentifier, false);
                manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, null);
            }
            catch (Exception e) {
                ETFUtils2.logWarn("Ignoring properties file that caused Exception @ " + vanillaIdentifier + "\n" + e, false);
                e.printStackTrace();
                manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, null);
            }
        }
    }

    @Nullable
    private static Integer[] getSuffixes(Properties props, int num) {
        Integer[] ints = ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "skins");
        return ints == null ? ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "textures") : ints;
    }

    @Nullable
    private static Integer[] getWeights(Properties props, int num) {
        if (props.containsKey("weights." + num)) {
            String dataFromProps = props.getProperty("weights." + num).trim();
            String[] weightData = dataFromProps.split(" +");
            ArrayList<Integer> builder = new ArrayList<Integer>();
            for (String s : weightData) {
                if ((s = s.trim()).replaceAll("\\D", "").isEmpty()) continue;
                try {
                    int tryNumber = Integer.parseInt(s.replaceAll("\\D", ""));
                    builder.add(tryNumber);
                }
                catch (NumberFormatException e) {
                    ETFUtils2.logWarn("properties files number error in weights category");
                }
            }
            return builder.toArray(new Integer[0]);
        }
        return null;
    }

    @Nullable
    private static String[] getBiomes(Properties props, int num) {
        String dataFromProps;
        String[] biomeList;
        if (props.containsKey("biomes." + num) && (biomeList = (dataFromProps = props.getProperty("biomes." + num).strip()).toLowerCase().split(" +")).length > 0) {
            block35: for (int i = 0; i < biomeList.length; ++i) {
                String biome;
                switch (biome = biomeList[i].strip()) {
                    case "ExtremeHills": {
                        biomeList[i] = "stony_peaks";
                        continue block35;
                    }
                    case "Forest": 
                    case "ForestHills": {
                        biomeList[i] = "forest";
                        continue block35;
                    }
                    case "Taiga": 
                    case "TaigaHills": {
                        biomeList[i] = "taiga";
                        continue block35;
                    }
                    case "Swampland": {
                        biomeList[i] = "swamp";
                        continue block35;
                    }
                    case "River": {
                        biomeList[i] = "river";
                        continue block35;
                    }
                    case "Hell": {
                        biomeList[i] = "nether_wastes";
                        continue block35;
                    }
                    case "Sky": {
                        biomeList[i] = "the_end";
                        continue block35;
                    }
                    case "IcePlains": {
                        biomeList[i] = "snowy_plains";
                        continue block35;
                    }
                    case "IceMountains": {
                        biomeList[i] = "snowy_slopes";
                        continue block35;
                    }
                    case "MushroomIsland": 
                    case "MushroomIslandShore": {
                        biomeList[i] = "mushroom_fields";
                        continue block35;
                    }
                    case "DesertHills": 
                    case "Desert": {
                        biomeList[i] = "desert";
                        continue block35;
                    }
                    case "ExtremeHillsEdge": {
                        biomeList[i] = "meadow";
                        continue block35;
                    }
                    case "Jungle": 
                    case "JungleHills": {
                        biomeList[i] = "jungle";
                        continue block35;
                    }
                    default: {
                        if (biome.contains("_") || !biome.matches("[A-Z]")) continue block35;
                        String snake_case_version = biome.replaceAll("(\\B)([A-Z])", "_$2");
                        biomeList[i] = snake_case_version.toLowerCase();
                    }
                }
            }
            return biomeList;
        }
        return null;
    }

    @Nullable
    private static Integer[] getHeights(Properties props, int num) {
        if (!props.containsKey("heights." + num) && (props.containsKey("minHeight." + num) || props.containsKey("maxHeight." + num))) {
            String min = "-64";
            String max = "319";
            if (props.containsKey("minHeight." + num)) {
                min = props.getProperty("minHeight." + num).strip();
            }
            if (props.containsKey("maxHeight." + num)) {
                max = props.getProperty("maxHeight." + num).strip();
            }
            props.put("heights." + num, min + "-" + max);
        }
        return ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "heights");
    }

    @Nullable
    private static String[] getNames(Properties props, int num) {
        String dataFromProps;
        ArrayList<String> names = new ArrayList<String>();
        if (props.containsKey("names." + num)) {
            dataFromProps = props.getProperty("names." + num).trim();
            if (dataFromProps.contains("regex:") || dataFromProps.contains("pattern:")) {
                names.add(dataFromProps);
            } else {
                names.add(dataFromProps);
                Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(dataFromProps);
                while (m.find()) {
                    names.add(m.group(1).replace("\"", "").trim());
                }
            }
        }
        if (props.containsKey("name." + num)) {
            dataFromProps = props.getProperty("name." + num).trim();
            names.add(dataFromProps);
        }
        if (names.isEmpty()) {
            names = null;
        }
        return names == null ? null : names.toArray(new String[0]);
    }

    @Nullable
    private static String[] getProfessions(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "professions");
    }

    @Nullable
    private static String[] getColors(Properties props, int num) {
        String[] str = ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "collarColors");
        return str == null ? ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "colors") : str;
    }

    @Nullable
    private static Boolean getBaby(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "baby");
    }

    private static WeatherType getWeather(Properties props, int num) {
        if (props.containsKey("weather." + num)) {
            return WeatherType.getType(props.getProperty("weather." + num).trim());
        }
        return null;
    }

    @Nullable
    private static String[] getHealth(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "health");
    }

    @Nullable
    private static Integer[] getMoon(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "moonPhase");
    }

    @Nullable
    private static String[] getDayTime(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "dayTime");
    }

    @Nullable
    private static String[] getBlocks(Properties props, int num) {
        String[] str = ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "blocks");
        return str == null ? ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "block") : str;
    }

    @Nullable
    private static String[] getTeams(Properties props, int num) {
        if (props.containsKey("teams." + num)) {
            String teamData = props.getProperty("teams." + num).trim();
            ArrayList<String> list = new ArrayList<String>();
            Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(teamData);
            while (m.find()) {
                list.add(m.group(1).replace("\"", ""));
            }
            return list.toArray(new String[0]);
        }
        if (props.containsKey("team." + num)) {
            String teamData = props.getProperty("team." + num).trim();
            ArrayList<String> list = new ArrayList<String>();
            Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(teamData);
            while (m.find()) {
                list.add(m.group(1).replace("\"", ""));
            }
            return list.toArray(new String[0]);
        }
        return null;
    }

    @Nullable
    private static Integer[] getSizes(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "sizes");
    }

    @Nullable
    private static Double[] getSpeed(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericMinMaxDouble(props, num, "speed");
    }

    @Nullable
    private static Double[] getJump(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericMinMaxDouble(props, num, "jumpStrength");
    }

    @Nullable
    private static String[] getMaxHealth(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "maxHealth");
    }

    @Nullable
    private static Integer[] getLlamaInv(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "llamaInventory");
    }

    @Nullable
    private static Boolean getAngry(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "angry");
    }

    @Nullable
    private static class_1440.class_1443[] getHiddenGene(Properties props, int num) {
        if (props.containsKey("hiddenGene." + num)) {
            String[] input = props.getProperty("hiddenGene." + num).trim().split(" +");
            ArrayList<class_1440.class_1443> genes = new ArrayList<class_1440.class_1443>();
            block18: for (String gene : input) {
                switch (gene.trim()) {
                    case "normal": {
                        genes.add(class_1440.class_1443.field_6788);
                        continue block18;
                    }
                    case "lazy": {
                        genes.add(class_1440.class_1443.field_6794);
                        continue block18;
                    }
                    case "worried": {
                        genes.add(class_1440.class_1443.field_6795);
                        continue block18;
                    }
                    case "playful": {
                        genes.add(class_1440.class_1443.field_6791);
                        continue block18;
                    }
                    case "brown": {
                        genes.add(class_1440.class_1443.field_6792);
                        continue block18;
                    }
                    case "weak": {
                        genes.add(class_1440.class_1443.field_6793);
                        continue block18;
                    }
                    case "aggressive": {
                        genes.add(class_1440.class_1443.field_6789);
                        continue block18;
                    }
                    default: {
                        ETFUtils2.logWarn("properties files number error in hiddenGene category, caused by input: " + gene);
                    }
                }
            }
            return genes.toArray(new class_1440.class_1443[0]);
        }
        return null;
    }

    @Nullable
    private static Boolean getPlayerCreated(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "playerCreated");
    }

    @Nullable
    private static Boolean getScreamingGoat(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "screamingGoat");
    }

    @Nullable
    private static String[] getDistanceFromPlayer(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "distanceFromPlayer");
    }

    @Nullable
    private static Boolean getCreeperCharge(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "creeperCharged");
    }

    @Nullable
    private static class_1291[] getStatusEffect(Properties props, int num) {
        if (props.containsKey("statusEffect." + num)) {
            String dataFromProps = props.getProperty("statusEffect." + num).trim();
            String[] columnData = dataFromProps.split(" +");
            ArrayList<class_1291> statuses = new ArrayList<class_1291>();
            for (String data : columnData) {
                data = data.replaceAll("\\(", "").replaceAll("\\)", "");
                if ((data = data.trim()).replaceAll("\\D", "").isEmpty()) continue;
                try {
                    int tryNumber = Integer.parseInt(data.replaceAll("\\D", ""));
                    class_1291 attempt = class_1291.method_5569((int)tryNumber);
                    if (attempt == null) continue;
                    statuses.add(attempt);
                }
                catch (NumberFormatException e) {
                    ETFUtils2.logWarn("properties files number error in statusEffects category");
                }
            }
            return statuses.toArray(new class_1291[0]);
        }
        return null;
    }

    @Nullable
    private static String[] getItems(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "items");
    }

    @Nullable
    private static Boolean getMoving(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "moving");
    }

    @Nullable
    private static String[] getGenericStringSplitProperty(Properties props, int num, String propertyName) {
        if (props.containsKey(propertyName + "." + num)) {
            return props.getProperty(propertyName + "." + num).trim().split(" +");
        }
        return null;
    }

    @Nullable
    private static Integer[] getGenericIntegerSplitWithRanges(Properties props, int num, String propertyName) {
        if (props.containsKey(propertyName + "." + num)) {
            String dataFromProps = props.getProperty(propertyName + "." + num).strip();
            String[] skinData = dataFromProps.split(" +");
            ArrayList<Integer> suffixNumbers = new ArrayList<Integer>();
            for (String data : skinData) {
                if ((data = data.strip()).replaceAll("\\D", "").isEmpty()) continue;
                if (data.contains("-")) {
                    suffixNumbers.addAll(Arrays.asList(ETFUtils2.getIntRange(data)));
                    continue;
                }
                try {
                    int tryNumber = Integer.parseInt(data.replaceAll("\\D", ""));
                    suffixNumbers.add(tryNumber);
                }
                catch (NumberFormatException e) {
                    ETFUtils2.logWarn("properties files number error in " + propertyName + " category");
                }
            }
            return suffixNumbers.toArray(new Integer[0]);
        }
        return null;
    }

    @Nullable
    private static Double[] getGenericMinMaxDouble(Properties props, int num, String propertyName) {
        if (props.containsKey(propertyName + "." + num)) {
            String dataFromProps = props.getProperty(propertyName + "." + num).trim();
            String[] rangeData = dataFromProps.split("-");
            if (rangeData.length == 2) {
                try {
                    double tryMinNumber = Double.parseDouble(rangeData[0].replaceAll("[^\\.\\d]", ""));
                    double tryMaxNumber = Double.parseDouble(rangeData[1].replaceAll("[^\\.\\d]", ""));
                    return new Double[]{tryMinNumber, tryMaxNumber};
                }
                catch (NumberFormatException e) {
                    ETFUtils2.logWarn("properties files number error in " + propertyName + " category");
                }
            } else {
                ETFUtils2.logWarn("properties files number error in " + propertyName + " category");
            }
        }
        return null;
    }

    @Nullable
    private static Boolean getGenericBooleanThatCanNull(Properties props, int num, String propertyName) {
        if (props.containsKey(propertyName + "." + num)) {
            String input = props.getProperty(propertyName + "." + num).trim();
            if ("true".equals(input) || "false".equals(input)) {
                return "true".equals(input);
            }
            ETFUtils2.logWarn("properties files number error in " + propertyName + " category");
        }
        return null;
    }

    public static class ETFTexturePropertyCase {
        private final Integer[] SUFFIX_NUMBERS_WEIGHTED;
        @Nullable
        private final String[] BIOME_VALUES;
        @Nullable
        private final Integer[] HEIGHT_Y_VALUES;
        @Nullable
        private final String[] NAME_STRINGS;
        @Nullable
        private final String[] PROFESSION_VALUES;
        @Nullable
        private final String[] COLOR_VALUES;
        @Nullable
        private final Boolean IS_BABY;
        @Nullable
        private final WeatherType WEATHER_TYPE;
        @Nullable
        private final String[] HEALTH_RANGE_STRINGS;
        @Nullable
        private final Integer[] MOON_PHASE_VALUES;
        @Nullable
        private final String[] TIME_RANGE_STRINGS;
        @Nullable
        private final String[] BLOCK_VALUES;
        @Nullable
        private final String[] TEAM_VALUES;
        @Nullable
        private final Integer[] SIZE_VALUES;
        @Nullable
        private final Double[] SPEED_MIN_MAX;
        @Nullable
        private final Double[] JUMP_MIN_MAX;
        @Nullable
        private final String[] MAX_HEALTH_STRINGS;
        @Nullable
        private final Integer[] INVENTORY_COLUMNS;
        @Nullable
        private final Boolean IS_ANGRY;
        @Nullable
        private final class_1440.class_1443[] HIDDEN_GENE;
        @Nullable
        private final Boolean IS_PLAYER_CREATED;
        @Nullable
        private final Boolean IS_SCREAMING_GOAT;
        @Nullable
        private final String[] DISTANCE_TO_PLAYER;
        @Nullable
        private final Boolean CREEPER_CHARGED;
        @Nullable
        private final class_1291[] STATUS_EFFECT;
        @Nullable
        private final String[] ITEMS;
        @Nullable
        private final Boolean MOVING;

        public ETFTexturePropertyCase(Integer[] suffixesX, @Nullable Integer[] weightsX, @Nullable String[] biomesX, @Nullable Integer[] heights, @Nullable String[] namesX, @Nullable String[] professionsX, @Nullable String[] collarColoursX, @Nullable Boolean baby012, @Nullable WeatherType weather0123, @Nullable String[] healthX, @Nullable Integer[] moonX, @Nullable String[] daytimeX, @Nullable String[] blocksX, @Nullable String[] teamsX, @Nullable Integer[] sizeX, @Nullable Double[] speedMinMax, @Nullable Double[] jumpMinMax, @Nullable String[] maxHealthStrings, @Nullable Integer[] inventoryColumns, @Nullable Boolean isAngry, @Nullable class_1440.class_1443[] hiddenGene, @Nullable Boolean isPlayerCreated, @Nullable Boolean isScreamingGoat, @Nullable String[] distanceToPlayer, @Nullable Boolean creeperCharged, @Nullable class_1291[] statusEffect, @Nullable String[] items, @Nullable Boolean moving) {
            this.MOVING = moving;
            this.ITEMS = items;
            this.STATUS_EFFECT = statusEffect;
            this.CREEPER_CHARGED = creeperCharged;
            this.DISTANCE_TO_PLAYER = distanceToPlayer;
            this.SPEED_MIN_MAX = speedMinMax;
            this.JUMP_MIN_MAX = jumpMinMax;
            this.MAX_HEALTH_STRINGS = maxHealthStrings;
            this.INVENTORY_COLUMNS = inventoryColumns;
            this.IS_ANGRY = isAngry;
            this.HIDDEN_GENE = hiddenGene;
            this.IS_PLAYER_CREATED = isPlayerCreated;
            this.IS_SCREAMING_GOAT = isScreamingGoat;
            this.BIOME_VALUES = biomesX;
            this.HEIGHT_Y_VALUES = heights;
            this.NAME_STRINGS = namesX;
            this.PROFESSION_VALUES = professionsX;
            this.COLOR_VALUES = collarColoursX;
            this.IS_BABY = baby012;
            this.WEATHER_TYPE = weather0123;
            this.HEALTH_RANGE_STRINGS = healthX;
            this.MOON_PHASE_VALUES = moonX;
            this.TIME_RANGE_STRINGS = daytimeX;
            this.BLOCK_VALUES = blocksX;
            this.TEAM_VALUES = teamsX;
            this.SIZE_VALUES = sizeX;
            if (weightsX == null) {
                weightsX = new Integer[]{};
            }
            if (weightsX.length > 0) {
                if (weightsX.length == suffixesX.length) {
                    ArrayList<Integer> buildWeighted = new ArrayList<Integer>();
                    int index = 0;
                    Integer[] integerArray = suffixesX;
                    int n = integerArray.length;
                    for (int i = 0; i < n; ++i) {
                        int suffix = integerArray[i];
                        Integer weightValue = weightsX[index];
                        if (weightValue != null) {
                            for (int i2 = 0; i2 < weightValue; ++i2) {
                                buildWeighted.add(suffix);
                            }
                        }
                        ++index;
                    }
                    this.SUFFIX_NUMBERS_WEIGHTED = buildWeighted.toArray(new Integer[0]);
                } else {
                    ETFUtils2.logWarn("random texture weights don't match for:\n suffixes: " + Arrays.toString((Object[])suffixesX) + "\n weights: " + Arrays.toString((Object[])weightsX), false);
                    this.SUFFIX_NUMBERS_WEIGHTED = suffixesX;
                }
            } else {
                this.SUFFIX_NUMBERS_WEIGHTED = suffixesX;
            }
        }

        public String toString() {
            return "randomCase{weightedSuffixes=" + Arrays.toString((Object[])this.SUFFIX_NUMBERS_WEIGHTED) + ", biomes=" + Arrays.toString(this.BIOME_VALUES) + ", heights=" + Arrays.toString((Object[])this.HEIGHT_Y_VALUES) + ", names=" + Arrays.toString(this.NAME_STRINGS) + "}";
        }

        /*
         * WARNING - void declaration
         */
        public boolean doesEntityMeetConditionsOfThisCase(class_1297 entity, boolean isUpdate, Object2BooleanOpenHashMap<UUID> UUID_CaseHasUpdateablesCustom) {
            int cat22;
            String[] str;
            int n;
            boolean check;
            ObjectImmutableList<String> spawnConditions;
            if (this.BIOME_VALUES == null && this.NAME_STRINGS == null && this.HEIGHT_Y_VALUES == null && this.PROFESSION_VALUES == null && this.COLOR_VALUES == null && this.IS_BABY == null && this.WEATHER_TYPE == null && this.HEALTH_RANGE_STRINGS == null && this.MOON_PHASE_VALUES == null && this.TIME_RANGE_STRINGS == null && this.BLOCK_VALUES == null && this.TEAM_VALUES == null && this.SIZE_VALUES == null && this.SPEED_MIN_MAX == null && this.JUMP_MIN_MAX == null && this.MAX_HEALTH_STRINGS == null && this.INVENTORY_COLUMNS == null && this.IS_ANGRY == null && this.HIDDEN_GENE == null && this.IS_PLAYER_CREATED == null && this.IS_SCREAMING_GOAT == null && this.DISTANCE_TO_PLAYER == null && this.CREEPER_CHARGED == null && this.STATUS_EFFECT == null && this.ITEMS == null && this.MOVING == null) {
                return true;
            }
            if (!ETFClientCommon.ETFConfigData.restrictUpdateProperties) {
                isUpdate = false;
            }
            UUID id = entity.method_5667();
            if (ETFClientCommon.ETFConfigData.restrictUpdateProperties) {
                if (ETFManager.getInstance().ENTITY_SPAWN_CONDITIONS_CACHE.containsKey(id)) {
                    spawnConditions = ETFManager.getInstance().ENTITY_SPAWN_CONDITIONS_CACHE.get(id);
                } else {
                    spawnConditions = this.readAllSpawnConditionsForCache(entity);
                    ETFManager.getInstance().ENTITY_SPAWN_CONDITIONS_CACHE.put(id, spawnConditions);
                }
            } else {
                spawnConditions = null;
            }
            boolean wasEntityTestedByAnUpdatableProperty = false;
            boolean doesEntityMeetThisCaseTest = true;
            if (this.BIOME_VALUES != null) {
                if (!ETFClientCommon.ETFConfigData.restrictBiome) {
                    wasEntityTestedByAnUpdatableProperty = true;
                }
                String entityBiome = isUpdate && ETFClientCommon.ETFConfigData.restrictBiome && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 1 ? ((String)spawnConditions.get(0)).trim() : ETFVersionDifferenceHandler.getBiomeString(entity.field_6002, entity.method_24515());
                check = false;
                for (String str3 : this.BIOME_VALUES) {
                    if (str3 == null || !entityBiome.replace("minecraft:", "").equals(str3.trim().toLowerCase().replace("minecraft:", ""))) continue;
                    check = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check;
            }
            if (doesEntityMeetThisCaseTest && this.NAME_STRINGS != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                if (entity.method_16914()) {
                    String entityName = Objects.requireNonNull(entity.method_5797()).getString();
                    check = false;
                    boolean invert = false;
                    String[] stringArray = this.NAME_STRINGS;
                    n = stringArray.length;
                    for (int str3 = 0; str3 < n; ++str3) {
                        void var14_115;
                        String string = stringArray[str3];
                        if (string == null) continue;
                        String string2 = string.trim();
                        if (string2.startsWith("!")) {
                            String string3 = string2.replaceFirst("!", "");
                            invert = true;
                            check = true;
                        }
                        if (var14_115.contains("regex:")) {
                            if (var14_115.contains("iregex:")) {
                                String string4 = var14_115.split(":")[1];
                                if (!entityName.matches("(?i)" + string4)) continue;
                                check = !invert;
                                break;
                            }
                            String string5 = var14_115.split(":")[1];
                            if (!entityName.matches(string5)) continue;
                            check = !invert;
                            break;
                        }
                        if (var14_115.contains("pattern:")) {
                            String string6 = var14_115.replace("?", ".?").replace("*", ".*");
                            if (string6.contains("ipattern:")) {
                                String string7 = string6.replace("ipattern:", "");
                                if (!entityName.matches("(?i)" + string7)) continue;
                                check = !invert;
                                break;
                            }
                            String string8 = string6.replace("pattern:", "");
                            if (!entityName.matches(string8)) continue;
                            check = !invert;
                            break;
                        }
                        if (!entityName.equals(var14_115)) continue;
                        check = !invert;
                        break;
                    }
                    doesEntityMeetThisCaseTest = check;
                } else {
                    doesEntityMeetThisCaseTest = false;
                }
            }
            if (doesEntityMeetThisCaseTest && this.HEIGHT_Y_VALUES != null) {
                if (!ETFClientCommon.ETFConfigData.restrictHeight) {
                    wasEntityTestedByAnUpdatableProperty = true;
                }
                int entityHeight = isUpdate && ETFClientCommon.ETFConfigData.restrictHeight && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 2 ? Integer.parseInt(((String)spawnConditions.get(1)).trim()) : entity.method_31478();
                check = false;
                Integer[] invert = this.HEIGHT_Y_VALUES;
                int n2 = invert.length;
                for (n = 0; n < n2; ++n) {
                    int i = invert[n];
                    if (i != entityHeight) continue;
                    check = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check;
            }
            if (doesEntityMeetThisCaseTest && this.PROFESSION_VALUES != null && entity instanceof class_1646) {
                wasEntityTestedByAnUpdatableProperty = true;
                String entityProfession = ((class_1646)entity).method_7231().method_16924().toString().toLowerCase().replace("minecraft:", "");
                int entityProfessionLevel = ((class_1646)entity).method_7231().method_16925();
                boolean check2 = false;
                block3: for (String string : this.PROFESSION_VALUES) {
                    if (string == null) continue;
                    String string9 = string.toLowerCase().replaceAll(" *", "").replace("minecraft:", "");
                    if (string9.contains(":")) {
                        String[] data = string9.split(":\\d");
                        if (!entityProfession.contains(data[0]) && !data[0].contains(entityProfession)) continue;
                        if (data.length == 2) {
                            String[] levels = data[1].split(",");
                            ArrayList<Integer> levelData = new ArrayList<Integer>();
                            for (String lvls : levels) {
                                if (lvls.contains("-")) {
                                    levelData.addAll(Arrays.asList(ETFUtils2.getIntRange(lvls)));
                                    continue;
                                }
                                levelData.add(Integer.parseInt(lvls.replaceAll("\\D", "")));
                            }
                            for (Integer i : levelData) {
                                if (i != entityProfessionLevel) continue;
                                check2 = true;
                                continue block3;
                            }
                            continue;
                        }
                        check2 = true;
                        break;
                    }
                    if (!entityProfession.contains(string9) && !string9.contains(entityProfession)) continue;
                    check2 = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check2;
            }
            if (doesEntityMeetThisCaseTest && this.COLOR_VALUES != null) {
                String entityColor;
                wasEntityTestedByAnUpdatableProperty = true;
                if (entity instanceof class_1493) {
                    class_1493 wolf = (class_1493)entity;
                    entityColor = wolf.method_6713().method_7792().toLowerCase();
                } else if (entity instanceof class_1472) {
                    class_1472 sheep = (class_1472)entity;
                    entityColor = sheep.method_6633().method_7792().toLowerCase();
                } else if (entity instanceof class_1501) {
                    class_1501 llama = (class_1501)entity;
                    str = llama.method_6800();
                    entityColor = str != null ? str.method_7792().toLowerCase() : "NOT_A_COLOR";
                } else if (entity instanceof class_1451) {
                    class_1451 cat22 = (class_1451)entity;
                    entityColor = cat22.method_16096().method_7792().toLowerCase();
                } else {
                    class_1474 class_14742;
                    class_1606 shulker;
                    entityColor = entity instanceof class_1606 ? ((str = (shulker = (class_1606)entity).method_7121()) != null ? str.method_7792().toLowerCase() : "NOT_A_COLOR") : (entity instanceof class_1474 ? ((str = class_1474.method_6652((int)(class_14742 = (class_1474)entity).method_6644())) != null ? str.method_7792().toLowerCase() : "NOT_A_COLOR") : "NOT_A_COLOR");
                }
                check = false;
                String[] sheep = this.COLOR_VALUES;
                int llama = sheep.length;
                for (cat22 = 0; cat22 < llama; ++cat22) {
                    String i = sheep[cat22];
                    if (i == null || !(i = i.toLowerCase()).equals(entityColor)) continue;
                    check = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check;
            }
            if (doesEntityMeetThisCaseTest && entity instanceof class_1309 && this.IS_BABY != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                boolean bl = doesEntityMeetThisCaseTest = this.IS_BABY.booleanValue() == ((class_1309)entity).method_6109();
            }
            if (doesEntityMeetThisCaseTest && this.WEATHER_TYPE != null) {
                boolean thundering;
                boolean raining;
                if (!ETFClientCommon.ETFConfigData.restrictWeather) {
                    wasEntityTestedByAnUpdatableProperty = true;
                }
                if (isUpdate && ETFClientCommon.ETFConfigData.restrictWeather && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() >= 4) {
                    String[] data = ((String)spawnConditions.get(3)).split("-");
                    raining = "1".equals(data[0].trim());
                    thundering = "1".equals(data[1].trim());
                } else {
                    raining = entity.field_6002.method_8419();
                    thundering = entity.field_6002.method_8546();
                }
                boolean check3 = false;
                if (this.WEATHER_TYPE == WeatherType.clear && !raining && !thundering) {
                    check3 = true;
                } else if (this.WEATHER_TYPE == WeatherType.rain && raining) {
                    check3 = true;
                } else if (this.WEATHER_TYPE == WeatherType.thunder && thundering) {
                    check3 = true;
                }
                doesEntityMeetThisCaseTest = check3;
            }
            if (doesEntityMeetThisCaseTest && entity instanceof class_1309 && this.HEALTH_RANGE_STRINGS != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                boolean check4 = false;
                float checkValue = ((class_1309)entity).method_6032() / ((class_1309)entity).method_6063() * 100.0f;
                String[] check3 = this.HEALTH_RANGE_STRINGS;
                int llama = check3.length;
                for (cat22 = 0; cat22 < llama; ++cat22) {
                    String hlth = check3[cat22];
                    if (hlth == null) continue;
                    if (hlth.contains("-")) {
                        String[] stringArray = hlth.split("-");
                        if (!(checkValue >= (float)Integer.parseInt(stringArray[0].replaceAll("\\D", ""))) || !(checkValue <= (float)Integer.parseInt(stringArray[1].replaceAll("\\D", "")))) continue;
                        check4 = true;
                        break;
                    }
                    if (checkValue != (float)Integer.parseInt(hlth.replaceAll("\\D", ""))) continue;
                    check4 = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check4;
            }
            if (doesEntityMeetThisCaseTest && this.MOON_PHASE_VALUES != null) {
                if (!ETFClientCommon.ETFConfigData.restrictMoonPhase) {
                    wasEntityTestedByAnUpdatableProperty = true;
                }
                int moonPhase = isUpdate && ETFClientCommon.ETFConfigData.restrictMoonPhase && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 5 ? Integer.parseInt(((String)spawnConditions.get(5)).trim()) : entity.field_6002.method_30273();
                boolean check5 = false;
                Integer[] check3 = this.MOON_PHASE_VALUES;
                int llama = check3.length;
                for (cat22 = 0; cat22 < llama; ++cat22) {
                    int i = check3[cat22];
                    if (i != moonPhase) continue;
                    check5 = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check5;
            }
            if (doesEntityMeetThisCaseTest && this.TIME_RANGE_STRINGS != null) {
                if (!ETFClientCommon.ETFConfigData.restrictDayTime) {
                    wasEntityTestedByAnUpdatableProperty = true;
                }
                boolean check6 = false;
                long time = isUpdate && ETFClientCommon.ETFConfigData.restrictDayTime && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 4 ? Long.parseLong(((String)spawnConditions.get(4)).trim()) : entity.field_6002.method_8532();
                String[] llama = this.TIME_RANGE_STRINGS;
                cat22 = llama.length;
                for (int i = 0; i < cat22; ++i) {
                    String string = llama[i];
                    if (string == null) continue;
                    if (string.contains("-")) {
                        str = string.split("-");
                        if (time < Long.parseLong(str[0].replaceAll("\\D", "")) || time > Long.parseLong(str[1].replaceAll("\\D", ""))) continue;
                        check6 = true;
                        break;
                    }
                    if (time != Long.parseLong(string.replaceAll("\\D", ""))) continue;
                    check6 = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check6;
            }
            if (doesEntityMeetThisCaseTest && this.BLOCK_VALUES != null) {
                String[] entityOnBlocks;
                if (!ETFClientCommon.ETFConfigData.restrictBlock) {
                    wasEntityTestedByAnUpdatableProperty = true;
                }
                if (isUpdate && ETFClientCommon.ETFConfigData.restrictBlock && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 6) {
                    entityOnBlocks = new String[]{((String)spawnConditions.get(2)).trim(), ((String)spawnConditions.get(6)).trim()};
                } else {
                    String entityOnBlock1 = entity.field_6002.method_8320(entity.method_24515().method_10074()).toString().replaceFirst("minecraft:", "").replaceFirst("Block\\{", "").replaceFirst("}.*", "").toLowerCase();
                    String entityOnBlock2 = entity.field_6002.method_8320(entity.method_24515()).toString().replaceFirst("minecraft:", "").replaceFirst("Block\\{", "").replaceFirst("}.*", "").toLowerCase();
                    entityOnBlocks = new String[]{entityOnBlock1, entityOnBlock2};
                }
                boolean check2 = false;
                boolean check1 = false;
                for (String string : this.BLOCK_VALUES) {
                    if (string == null) continue;
                    String string10 = string.strip();
                    if (string10.startsWith("!")) {
                        String string11 = string10.replaceFirst("!", "");
                        if (!string11.replace("minecraft:", "").equalsIgnoreCase(entityOnBlocks[0])) {
                            check1 = true;
                            continue;
                        }
                        doesEntityMeetThisCaseTest = false;
                        continue;
                    }
                    if (!string10.replace("minecraft:", "").equalsIgnoreCase(entityOnBlocks[0])) continue;
                    check1 = true;
                    break;
                }
                String[] llama = this.BLOCK_VALUES;
                cat22 = llama.length;
                for (int i = 0; i < cat22; ++i) {
                    String string = llama[i];
                    if (string == null) continue;
                    String string12 = string.strip();
                    if (string12.startsWith("!")) {
                        String string13 = string12.replaceFirst("!", "");
                        if (!string13.replace("minecraft:", "").equalsIgnoreCase(entityOnBlocks[1])) {
                            check2 = true;
                            continue;
                        }
                        doesEntityMeetThisCaseTest = false;
                        continue;
                    }
                    if (!string12.replace("minecraft:", "").equalsIgnoreCase(entityOnBlocks[1])) continue;
                    check2 = true;
                    break;
                }
                if (doesEntityMeetThisCaseTest) {
                    boolean bl = doesEntityMeetThisCaseTest = check1 || check2;
                }
            }
            if (doesEntityMeetThisCaseTest && this.TEAM_VALUES != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                if (entity.method_5781() != null) {
                    String teamName = entity.method_5781().method_1197();
                    boolean check7 = false;
                    boolean invert = false;
                    String[] llama = this.TEAM_VALUES;
                    cat22 = llama.length;
                    for (int i = 0; i < cat22; ++i) {
                        void var14_145;
                        String string = llama[i];
                        if (string == null) continue;
                        String string14 = string.trim();
                        if (string14.startsWith("!")) {
                            String string15 = string14.replaceFirst("!", "");
                            invert = true;
                            check7 = true;
                        }
                        if (!teamName.equals(var14_145)) continue;
                        check7 = !invert;
                        break;
                    }
                    doesEntityMeetThisCaseTest = check7;
                } else {
                    doesEntityMeetThisCaseTest = false;
                }
            }
            if (doesEntityMeetThisCaseTest && this.SIZE_VALUES != null && (entity instanceof class_1621 || entity instanceof class_1593)) {
                int size;
                if (entity instanceof class_1621) {
                    class_1621 slime = (class_1621)entity;
                    size = slime.method_7152();
                } else {
                    size = ((class_1593)entity).method_7084();
                }
                boolean check8 = false;
                Integer[] invert = this.SIZE_VALUES;
                int llama = invert.length;
                for (cat22 = 0; cat22 < llama; ++cat22) {
                    int i = invert[cat22];
                    if (i != size) continue;
                    check8 = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check8;
            }
            if (doesEntityMeetThisCaseTest && entity instanceof class_1309 && this.SPEED_MIN_MAX != null) {
                double speed = ((class_1309)entity).method_6029();
                Double min = this.SPEED_MIN_MAX[0];
                Double max = this.SPEED_MIN_MAX[1];
                if (min != null && max != null) {
                    boolean bl = doesEntityMeetThisCaseTest = speed >= min && speed <= max;
                }
            }
            if (doesEntityMeetThisCaseTest && this.JUMP_MIN_MAX != null && entity instanceof class_1496) {
                double jumpHeight = ((class_1496)entity).method_6771();
                Double min = this.JUMP_MIN_MAX[0];
                Double max = this.JUMP_MIN_MAX[1];
                if (min != null && max != null) {
                    boolean bl = doesEntityMeetThisCaseTest = jumpHeight >= min && jumpHeight <= max;
                }
            }
            if (doesEntityMeetThisCaseTest && entity instanceof class_1309 && this.MAX_HEALTH_STRINGS != null) {
                boolean check9 = false;
                float checkValue = ((class_1309)entity).method_6063();
                for (String hlth : this.MAX_HEALTH_STRINGS) {
                    if (hlth == null) continue;
                    if (hlth.contains("-")) {
                        String[] stringArray = hlth.split("-");
                        if (!(checkValue >= (float)Integer.parseInt(stringArray[0].replaceAll("\\D", ""))) || !(checkValue <= (float)Integer.parseInt(stringArray[1].replaceAll("\\D", "")))) continue;
                        check9 = true;
                        break;
                    }
                    if (checkValue != (float)Integer.parseInt(hlth.replaceAll("\\D", ""))) continue;
                    check9 = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check9;
            }
            if (doesEntityMeetThisCaseTest && this.INVENTORY_COLUMNS != null && entity instanceof class_1501) {
                boolean found = false;
                Integer[] checkValue = this.INVENTORY_COLUMNS;
                int min = checkValue.length;
                for (int max = 0; max < min; ++max) {
                    int columns = checkValue[max];
                    if (((class_1501)entity).method_6702() != columns) continue;
                    found = true;
                    break;
                }
                doesEntityMeetThisCaseTest = found;
            }
            if (doesEntityMeetThisCaseTest && this.IS_ANGRY != null) {
                if (entity instanceof class_1560) {
                    wasEntityTestedByAnUpdatableProperty = true;
                    doesEntityMeetThisCaseTest = ((class_1560)entity).method_7028() == this.IS_ANGRY.booleanValue();
                } else if (entity instanceof class_1545) {
                    wasEntityTestedByAnUpdatableProperty = true;
                    doesEntityMeetThisCaseTest = entity.method_5809() == this.IS_ANGRY.booleanValue();
                } else if (entity instanceof class_1577) {
                    wasEntityTestedByAnUpdatableProperty = true;
                    doesEntityMeetThisCaseTest = ((class_1577)entity).method_7052() != null == this.IS_ANGRY;
                } else if (entity instanceof class_1632) {
                    wasEntityTestedByAnUpdatableProperty = true;
                    doesEntityMeetThisCaseTest = ((class_1632)entity).method_6510() == this.IS_ANGRY.booleanValue();
                } else if (entity instanceof class_1617) {
                    wasEntityTestedByAnUpdatableProperty = true;
                    doesEntityMeetThisCaseTest = ((class_1617)entity).method_7137() == this.IS_ANGRY.booleanValue();
                } else {
                    doesEntityMeetThisCaseTest = false;
                }
            }
            if (doesEntityMeetThisCaseTest && this.HIDDEN_GENE != null && entity instanceof class_1440) {
                boolean found = false;
                for (class_1440.class_1443 gene : this.HIDDEN_GENE) {
                    if (((class_1440)entity).method_6508() != gene) continue;
                    found = true;
                    break;
                }
                doesEntityMeetThisCaseTest = found;
            }
            if (doesEntityMeetThisCaseTest && this.IS_PLAYER_CREATED != null && entity instanceof class_1439) {
                boolean bl = doesEntityMeetThisCaseTest = ((class_1439)entity).method_6496() == this.IS_PLAYER_CREATED.booleanValue();
            }
            if (doesEntityMeetThisCaseTest && this.IS_SCREAMING_GOAT != null && entity instanceof class_6053) {
                boolean bl = doesEntityMeetThisCaseTest = ((class_6053)entity).method_35178() == this.IS_SCREAMING_GOAT.booleanValue();
            }
            if (doesEntityMeetThisCaseTest && this.DISTANCE_TO_PLAYER != null && class_310.method_1551().field_1724 != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                boolean check10 = false;
                float checkValue = entity.method_5739((class_1297)class_310.method_1551().field_1724);
                for (String distances : this.DISTANCE_TO_PLAYER) {
                    if (distances == null) continue;
                    if (distances.contains("-")) {
                        String[] stringArray = distances.split("-");
                        if (!(checkValue >= (float)Integer.parseInt(stringArray[0].replaceAll("\\D", ""))) || !(checkValue <= (float)Integer.parseInt(stringArray[1].replaceAll("\\D", "")))) continue;
                        check10 = true;
                        break;
                    }
                    if ((int)checkValue != Integer.parseInt(distances.replaceAll("\\D", ""))) continue;
                    check10 = true;
                    break;
                }
                doesEntityMeetThisCaseTest = check10;
            }
            if (doesEntityMeetThisCaseTest && this.CREEPER_CHARGED != null && entity instanceof class_1548) {
                wasEntityTestedByAnUpdatableProperty = true;
                boolean bl = doesEntityMeetThisCaseTest = ((class_1548)entity).method_6872() == this.CREEPER_CHARGED.booleanValue();
            }
            if (doesEntityMeetThisCaseTest && entity instanceof class_1309 && this.STATUS_EFFECT != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                boolean found = false;
                for (class_1291 effect : this.STATUS_EFFECT) {
                    if (!((class_1309)entity).method_6059(effect)) continue;
                    found = true;
                    break;
                }
                if (!found && entity instanceof class_1438) {
                    class_1438 shroom = (class_1438)entity;
                    for (class_1291 effect : this.STATUS_EFFECT) {
                        if (effect == null || !effect.equals(((MooshroomEntityAccessor)shroom).getStewEffect())) continue;
                        found = true;
                        break;
                    }
                }
                doesEntityMeetThisCaseTest = found;
            }
            if (doesEntityMeetThisCaseTest && this.ITEMS != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                System.out.println(Arrays.toString(this.ITEMS) + " - " + entity.method_5743().toString());
                if (this.ITEMS.length == 1 && ("none".equals(this.ITEMS[0]) || "any".equals(this.ITEMS[0]) || "holding".equals(this.ITEMS[0]) || "wearing".equals(this.ITEMS[0]))) {
                    if ("none".equals(this.ITEMS[0])) {
                        Iterable equipped = entity.method_5743();
                        for (class_1799 item : equipped) {
                            if (item == null || item.method_7960()) continue;
                            doesEntityMeetThisCaseTest = false;
                            break;
                        }
                    } else {
                        Iterable items = "any".equals(this.ITEMS[0]) ? entity.method_5743() : ("holding".equals(this.ITEMS[0]) ? entity.method_5877() : entity.method_5661());
                        boolean found = false;
                        for (class_1799 item : items) {
                            if (item == null || item.method_7960()) continue;
                            found = true;
                            break;
                        }
                        doesEntityMeetThisCaseTest = found;
                    }
                } else {
                    Iterable equipped = entity.method_5743();
                    boolean found = false;
                    block22: for (String itemToFind : this.ITEMS) {
                        if (itemToFind == null) continue;
                        if (itemToFind.contains("minecraft:")) {
                            itemToFind = itemToFind.replace("minecraft:", "");
                        }
                        for (class_1799 item : equipped) {
                            if (item == null || item.method_7960() || !item.method_7909().toString().replace("minecraft:", "").equals(itemToFind)) continue;
                            found = true;
                            break block22;
                        }
                    }
                    doesEntityMeetThisCaseTest = found;
                }
            }
            if (doesEntityMeetThisCaseTest && this.MOVING != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                boolean bl = doesEntityMeetThisCaseTest = entity.method_18798().method_37267() == 0.0 != this.MOVING;
            }
            if (wasEntityTestedByAnUpdatableProperty) {
                UUID_CaseHasUpdateablesCustom.put((Object)entity.method_5667(), true);
            }
            return doesEntityMeetThisCaseTest;
        }

        public int getAnEntityVariantSuffixFromThisCase(UUID id) {
            int randomReliable = id.hashCode() > 0 ? id.hashCode() : -id.hashCode();
            randomReliable %= this.SUFFIX_NUMBERS_WEIGHTED.length;
            randomReliable = this.SUFFIX_NUMBERS_WEIGHTED[randomReliable];
            return randomReliable;
        }

        @NotNull
        private ObjectImmutableList<String> readAllSpawnConditionsForCache(@NotNull class_1297 entity) {
            String block2;
            @NotNull String biome = !ETFClientCommon.ETFConfigData.restrictBiome ? "" : ETFVersionDifferenceHandler.getBiomeString(entity.field_6002, entity.method_24515());
            @NotNull String height = !ETFClientCommon.ETFConfigData.restrictHeight ? "" : "" + entity.method_31478();
            @NotNull String block = !ETFClientCommon.ETFConfigData.restrictBlock ? "" : entity.field_6002.method_8320(entity.method_24515().method_10074()).toString().replaceFirst("minecraft:", "").replaceFirst("Block\\{", "").replaceFirst("}.*", "").toLowerCase();
            String string = block2 = !ETFClientCommon.ETFConfigData.restrictBlock ? "" : entity.field_6002.method_8320(entity.method_24515()).toString().replaceFirst("minecraft:", "").replaceFirst("Block\\{", "").replaceFirst("}.*", "").toLowerCase();
            @NotNull String weather = !ETFClientCommon.ETFConfigData.restrictWeather ? "" : (entity.field_6002.method_8419() ? "1" : "0") + "-" + (entity.field_6002.method_8546() ? "1" : "0");
            @NotNull String time = !ETFClientCommon.ETFConfigData.restrictDayTime ? "" : "" + entity.field_6002.method_8532();
            @NotNull String moon = !ETFClientCommon.ETFConfigData.restrictMoonPhase ? "" : "" + entity.field_6002.method_30273();
            return ObjectImmutableList.of((Object[])new String[]{biome, height, block, weather, time, moon, block2});
        }
    }

    private static enum WeatherType {
        clear,
        rain,
        thunder;


        @Nullable
        public static WeatherType getType(String type) {
            if (type == null) {
                return null;
            }
            switch (type) {
                case "clear": {
                    return clear;
                }
                case "rain": {
                    return rain;
                }
                case "thunder": {
                    return thunder;
                }
            }
            return null;
        }
    }
}

