/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFClientCommon {
    public static final File CONFIG_DIR = ETFVersionDifferenceHandler.getConfigDir();
    public static final String MOD_ID = "entity_texture_features";
    public static final Logger LOGGER = ETFVersionDifferenceHandler.getLogger();
    public static ETFConfig ETFConfigData = new ETFConfig();
    public static boolean configHadLoadError = false;

    public static void start() {
        LOGGER.info("Loading Entity Texture Features, Thank you for 3 Million downloads :)");
        ETFClientCommon.etf$loadConfig();
        ETFUtils2.checkModCompatibility();
    }

    public static void etf$loadConfig() {
        try {
            File config = new File(CONFIG_DIR, "entity_texture_features.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (config.exists()) {
                try {
                    FileReader fileReader = new FileReader(config);
                    ETFConfigData = (ETFConfig)gson.fromJson((Reader)fileReader, ETFConfig.class);
                    fileReader.close();
                    ETFUtils2.saveConfig();
                }
                catch (IOException e) {
                    ETFUtils2.logMessage("Config could not be loaded, using defaults", false);
                    ETFConfigData = new ETFConfig();
                    ETFUtils2.saveConfig();
                    configHadLoadError = true;
                }
            } else {
                ETFConfigData = new ETFConfig();
                ETFUtils2.saveConfig();
            }
            if (ETFConfigData == null) {
                ETFUtils2.logMessage("Config was null, using defaults", false);
                ETFConfigData = new ETFConfig();
                configHadLoadError = true;
            }
        }
        catch (Exception e) {
            ETFUtils2.logError("Config was corrupt or broken, using defaults", false);
            ETFConfigData = new ETFConfig();
            configHadLoadError = true;
        }
    }
}

