/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search;

import com.google.common.collect.Lists;
import dev.architectury.platform.Platform;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.search.SearchProviderImpl;
import me.shedaniel.rei.impl.client.search.argument.Argument;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import me.shedaniel.rei.impl.client.util.ThreadCreator;
import org.jetbrains.annotations.Nullable;

public class AsyncSearchManager {
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadCreator("REI-AsyncSearchManager").asService();
    private final Supplier<List<EntryStack<?>>> stacksProvider;
    private final Supplier<Predicate<EntryStack<?>>> additionalPredicateSupplier;
    private final UnaryOperator<EntryStack<?>> transformer;
    private ExecutorTuple executor;
    private SearchFilter filter;
    private Map.Entry<List<EntryStack<?>>, SearchFilter> last;

    public AsyncSearchManager(Supplier<List<EntryStack<?>>> stacksProvider, Supplier<Predicate<EntryStack<?>>> additionalPredicateSupplier, UnaryOperator<EntryStack<?>> transformer) {
        this.stacksProvider = stacksProvider;
        this.additionalPredicateSupplier = additionalPredicateSupplier;
        this.transformer = transformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDirty() {
        AsyncSearchManager asyncSearchManager = this;
        synchronized (asyncSearchManager) {
            this.last = null;
        }
    }

    @Nullable
    public SearchFilter filter() {
        return this.filter;
    }

    public void updateFilter(String filter) {
        if (this.filter == null || !this.filter.getFilter().equals(filter)) {
            if (this.executor != null) {
                this.executor.future().cancel(Platform.isFabric());
            }
            this.executor = null;
            this.filter = SearchProvider.getInstance().createFilter(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        AsyncSearchManager asyncSearchManager = this;
        synchronized (asyncSearchManager) {
            return this.last == null || this.last.getValue() != this.filter;
        }
    }

    public Future<?> getAsync(BiConsumer<List<EntryStack<?>>, SearchFilter> consumer) {
        if (this.executor == null || this.executor.filter() != this.filter || this.isDirty()) {
            if (this.executor != null) {
                this.executor.future().cancel(Platform.isFabric());
            }
            this.executor = new ExecutorTuple(this.filter, this.get(EXECUTOR_SERVICE));
        }
        SearchFilter savedFilter = this.filter;
        this.executor = new ExecutorTuple(this.executor.filter(), (CompletableFuture<Map.Entry<List<EntryStack<?>>, SearchFilter>>)this.executor.future().thenApplyAsync(result -> {
            if (savedFilter == this.filter) {
                consumer.accept((List)result.getKey(), (SearchFilter)result.getValue());
            }
            return result;
        }, (Executor)EXECUTOR_SERVICE));
        return this.executor.future();
    }

    public List<EntryStack<?>> getNow() {
        try {
            return this.get(Runnable::run).get().getKey();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException | CancellationException e) {
            return Lists.newArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Map.Entry<List<EntryStack<?>>, SearchFilter>> get(Executor executor) {
        if (this.isDirty()) {
            Map.Entry<List<EntryStack<?>>, SearchFilter> last;
            AsyncSearchManager asyncSearchManager = this;
            synchronized (asyncSearchManager) {
                last = this.last;
            }
            return AsyncSearchManager.get(this.filter, this.additionalPredicateSupplier.get(), this.transformer, this.stacksProvider.get(), last, this, executor).thenApply(entry -> {
                AsyncSearchManager asyncSearchManager = this;
                synchronized (asyncSearchManager) {
                    this.last = entry;
                }
                return entry;
            });
        }
        return CompletableFuture.completedFuture(this.last);
    }

    public static CompletableFuture<Map.Entry<List<EntryStack<?>>, SearchFilter>> get(SearchFilter filter, Predicate<EntryStack<?>> additionalPredicate, UnaryOperator<EntryStack<?>> transformer, List<EntryStack<?>> stacks, Map.Entry<List<EntryStack<?>>, SearchFilter> last, AsyncSearchManager manager, Executor executor) {
        boolean shouldAsync;
        int searchPartitionSize = ConfigObject.getInstance().getAsyncSearchPartitionSize();
        boolean bl = shouldAsync = ConfigObject.getInstance().shouldAsyncSearch() && stacks.size() > searchPartitionSize * 4;
        if (!stacks.isEmpty()) {
            CompletableFuture<Object> preparationFuture = CompletableFuture.completedFuture(null);
            if (last == null || last.getValue() != filter) {
                Runnable prepare = () -> {
                    if (manager.filter != filter) {
                        throw new CancellationException();
                    }
                    List<ArgumentType<?, ?>> argumentTypes = ((SearchProviderImpl.SearchFilterImpl)filter).getArgumentTypes();
                    Argument.prepareFilter(stacks, argumentTypes, () -> manager.filter() != null && manager.filter() == filter, executor);
                };
                if (shouldAsync) {
                    preparationFuture = CompletableFuture.runAsync(prepare, executor);
                } else {
                    prepare.run();
                    preparationFuture = CompletableFuture.completedFuture(null);
                }
            }
            if (shouldAsync) {
                ArrayList futures = Lists.newArrayList();
                for (Iterable iterable : CollectionUtils.partition(stacks, Math.max(searchPartitionSize, stacks.size() * 3 / Runtime.getRuntime().availableProcessors()))) {
                    futures.add(CompletableFuture.supplyAsync(() -> {
                        ArrayList filtered = Lists.newArrayList();
                        for (EntryStack stack : partitionStacks) {
                            if (stack != null && filter.test(stack) && additionalPredicate.test(stack)) {
                                filtered.add((EntryStack)transformer.apply(stack));
                            }
                            if (manager.filter == filter) continue;
                            throw new CancellationException();
                        }
                        return filtered;
                    }, executor));
                }
                return ((CompletableFuture)((CompletableFuture)preparationFuture.thenCompose($ -> CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).orTimeout(30L, TimeUnit.SECONDS))).thenApplyAsync($ -> {
                    ArrayList list = new ArrayList();
                    if (manager.filter == filter) {
                        for (CompletableFuture future : futures) {
                            List now = future.getNow(null);
                            if (now == null) continue;
                            list.addAll(now);
                        }
                    } else {
                        throw new CancellationException();
                    }
                    return list;
                }, executor)).thenApply(result -> new AbstractMap.SimpleImmutableEntry<List, SearchFilter>((List)result, filter));
            }
            ArrayList<EntryStack> list = new ArrayList<EntryStack>();
            for (EntryStack<?> entryStack : stacks) {
                if (filter.test(entryStack) && additionalPredicate.test(entryStack)) {
                    list.add((EntryStack)transformer.apply(entryStack));
                }
                if (manager.filter == filter) continue;
                throw new CancellationException();
            }
            return CompletableFuture.completedFuture(new AbstractMap.SimpleImmutableEntry(list, filter));
        }
        return CompletableFuture.completedFuture(new AbstractMap.SimpleImmutableEntry<ArrayList, SearchFilter>(Lists.newArrayList(), filter));
    }

    public boolean matches(EntryStack<?> stack) {
        return this.filter.test(stack);
    }

    private record ExecutorTuple(SearchFilter filter, CompletableFuture<Map.Entry<List<EntryStack<?>>, SearchFilter>> future) {
    }
}

