/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.favorites.history;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.gui.widget.favorites.history.DisplayEntry;
import me.shedaniel.rei.impl.client.gui.widget.favorites.history.DisplayHistoryWidget;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class DisplayHistoryManager {
    public static final DisplayHistoryManager INSTANCE = new DisplayHistoryManager();
    private Map<String, DisplayEntry> entries = new LinkedHashMap<String, DisplayEntry>();
    private long lastCheckTime = -1L;

    public Collection<DisplayEntry> getEntries(DisplayHistoryWidget parent) {
        if (!(this.lastCheckTime != -1L && class_156.method_658() - this.lastCheckTime <= 4000L || PluginManager.areAnyReloading())) {
            this.updateEntries(parent);
            this.lastCheckTime = class_156.method_658();
        }
        return Collections.unmodifiableCollection(this.entries.values());
    }

    private void updateEntries(DisplayHistoryWidget parent) {
        List<class_2487> displayHistory = ConfigManagerImpl.getInstance().getConfig().getDisplayHistory();
        LinkedHashMap<String, DisplayEntry> copy = new LinkedHashMap<String, DisplayEntry>(this.entries);
        this.entries.clear();
        for (class_2487 tag : displayHistory) {
            String uuid = tag.method_10558("DisplayHistoryUUID");
            DisplayEntry entry = (DisplayEntry)copy.get(uuid);
            if (entry != null) {
                this.entries.put(entry.getUuid().toString(), entry);
                continue;
            }
            if (!tag.method_10577("DisplayHistoryContains")) continue;
            try {
                CategoryIdentifier categoryIdentifier = CategoryIdentifier.of(tag.method_10558("DisplayHistoryCategory"));
                if (!CategoryRegistry.getInstance().tryGet(categoryIdentifier).isPresent()) continue;
                Object display = DisplaySerializerRegistry.getInstance().read(categoryIdentifier, tag.method_10562("DisplayHistoryData"));
                DisplayEntry newEntry = new DisplayEntry(parent, (Display)display, null);
                newEntry.setUuid(UUID.fromString(uuid));
                this.entries.put(newEntry.getUuid().toString(), newEntry);
            }
            catch (Exception e) {
                InternalLogger.getInstance().warn("Failed to read display history entry", e);
            }
        }
    }

    public void removeEntry(DisplayEntry entry) {
        this.entries.remove(entry.getUuid().toString());
        List<class_2487> displayHistory = ConfigManagerImpl.getInstance().getConfig().getDisplayHistory();
        displayHistory.removeIf(tag -> tag.method_10558("DisplayHistoryUUID").equals(entry.getUuid().toString()));
        this.save();
    }

    public void addEntry(DisplayHistoryWidget parent, @Nullable Rectangle bounds, Display display) {
        List<class_2487> displayHistory = ConfigManagerImpl.getInstance().getConfig().getDisplayHistory();
        Iterator<DisplayEntry> iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            DisplayEntry entry = iterator.next();
            if (entry.getDisplay() != display) continue;
            displayHistory.removeIf(tag -> tag.method_10558("DisplayHistoryUUID").equals(entry.getUuid().toString()));
            iterator.remove();
        }
        DisplayEntry newEntry = new DisplayEntry(parent, display, bounds);
        LinkedHashMap<String, DisplayEntry> copy = new LinkedHashMap<String, DisplayEntry>();
        copy.put(newEntry.getUuid().toString(), newEntry);
        copy.putAll(this.entries);
        this.entries = copy;
        while (this.entries.size() >= 10) {
            DisplayEntry entry = (DisplayEntry)Iterables.get(this.entries.values(), (int)(this.entries.size() - 1));
            displayHistory.removeIf(tag -> tag.method_10558("DisplayHistoryUUID").equals(entry.getUuid().toString()));
            this.entries.remove(entry.getUuid().toString());
        }
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10556("DisplayHistoryContains", false);
        compoundTag.method_10582("DisplayHistoryUUID", newEntry.getUuid().toString());
        compoundTag.method_10582("DisplayHistoryCategory", display.getCategoryIdentifier().toString());
        displayHistory.add(0, compoundTag);
        this.save();
    }

    private void save() {
        List<class_2487> displayHistory = ConfigManagerImpl.getInstance().getConfig().getDisplayHistory();
        for (class_2487 compoundTag : displayHistory) {
            String uuid = compoundTag.method_10558("DisplayHistoryUUID");
            DisplayEntry entry = this.entries.get(uuid);
            if (entry == null) continue;
            compoundTag.method_10556("DisplayHistoryContains", false);
            Display display = entry.getDisplay();
            boolean hasSerializer = DisplaySerializerRegistry.getInstance().hasSerializer(display.getCategoryIdentifier());
            if (!hasSerializer) continue;
            try {
                compoundTag.method_10566("DisplayHistoryData", (class_2520)DisplaySerializerRegistry.getInstance().save(display, new class_2487()));
                compoundTag.method_10556("DisplayHistoryContains", true);
            }
            catch (Exception e) {
                InternalLogger.getInstance().warn("Failed to save display history entry", e);
            }
        }
        ConfigManagerImpl.getInstance().saveConfig();
    }
}

