/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering.rules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.config.entries.FilteringRuleOptionsScreen;
import me.shedaniel.rei.impl.client.entry.filtering.rules.SearchFilteringRule;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import org.jetbrains.annotations.Nullable;

public enum SearchFilteringRuleType implements FilteringRuleType<SearchFilteringRule>
{
    INSTANCE;


    @Override
    public class_2487 saveTo(SearchFilteringRule rule, class_2487 tag) {
        tag.method_10582("filter", rule.filterStr);
        tag.method_10556("show", rule.show);
        return tag;
    }

    @Override
    public SearchFilteringRule readFrom(class_2487 tag) {
        String filter = tag.method_10558("filter");
        boolean show = tag.method_10577("show");
        return new SearchFilteringRule(filter, show);
    }

    @Override
    public SearchFilteringRule createNew() {
        return new SearchFilteringRule("", false);
    }

    @Override
    public class_2561 getTitle(SearchFilteringRule rule) {
        return class_2561.method_43471((String)"rule.roughlyenoughitems.filtering.search");
    }

    @Override
    public class_2561 getSubtitle(SearchFilteringRule rule) {
        return class_2561.method_43471((String)"rule.roughlyenoughitems.filtering.search.subtitle");
    }

    @Override
    @Nullable
    public Function<class_437, class_437> createEntryScreen(SearchFilteringRule rule) {
        return screen -> new FilteringRuleOptionsScreen<SearchFilteringRule>(rule, screen){
            FilteringRuleOptionsScreen.TextFieldRuleEntry entry;
            FilteringRuleOptionsScreen.BooleanRuleEntry show;
            List<EntryWidget> entryStacks;
            {
                this.entry = null;
                this.show = null;
                this.entryStacks = new ArrayList<EntryWidget>();
            }

            @Override
            public void addEntries(Consumer<FilteringRuleOptionsScreen.RuleEntry> entryConsumer) {
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (class_5348)class_2561.method_43471((String)"rule.roughlyenoughitems.filtering.search.filter").method_27692(class_124.field_1080));
                this.entry = new FilteringRuleOptionsScreen.TextFieldRuleEntry(this.field_22789 - 36, this.rule, widget -> {
                    widget.method_1880(9999);
                    widget.method_1863(searchTerm -> {
                        SearchFilter filter = SearchProvider.getInstance().createFilter((String)searchTerm);
                        this.entryStacks = ((Stream)EntryRegistry.getInstance().getEntryStacks().parallel()).filter(filter).map(EntryStack::normalize).map(stack -> new EntryWidget(new Rectangle(0, 0, 18, 18)).noBackground().entry((EntryStack)stack)).collect(Collectors.toList());
                    });
                    if (this.entry != null) {
                        widget.method_1852(this.entry.getWidget().method_1882());
                    } else {
                        widget.method_1852(((SearchFilteringRule)this.rule).filterStr);
                    }
                });
                entryConsumer.accept(this.entry);
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (class_5348)class_2561.method_43471((String)"rule.roughlyenoughitems.filtering.search.show").method_27692(class_124.field_1080));
                Function<Boolean, class_2561> function = bool -> class_2561.method_43471((String)("rule.roughlyenoughitems.filtering.search.show." + bool));
                this.show = new FilteringRuleOptionsScreen.BooleanRuleEntry(this.field_22789 - 36, this.show == null ? ((SearchFilteringRule)this.rule).show : this.show.getBoolean(), this.rule, function);
                entryConsumer.accept(this.show);
                this.addEmpty(entryConsumer, 10);
                entryConsumer.accept(new FilteringRuleOptionsScreen.SubRulesEntry(this.rule, () -> (class_2561)function.apply(this.show == null ? ((SearchFilteringRule)this.rule).show : this.show.getBoolean()), Collections.singletonList(new EntryStacksRuleEntry(this.rule, () -> this.entryStacks))));
            }

            @Override
            public void save() {
                ((SearchFilteringRule)this.rule).setFilter(this.entry.getWidget().method_1882());
                ((SearchFilteringRule)this.rule).show = this.show.getBoolean();
            }
        };
    }

    @Override
    public boolean isSingular() {
        return false;
    }

    public static class EntryStacksRuleEntry
    extends FilteringRuleOptionsScreen.RuleEntry {
        private final Supplier<Iterable<EntryWidget>> entryStacks;
        private int totalHeight;

        public EntryStacksRuleEntry(FilteringRule<?> rule, Supplier<Iterable<EntryWidget>> entryStacks) {
            super(rule);
            this.entryStacks = entryStacks;
        }

        public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            BatchedEntryRendererManager manager = new BatchedEntryRendererManager();
            int entrySize = EntryListWidget.entrySize();
            int width = entryWidth / entrySize;
            int i = 0;
            for (EntryWidget stack : this.entryStacks.get()) {
                stack.getBounds().setLocation(x + i % width * entrySize, y + i / width * entrySize);
                if (stack.getBounds().getMaxY() >= 0 && stack.getBounds().getY() <= class_310.method_1551().method_22683().method_4502()) {
                    manager.add(stack);
                }
                ++i;
            }
            manager.render(matrices, mouseX, mouseY, delta);
            this.totalHeight = (i / width + 1) * entrySize;
        }

        public int getItemHeight() {
            return this.totalHeight;
        }

        public List<? extends class_6379> narratables() {
            return Lists.newArrayList();
        }

        public List<? extends class_364> method_25396() {
            return Lists.newArrayList();
        }
    }
}

