/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.variant_lanterns;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.block.CharmLanternBlock;
import svenhjol.charm.enums.IMetalMaterial;
import svenhjol.charm.enums.VanillaMetalMaterial;
import svenhjol.charm.loader.CharmModule;

@CommonModule(mod="charm", description="Variants lanterns crafted from vanilla metal nuggets and torches.")
public class VariantLanterns
extends CharmModule {
    public static Map<IMetalMaterial, List<CharmLanternBlock>> LANTERNS = new HashMap<IMetalMaterial, List<CharmLanternBlock>>();

    @Override
    public void register() {
        for (IMetalMaterial material : VanillaMetalMaterial.getTypesWithout(VanillaMetalMaterial.IRON)) {
            if (!material.hasNuggets()) continue;
            VariantLanterns.registerLantern(this, material, material.method_15434() + "_lantern");
            VariantLanterns.registerLantern(this, material, material.method_15434() + "_soul_lantern");
        }
    }

    public static CharmLanternBlock registerLantern(CharmModule module, IMetalMaterial material, String name) {
        CharmLanternBlock lantern = new CharmLanternBlock(module, name, material);
        LANTERNS.computeIfAbsent(material, a -> new ArrayList());
        LANTERNS.get(material).add(lantern);
        return lantern;
    }
}

