/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.totem_of_preserving;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import svenhjol.charm.helper.ItemNbtHelper;
import svenhjol.charm.helper.LogHelper;
import svenhjol.charm.helper.TextHelper;
import svenhjol.charm.helper.TotemHelper;
import svenhjol.charm.item.CharmItem;
import svenhjol.charm.loader.CharmModule;

public class TotemOfPreservingItem
extends CharmItem {
    public static final String MESSAGE_TAG = "message";
    public static final String ITEMS_TAG = "items";
    public static final String XP_TAG = "xp";
    public static final String GLINT_TAG = "glint";

    public TotemOfPreservingItem(CharmModule module) {
        super(module, "totem_of_preserving", new class_1792.class_1793().method_7892(class_1761.field_7932).method_7894(class_1814.field_8907).method_24359().method_7889(1));
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public boolean method_7886(class_1799 stack) {
        return TotemOfPreservingItem.hasGlint(stack);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 user, class_1268 hand) {
        class_1799 totem = user.method_5998(hand);
        if (!TotemOfPreservingItem.hasItems(totem)) {
            return class_1271.method_22430((Object)totem);
        }
        List<class_1799> items = TotemOfPreservingItem.getItems(totem);
        int xp = TotemOfPreservingItem.getXp(totem);
        if (xp > 0) {
            level.method_8396(null, user.method_24515(), class_3417.field_14709, class_3419.field_15248, 0.8f, 1.0f);
            user.method_7255(xp);
        }
        TotemHelper.destroy(user, totem);
        if (!level.field_9236) {
            for (class_1799 stack : items) {
                class_2338 pos = user.method_24515();
                class_1542 itemEntity = new class_1542(level, (double)pos.method_10263(), (double)pos.method_10264() + 0.5, (double)pos.method_10260(), stack);
                level.method_8649((class_1297)itemEntity);
            }
        }
        return super.method_7836(level, user, hand);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 context) {
        String message = TotemOfPreservingItem.getMessage(stack);
        List<class_1799> items = TotemOfPreservingItem.getItems(stack);
        if (!message.isEmpty()) {
            tooltip.add((class_2561)TextHelper.literal(message));
        }
        if (!items.isEmpty()) {
            int size = items.size();
            String str = size == 1 ? "totem.charm.preserving.item" : "totem.charm.preserving.items";
            tooltip.add((class_2561)TextHelper.literal(class_1074.method_4662((String)str, (Object[])new Object[]{size})));
        }
        super.method_7851(stack, level, tooltip, context);
    }

    public static void setMessage(class_1799 totem, String message) {
        ItemNbtHelper.setString(totem, MESSAGE_TAG, message);
    }

    public static void setItems(class_1799 totem, List<class_1799> items) {
        class_2487 serialized = new class_2487();
        for (int i = 0; i < items.size(); ++i) {
            class_1799 stack = items.get(i);
            serialized.method_10566(Integer.toString(i), (class_2520)stack.method_7953(new class_2487()));
        }
        ItemNbtHelper.setCompound(totem, ITEMS_TAG, serialized);
    }

    public static void setGlint(class_1799 totem, boolean shiny) {
        ItemNbtHelper.setBoolean(totem, GLINT_TAG, shiny);
    }

    public static void setXp(class_1799 totem, int xp) {
        ItemNbtHelper.setInt(totem, XP_TAG, xp);
    }

    public static String getMessage(class_1799 totem) {
        return ItemNbtHelper.getString(totem, MESSAGE_TAG, "");
    }

    public static boolean hasGlint(class_1799 totem) {
        return ItemNbtHelper.getBoolean(totem, GLINT_TAG, TotemOfPreservingItem.hasItems(totem));
    }

    public static List<class_1799> getItems(class_1799 totem) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        class_2487 itemsTag = ItemNbtHelper.getCompound(totem, ITEMS_TAG);
        Set keys = itemsTag.method_10541();
        for (String key : keys) {
            class_2520 tag = itemsTag.method_10580(key);
            if (tag == null) {
                LogHelper.warn(TotemOfPreservingItem.class, "Missing item with key " + key, new Object[0]);
                continue;
            }
            class_1799 stack = class_1799.method_7915((class_2487)((class_2487)tag));
            items.add(stack);
        }
        return items;
    }

    public static boolean hasItems(class_1799 totem) {
        return !TotemOfPreservingItem.getItems(totem).isEmpty();
    }

    public static int getXp(class_1799 totem) {
        return ItemNbtHelper.getInt(totem, XP_TAG, 0);
    }
}

