/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.totem_of_preserving;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5335;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5819;
import net.minecraft.class_60;
import net.minecraft.class_77;
import net.minecraft.class_79;
import svenhjol.charm.Charm;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.api.event.EntityDropXpCallback;
import svenhjol.charm.api.event.PlayerDropInventoryCallback;
import svenhjol.charm.api.event.TotemOfPreservingEvents;
import svenhjol.charm.helper.ItemHelper;
import svenhjol.charm.helper.LogHelper;
import svenhjol.charm.helper.TextHelper;
import svenhjol.charm.init.CharmAdvancements;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.totem_of_preserving.TotemBlock;
import svenhjol.charm.module.totem_of_preserving.TotemBlockEntity;
import svenhjol.charm.module.totem_of_preserving.TotemOfPreservingChestLootFunction;
import svenhjol.charm.module.totem_of_preserving.TotemOfPreservingItem;
import svenhjol.charm.module.totem_of_preserving.TotemOfPreservingMobLootFunction;
import svenhjol.charm.module.totem_works_from_inventory.TotemWorksFromInventory;
import svenhjol.charm.registry.CommonRegistry;

@CommonModule(mod="charm", description="The player's inventory items will be preserved in the Totem of Preserving upon death.\nBy default, a new totem will always be spawned to preserve items upon dying ('Grave mode').\nIf Grave mode is not enabled, you must be holding a totem in order for it to preserve your items.")
public class TotemOfPreserving
extends CharmModule {
    public static TotemOfPreservingItem ITEM;
    public static class_5339 CHEST_LOOT_FUNCTION;
    public static class_5339 MOB_LOOT_FUNCTION;
    public static final class_2960 CHEST_LOOT_ID;
    public static final class_2960 MOB_LOOT_ID;
    public static final class_2960 TRIGGER_USED_TOTEM_OF_PRESERVING;
    public static final List<class_2960> VALID_MOB_LOOT;
    public static final List<class_2960> VALID_CHEST_LOOT;
    public static final class_2960 BLOCK_ID;
    public static TotemBlock BLOCK;
    public static class_2591<TotemBlockEntity> BLOCK_ENTITY;
    public static Map<class_2960, List<class_2338>> PROTECT_POSITIONS;
    @Config(name="Grave mode", description="If true, a new totem will be spawned to preserve items upon dying.\nPlayers do NOT need to be holding a Totem of Preserving.")
    public static boolean graveMode;
    @Config(name="Owner only", description="If true, only the owner of the totem may pick it up.")
    public static boolean ownerOnly;
    @Config(name="Mobs drop totems", description="Mobs that have a chance to drop a totem of preserving.\nThis does not apply if Grave mode is true.")
    public static List<String> configMobDrops;
    @Config(name="Chests contain totems", description="Chest loot tables that will always contain a totem of preserving.\nThis does not apply if Grave mode is true.")
    public static List<String> configChestLoot;
    @Config(name="Preserve XP", description="If true, the totem will preserve the player's experience and restore when broken.")
    public static boolean preserveXp;
    @Config(name="Show death position", description="If true, the coordinates where you died will be added to the player's chat screen.")
    public static boolean showDeathPosition;

    @Override
    public void register() {
        ITEM = new TotemOfPreservingItem(this);
        BLOCK = new TotemBlock(this);
        BLOCK_ENTITY = CommonRegistry.blockEntity(BLOCK_ID, TotemBlockEntity::new, new class_2248[]{BLOCK});
        configMobDrops.stream().map(class_2960::new).forEach(VALID_MOB_LOOT::add);
        configChestLoot.stream().map(class_2960::new).forEach(VALID_CHEST_LOOT::add);
    }

    @Override
    public void runWhenEnabled() {
        ItemHelper.ITEM_LIFETIME.put(ITEM, Integer.MAX_VALUE);
        CHEST_LOOT_FUNCTION = CommonRegistry.lootFunctionType(CHEST_LOOT_ID, new class_5339((class_5335)new TotemOfPreservingChestLootFunction.Serializer()));
        MOB_LOOT_FUNCTION = CommonRegistry.lootFunctionType(MOB_LOOT_ID, new class_5339((class_5335)new TotemOfPreservingMobLootFunction.Serializer()));
        PlayerDropInventoryCallback.EVENT.register(this::handleDropInventory);
        EntityDropXpCallback.BEFORE.register(this::handleDropXp);
        LootTableEvents.MODIFY.register(this::handleLootTables);
    }

    private void handleLootTables(class_3300 resourceManager, class_60 lootTables, class_2960 id, class_52.class_53 supplier, LootTableSource source) {
        if (VALID_MOB_LOOT.contains(id) || VALID_CHEST_LOOT.contains(id)) {
            class_55.class_56 builder = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8162).method_437(1).method_438(() -> {
                if (VALID_CHEST_LOOT.contains(id)) {
                    return new TotemOfPreservingChestLootFunction(new class_5341[0]);
                }
                return new TotemOfPreservingMobLootFunction(new class_5341[0]);
            }));
            supplier.method_336(builder);
        }
    }

    public class_1269 handleDropXp(class_1309 entity) {
        if (!preserveXp || !(entity instanceof class_1657) || entity.field_6002.field_9236) {
            return class_1269.field_5811;
        }
        return class_1269.field_5812;
    }

    public class_1269 handleDropInventory(class_1657 player, class_1661 inventory) {
        class_2586 tryPos;
        int y;
        int tries;
        int minHeight;
        int maxHeight;
        class_2338 spawnPos;
        class_2338 pos;
        ArrayList<class_1799> preserve;
        ImmutableList inventories;
        class_5819 random;
        String message;
        UUID uuid;
        class_3222 serverPlayer;
        class_3218 serverLevel;
        block20: {
            block21: {
                class_3610 fluid;
                block19: {
                    if (player.field_6002.method_8608()) {
                        return class_1269.field_5811;
                    }
                    serverLevel = (class_3218)player.field_6002;
                    serverPlayer = (class_3222)player;
                    uuid = serverPlayer.method_5667();
                    message = serverPlayer.method_5820();
                    random = serverPlayer.method_6051();
                    class_1799 totemItem = new class_1799((class_1935)ITEM);
                    boolean totemWorksFromInventory = Charm.LOADER.isEnabled(TotemWorksFromInventory.class);
                    inventories = ImmutableList.of((Object)inventory.field_7547, (Object)inventory.field_7548, (Object)inventory.field_7544);
                    ArrayList itemsFromAllInventories = new ArrayList();
                    inventories.forEach(list -> list.stream().filter(Objects::nonNull).filter(stack -> !stack.method_7960()).forEach(itemsFromAllInventories::add));
                    if (!graveMode && !totemWorksFromInventory) {
                        boolean holding = false;
                        for (class_1268 hand : class_1268.values()) {
                            class_1799 held = player.method_5998(hand);
                            if (held.method_7909() != ITEM || TotemOfPreservingItem.hasItems(totemItem)) continue;
                            holding = true;
                            break;
                        }
                        if (!holding) {
                            LogHelper.debug(this.getClass(), "No empty totem in hands (graveMode = false && totemWorksFromInventory = false), skipping", new Object[0]);
                            return class_1269.field_5811;
                        }
                    }
                    boolean foundEmptyTotem = false;
                    preserve = new ArrayList<class_1799>();
                    for (class_1799 stack : itemsFromAllInventories) {
                        if (stack.method_7909() == ITEM && !graveMode && !foundEmptyTotem) {
                            LogHelper.debug(this.getClass(), "An empty totem was found (graveMode = false), going to try and add items to this totem", new Object[0]);
                            foundEmptyTotem = true;
                            continue;
                        }
                        class_1269 result = ((TotemOfPreservingEvents.BeforeAddStackInvoker)TotemOfPreservingEvents.BEFORE_ADD_STACK.invoker()).invoke(serverPlayer, stack);
                        if (result == class_1269.field_5814) continue;
                        preserve.add(stack);
                    }
                    if (!foundEmptyTotem && !graveMode) {
                        LogHelper.debug(this.getClass(), "No empty totem found (gravemode = false), giving up.", new Object[0]);
                        return class_1269.field_5811;
                    }
                    if (itemsFromAllInventories.isEmpty()) {
                        LogHelper.debug(this.getClass(), "No items found to store in totem, giving up.", new Object[0]);
                        return class_1269.field_5811;
                    }
                    pos = serverPlayer.method_24515();
                    class_1297 vehicle = serverPlayer.method_5854();
                    if (vehicle != null) {
                        pos = vehicle.method_24515();
                    }
                    spawnPos = null;
                    maxHeight = serverLevel.method_31600() - 1;
                    minHeight = serverLevel.method_31607() + 1;
                    class_2680 state = serverLevel.method_8320(pos);
                    fluid = serverLevel.method_8316(pos);
                    if (pos.method_10264() < minHeight) {
                        LogHelper.debug(this.getClass(), "(Void check) Adjusting, new pos: " + pos, new Object[0]);
                        pos = new class_2338(pos.method_10263(), serverLevel.method_8615(), pos.method_10260());
                    }
                    if (!state.method_26215() && !fluid.method_15767(class_3486.field_15517)) break block19;
                    LogHelper.debug(this.getClass(), "(Standard check) Found an air/water block to spawn in: " + pos, new Object[0]);
                    spawnPos = pos;
                    break block20;
                }
                if (!fluid.method_15767(class_3486.field_15518)) break block21;
                for (tries = 0; tries < 20 && (y = pos.method_10264() + tries) < maxHeight; ++tries) {
                    class_2338 tryPos2 = new class_2338(pos.method_10263(), y, pos.method_10260());
                    class_2680 tryState = serverLevel.method_8320(tryPos2);
                    class_3610 tryFluid = serverLevel.method_8316(tryPos2);
                    if (tryFluid.method_15767(class_3486.field_15518)) continue;
                    if (!tryState.method_26215() && !tryFluid.method_15767(class_3486.field_15517)) break;
                    LogHelper.debug(this.getClass(), "(Lava check) Found an air/water block to spawn in after checking " + tries + " times: " + pos, new Object[0]);
                    spawnPos = tryPos2;
                    break;
                }
                if (spawnPos != null) break block20;
                LogHelper.debug(this.getClass(), "(Lava check) Going to replace lava with totem at: " + pos, new Object[0]);
                spawnPos = pos;
                break block20;
            }
            List<class_2350> directions = Arrays.asList(class_2350.field_11036, class_2350.field_11034, class_2350.field_11043, class_2350.field_11039, class_2350.field_11035);
            for (class_2350 direction : directions) {
                class_2338 tryPos3 = pos.method_10093(direction);
                class_2680 tryState = serverLevel.method_8320(tryPos3);
                class_3610 tryFluid = serverLevel.method_8316(tryPos3);
                if (tryPos3.method_10264() >= maxHeight || !tryState.method_26215() && !tryFluid.method_15767(class_3486.field_15517)) continue;
                LogHelper.debug(this.getClass(), "(Solid check) Found an air/water block to spawn in, direction: " + direction + ", pos: " + pos, new Object[0]);
                spawnPos = tryPos3;
                break;
            }
        }
        if (spawnPos == null) {
            for (tries = 0; tries < 8; ++tries) {
                int x = pos.method_10263() + random.method_43048(tries + 1) - tries;
                int z = pos.method_10260() + random.method_43048(tries + 1) - tries;
                int y2 = pos.method_10264() + tries;
                if (y2 > maxHeight && (y2 = pos.method_10264() - tries) < minHeight) continue;
                tryPos = new class_2338(x, y2, z);
                class_2680 tryState = serverLevel.method_8320((class_2338)tryPos);
                class_3610 tryFluid = serverLevel.method_8316((class_2338)tryPos);
                if (!tryState.method_26215() && !tryFluid.method_15767(class_3486.field_15517)) continue;
                LogHelper.debug(this.getClass(), "(Distance check) Found an air/water block to spawn in after checking " + tries + " times: " + pos, new Object[0]);
                spawnPos = tryPos;
                break;
            }
        }
        if (spawnPos == null) {
            LogHelper.debug(this.getClass(), "Could not find a block to spawn totem, giving up.", new Object[0]);
            return class_1269.field_5811;
        }
        int x = spawnPos.method_10263();
        y = spawnPos.method_10264();
        int z = spawnPos.method_10260();
        serverLevel.method_8501(spawnPos, BLOCK.method_9564());
        tryPos = serverLevel.method_8321(spawnPos);
        if (!(tryPos instanceof TotemBlockEntity)) {
            LogHelper.debug(this.getClass(), "Not a valid block entity at pos, giving up. Pos: " + pos, new Object[0]);
            return class_1269.field_5811;
        }
        TotemBlockEntity totem = (TotemBlockEntity)tryPos;
        if (preserveXp) {
            int xp = serverPlayer.field_7495;
            LogHelper.debug(this.getClass(), "Preserving player XP in totem: " + xp, new Object[0]);
            totem.setXp(xp);
        }
        totem.setItems(preserve);
        totem.setMessage(message);
        totem.setOwner(uuid);
        totem.method_5431();
        PROTECT_POSITIONS.computeIfAbsent(serverLevel.method_27983().method_29177(), a -> new ArrayList()).add(spawnPos);
        TotemOfPreserving.triggerUsedTotemOfPreserving(serverPlayer);
        LogHelper.info(this.getClass(), "Spawned a totem at: " + spawnPos, new Object[0]);
        for (class_2371 inv : inventories) {
            Collections.fill(inv, class_1799.field_8037);
        }
        if (showDeathPosition) {
            player.method_7353((class_2561)TextHelper.translatable("gui.charm.totem_of_preserving.deathpos", x, y, z), false);
        }
        return class_1269.field_5812;
    }

    public static void triggerUsedTotemOfPreserving(class_3222 player) {
        CharmAdvancements.ACTION_PERFORMED.trigger(player, TRIGGER_USED_TOTEM_OF_PRESERVING);
    }

    static {
        CHEST_LOOT_ID = new class_2960("charm", "totem_of_preserving_chest_loot");
        MOB_LOOT_ID = new class_2960("charm", "totem_of_preserving_mob_loot");
        TRIGGER_USED_TOTEM_OF_PRESERVING = new class_2960("charm", "used_totem_of_preserving");
        VALID_MOB_LOOT = new ArrayList<class_2960>();
        VALID_CHEST_LOOT = new ArrayList<class_2960>();
        BLOCK_ID = new class_2960("charm", "totem_block");
        PROTECT_POSITIONS = new HashMap<class_2960, List<class_2338>>();
        graveMode = true;
        ownerOnly = false;
        configMobDrops = Arrays.asList("entities/witch", "entities/pillager");
        configChestLoot = Arrays.asList("chests/pillager_outpost", "chests/woodland_mansion");
        preserveXp = false;
        showDeathPosition = false;
    }
}

