/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.raid_horns;

import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3732;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.api.event.EntityDropItemsCallback;
import svenhjol.charm.init.CharmAdvancements;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.extra_wandering_trades.ExtraWanderingTrades;
import svenhjol.charm.module.raid_horns.RaidHornItem;
import svenhjol.charm.registry.CommonRegistry;

@CommonModule(mod="charm", description="Raid horns are sometimes dropped from raid leaders and can be used to call off or start raids.")
public class RaidHorns
extends CharmModule {
    public static RaidHornItem RAID_HORN;
    public static class_3414 CALL_PATROL_SOUND;
    public static class_3414 CALL_OFF_RAID_SOUND;
    public static class_3414 SQUEAK_SOUND;
    public static final class_2960 TRIGGER_SUMMONED_PILLAGERS;
    public static final class_2960 TRIGGER_CALLED_OFF_RAID;
    public static double lootingBoost;
    @Config(name="Drop chance", description="Chance (out of 1.0) of a patrol captain dropping a raid horn when killed by the player.")
    public static double dropChance;
    @Config(name="Volume", description="Volume of the raid horn sound effect when used.  1.0 is maximum volume.")
    public static double volume;

    @Override
    public void register() {
        RAID_HORN = new RaidHornItem(this);
        CALL_PATROL_SOUND = CommonRegistry.sound(new class_2960("charm", "raid_horn_call_patrol"));
        CALL_OFF_RAID_SOUND = CommonRegistry.sound(new class_2960("charm", "raid_horn_call_off_raid"));
        SQUEAK_SOUND = CommonRegistry.sound(new class_2960("charm", "raid_horn_squeak"));
    }

    @Override
    public void runWhenEnabled() {
        EntityDropItemsCallback.AFTER.register(this::tryDrop);
        ExtraWanderingTrades.registerRareItem((class_1935)RAID_HORN, 1, 30);
    }

    public class_1269 tryDrop(class_1309 entity, class_1282 source, int lootingLevel) {
        if (!entity.field_6002.field_9236 && entity instanceof class_3732 && source.method_5529() instanceof class_1657 && (double)entity.field_6002.field_9229.method_43057() <= dropChance + lootingBoost * (double)lootingLevel && ((class_3732)entity).method_16219()) {
            class_2338 pos = entity.method_24515();
            class_1799 potion = new class_1799((class_1935)RAID_HORN);
            entity.field_6002.method_8649((class_1297)new class_1542(entity.method_5770(), (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), potion));
        }
        return class_1269.field_5811;
    }

    public static void triggerSummoned(class_3222 playerEntity) {
        CharmAdvancements.ACTION_PERFORMED.trigger(playerEntity, TRIGGER_SUMMONED_PILLAGERS);
    }

    public static void triggerCalledOff(class_3222 playerEntity) {
        CharmAdvancements.ACTION_PERFORMED.trigger(playerEntity, TRIGGER_CALLED_OFF_RAID);
    }

    static {
        TRIGGER_SUMMONED_PILLAGERS = new class_2960("charm", "summoned_pillagers");
        TRIGGER_CALLED_OFF_RAID = new class_2960("charm", "called_off_raid");
        lootingBoost = 0.25;
        dropChance = 0.05;
        volume = 0.75;
    }
}

