/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.extra_boats;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1690;
import net.minecraft.class_1749;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.variant_chests.VariantChests;
import svenhjol.charm.registry.CommonRegistry;

@CommonModule(mod="charm", priority=5, alwaysEnabled=true, description="Allows Charm to register extra boat types.")
public class ExtraBoats
extends CharmModule {
    private static final Map<class_1690.class_1692, class_1749> BOAT_TYPE_TO_BOAT = new HashMap<class_1690.class_1692, class_1749>();
    private static final Map<class_1690.class_1692, class_1749> BOAT_TYPE_TO_CHEST_BOAT = new HashMap<class_1690.class_1692, class_1749>();

    public static void registerBoat(class_2960 id, class_1690.class_1692 type, class_1749 boat, class_1749 chestBoat) {
        String namespace = id.method_12836();
        String path = id.method_12832();
        CommonRegistry.item(new class_2960(namespace, path + "_boat"), (class_1792)boat);
        CommonRegistry.item(new class_2960(namespace, path + "_chest_boat"), (class_1792)chestBoat);
        BOAT_TYPE_TO_BOAT.put(type, boat);
        BOAT_TYPE_TO_CHEST_BOAT.put(type, chestBoat);
    }

    @Override
    public void runWhenEnabled() {
        for (class_1690.class_1692 type : BOAT_TYPE_TO_BOAT.keySet()) {
            class_1749 boat = BOAT_TYPE_TO_BOAT.get(type);
            class_1749 chestBoat = BOAT_TYPE_TO_CHEST_BOAT.get(type);
            if (boat == null || chestBoat == null) continue;
            VariantChests.CHEST_BOATS.put((class_1792)boat, (class_1792)chestBoat);
        }
    }

    @Nullable
    public static class_1749 getBoatByType(class_1690.class_1692 type) {
        return BOAT_TYPE_TO_BOAT.getOrDefault(type, null);
    }

    @Nullable
    public static class_1749 getChestBoatByType(class_1690.class_1692 type) {
        return BOAT_TYPE_TO_CHEST_BOAT.getOrDefault(type, null);
    }
}

