/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.endermite_powder;

import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1542;
import net.minecraft.class_1559;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_4048;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.api.event.EntityDropItemsCallback;
import svenhjol.charm.helper.ItemHelper;
import svenhjol.charm.init.CharmAdvancements;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.endermite_powder.EndermitePowderEntity;
import svenhjol.charm.module.endermite_powder.EndermitePowderItem;
import svenhjol.charm.module.extra_wandering_trades.ExtraWanderingTrades;
import svenhjol.charm.registry.CommonRegistry;

@CommonModule(mod="charm", description="Endermites drop endermite powder that can be used to locate an End City.")
public class EndermitePowder
extends CharmModule {
    public static class_2960 ID = new class_2960("charm", "endermite_powder");
    public static class_1299<EndermitePowderEntity> ENTITY;
    public static EndermitePowderItem ENDERMITE_POWDER;
    public static class_3414 LAUNCH_SOUND;
    public static double lootingBoost;
    @Config(name="Maximum drops", description="Maximum endermite powder dropped when endermite is killed.")
    public static int maxDrops;

    @Override
    public void register() {
        ENDERMITE_POWDER = new EndermitePowderItem(this);
        LAUNCH_SOUND = CommonRegistry.sound(new class_2960("charm", "endermite_powder_launch"));
        ENTITY = CommonRegistry.entity(ID, FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, EndermitePowderEntity::new).trackRangeBlocks(80).trackedUpdateRate(10).dimensions(class_4048.method_18385((float)2.0f, (float)2.0f)));
    }

    @Override
    public void runWhenEnabled() {
        EntityDropItemsCallback.AFTER.register(this::tryDrop);
        ExtraWanderingTrades.registerRareItem((class_1935)ENDERMITE_POWDER, 3, 12);
    }

    private class_1269 tryDrop(class_1297 entity, class_1282 source, int lootingLevel) {
        if (!entity.field_6002.field_9236 && entity instanceof class_1559) {
            class_1937 level = entity.method_5770();
            class_2338 pos = entity.method_24515();
            int amount = ItemHelper.getAmountWithLooting(level.field_9229, maxDrops, lootingLevel, (float)lootingBoost);
            level.method_8649((class_1297)new class_1542(level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), new class_1799((class_1935)ENDERMITE_POWDER, amount)));
        }
        return class_1269.field_5811;
    }

    public static void triggerAdvancement(class_3222 playerEntity) {
        CharmAdvancements.ACTION_PERFORMED.trigger(playerEntity, new class_2960("charm", "used_endermite_powder"));
    }

    static {
        lootingBoost = 0.3;
        maxDrops = 2;
    }
}

