/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.bookcases;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3917;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.enums.IWoodMaterial;
import svenhjol.charm.enums.VanillaWoodMaterial;
import svenhjol.charm.init.CharmAdvancements;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.bookcases.BookcaseBlock;
import svenhjol.charm.module.bookcases.BookcaseBlockEntity;
import svenhjol.charm.module.bookcases.BookcaseMenu;
import svenhjol.charm.registry.CommonRegistry;

@CommonModule(mod="charm", description="Bookcases hold up to 9 stacks of books, paper and maps.")
public class Bookcases
extends CharmModule {
    public static final Map<IWoodMaterial, BookcaseBlock> BOOKCASE_BLOCKS = new HashMap<IWoodMaterial, BookcaseBlock>();
    public static final List<class_1792> VALID_ITEMS = new ArrayList<class_1792>();
    public static final class_2960 ID = new class_2960("charm", "bookcase");
    public static class_2591<BookcaseBlockEntity> BLOCK_ENTITY;
    public static class_3917<BookcaseMenu> MENU;
    public static class_3414 BOOKCASE_OPEN_SOUND;
    public static class_3414 BOOKCASE_CLOSE_SOUND;
    public static final class_2960 TRIGGER_ADDED_BOOK_TO_BOOKCASE;
    @Config(name="Valid items", description="Items that may be placed in bookcases.")
    public static List<String> configValidItems;

    @Override
    public void register() {
        BLOCK_ENTITY = CommonRegistry.blockEntity(ID, BookcaseBlockEntity::new, new class_2248[0]);
        MENU = CommonRegistry.menu(ID, BookcaseMenu::new);
        BOOKCASE_OPEN_SOUND = CommonRegistry.sound(new class_2960("charm", "bookcase_open"));
        BOOKCASE_CLOSE_SOUND = CommonRegistry.sound(new class_2960("charm", "bookcase_close"));
        for (VanillaWoodMaterial material : VanillaWoodMaterial.values()) {
            Bookcases.registerBookcase(this, material);
        }
        for (String configItem : configValidItems) {
            class_2378.field_11142.method_17966(new class_2960(configItem)).ifPresent(Bookcases::registerValidItem);
        }
    }

    public static BookcaseBlock registerBookcase(CharmModule module, IWoodMaterial material) {
        BookcaseBlock bookcase = new BookcaseBlock(module, material);
        BOOKCASE_BLOCKS.put(material, bookcase);
        return bookcase;
    }

    public static void registerValidItem(class_1792 validItem) {
        if (!VALID_ITEMS.contains(validItem)) {
            VALID_ITEMS.add(validItem);
        }
    }

    public static boolean isValidItem(class_1799 stack) {
        return VALID_ITEMS.contains(stack.method_7909());
    }

    public static void triggerAddedBookToBookcase(class_3222 player) {
        CharmAdvancements.ACTION_PERFORMED.trigger(player, TRIGGER_ADDED_BOOK_TO_BOOKCASE);
    }

    static {
        TRIGGER_ADDED_BOOK_TO_BOOKCASE = new class_2960("charm", "added_book_to_bookcase");
        configValidItems = Arrays.asList("minecraft:book", "minecraft:enchanted_book", "minecraft:written_book", "minecraft:writable_book", "minecraft:knowledge_book", "minecraft:paper", "minecraft:map", "minecraft:filled_map");
    }
}

